/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity.pigzombie;

import fathertoast.specialmobs.ai.IAngler;
import fathertoast.specialmobs.bestiary.BestiaryInfo;
import fathertoast.specialmobs.config.Config;
import fathertoast.specialmobs.entity.SpecialMobData;
import fathertoast.specialmobs.entity.pigzombie.Entity_SpecialPigZombie;
import fathertoast.specialmobs.entity.projectile.EntitySpecialFishHook;
import fathertoast.specialmobs.loot.LootEntryItemBuilder;
import fathertoast.specialmobs.loot.LootPoolBuilder;
import fathertoast.specialmobs.loot.LootTableBuilder;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;

public class EntityFishingPigZombie
extends Entity_SpecialPigZombie
implements IAngler {
    private static final DataParameter<Boolean> IS_LINE_OUT = EntityDataManager.func_187226_a(EntityFishingPigZombie.class, (DataSerializer)DataSerializers.field_187198_h);
    public static ResourceLocation LOOT_TABLE;
    private int rodTime = 0;
    private EntitySpecialFishHook fishHook = null;

    public static BestiaryInfo GET_BESTIARY_INFO() {
        BestiaryInfo info = new BestiaryInfo(2966004);
        info.weightExceptions = BestiaryInfo.DEFAULT_THEME_FISHING;
        return info;
    }

    public static void BUILD_LOOT_TABLE(LootTableBuilder loot) {
        EntityFishingPigZombie.ADD_BASE_LOOT(loot);
        loot.addCommonDrop("common", "Fish", Items.field_179566_aV);
        loot.addPool(new LootPoolBuilder("rare").addConditions(LootPoolBuilder.RARE_CONDITIONS).addEntry((LootEntry)new LootEntryItemBuilder("Fishing rod", (Item)Items.field_151112_aM).enchant(30, true).toLootEntry()).toLootPool());
    }

    public EntityFishingPigZombie(World world) {
        super(world);
        this.getSpecialData().setCanBreatheInWater(true);
        this.getSpecialData().setIgnoreWaterPush(true);
    }

    protected ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_LINE_OUT, (Object)Boolean.FALSE);
    }

    @Override
    protected void adjustTypeAttributes() {
        this.field_70728_aV += 2;
        this.getSpecialData().multAttribute(SharedMonsterAttributes.field_111263_d, 0.8);
    }

    @Override
    protected void initTypeAI() {
        this.getSpecialData().rangedAttackSpread = 10.0f;
        this.getSpecialData().rangedAttackCooldown = 32;
        this.getSpecialData().rangedAttackMaxCooldown = 48;
        this.getSpecialData().rangedAttackMaxRange = 10.0f;
    }

    @Override
    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151112_aM));
        if (this.func_184582_a(EntityEquipmentSlot.FEET).func_190926_b()) {
            ItemStack booties = new ItemStack((Item)Items.field_151021_T);
            Items.field_151021_T.func_82813_b(booties, 0xFFFF00);
            this.func_184201_a(EntityEquipmentSlot.FEET, booties);
        }
        this.func_98053_h(false);
    }

    @Override
    public void func_70636_d() {
        EntityLivingBase target;
        super.func_70636_d();
        if (this.rodTime > 0) {
            --this.rodTime;
        }
        if (!this.field_70170_p.field_72995_K && this.rodTime <= 0 && !this.isLineOut() && (target = this.func_70638_az()) != null) {
            SpecialMobData data = this.getSpecialData();
            float distanceSq = (float)this.func_70068_e((Entity)target);
            if (distanceSq > 16.0f && distanceSq < data.rangedAttackMaxRange * data.rangedAttackMaxRange && this.func_70635_at().func_75522_a((Entity)target)) {
                new EntitySpecialFishHook(this.field_70170_p, (EntityLiving)this, (Entity)target);
                this.field_70170_p.func_72838_d((Entity)this.getFishHook());
                this.func_184185_a(SoundEvents.field_187612_G, 0.5f, 0.4f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
                this.rodTime = this.field_70146_Z.nextInt(Math.max(1, data.rangedAttackMaxCooldown - data.rangedAttackCooldown)) + data.rangedAttackCooldown;
            }
        }
    }

    @Override
    public void setFishHook(EntitySpecialFishHook hook) {
        this.fishHook = hook;
        this.func_184212_Q().func_187227_b(IS_LINE_OUT, (Object)(hook != null ? 1 : 0));
    }

    @Override
    public EntitySpecialFishHook getFishHook() {
        return this.fishHook;
    }

    @Override
    public boolean isLineOut() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_LINE_OUT);
    }

    @Nonnull
    public ItemStack func_184582_a(EntityEquipmentSlot slot) {
        if (!Config.get().GENERAL.FANCY_FISHING_MOBS && EntityEquipmentSlot.MAINHAND.equals((Object)slot)) {
            ItemStack held = super.func_184582_a(slot);
            if (this.field_70170_p.field_72995_K && !held.func_190926_b() && held.func_77973_b() instanceof ItemFishingRod && this.isLineOut()) {
                return new ItemStack(Items.field_151055_y);
            }
            return held;
        }
        return super.func_184582_a(slot);
    }
}

