/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity.lavaslime;

import fathertoast.specialmobs.bestiary.BestiaryInfo;
import fathertoast.specialmobs.entity.lavaslime.Entity_SpecialLavaSlime;
import fathertoast.specialmobs.loot.LootTableBuilder;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.init.Items;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityStickyLavaSlime
extends Entity_SpecialLavaSlime {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(EntityStickyLavaSlime.GET_TEXTURE_PATH("sticky"))};
    public static ResourceLocation LOOT_TABLE;
    private int grabTime;

    public static BestiaryInfo GET_BESTIARY_INFO() {
        BestiaryInfo info = new BestiaryInfo(10318655);
        return info;
    }

    public static void BUILD_LOOT_TABLE(LootTableBuilder loot) {
        EntityStickyLavaSlime.ADD_BASE_LOOT(loot);
        loot.addCommonDrop("common", "Slime balls", Items.field_151123_aH);
    }

    public EntityStickyLavaSlime(World world) {
        super(world);
    }

    @Override
    protected EntitySlime getSplitSlime() {
        return new EntityStickyLavaSlime(this.field_70170_p);
    }

    @Override
    public ResourceLocation[] getDefaultTextures() {
        return TEXTURES;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return this.func_189101_db() ? LOOT_TABLE : LootTableList.field_186419_a;
    }

    @Override
    protected void adjustTypeAttributes() {
        this.slimeExperienceValue += 2;
    }

    @Override
    protected void adjustTypeAttributesForSize(int size) {
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111267_a, 4.0 * (double)size);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        --this.grabTime;
        List riders = this.func_184188_bt();
        if (this.grabTime <= 0 && !riders.isEmpty()) {
            for (Entity rider : riders) {
                if (!(rider instanceof EntityLivingBase)) continue;
                rider.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this).func_76348_h(), 1.0f);
                this.grabTime = 20;
            }
        }
    }

    @Override
    protected void onTypeAttack(Entity target) {
        if (this.grabTime <= -20 && this.func_184188_bt().isEmpty() && target.func_184205_a((Entity)this, true)) {
            this.grabTime = 20;
        }
    }
}

