/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity.creeper;

import fathertoast.specialmobs.ObfuscationHelper;
import fathertoast.specialmobs.bestiary.BestiaryInfo;
import fathertoast.specialmobs.config.Config;
import fathertoast.specialmobs.entity.ISpecialMob;
import fathertoast.specialmobs.entity.SpecialMobData;
import fathertoast.specialmobs.loot.LootTableBuilder;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Entity_SpecialCreeper
extends EntityCreeper
implements ISpecialMob {
    private static final String TAG_DRY_EXPLODE = "DryExplode";
    private static final String TAG_WHEN_BURNING_EXPLODE = "BurningExplode";
    private static final String TAG_WHEN_SHOT_EXPLODE = "ShotExplode";
    private static final String TAG_FUSE_TIME = "Fuse";
    private static final String TAG_EXPLOSION_RADIUS = "ExplosionRadius";
    private static final DataParameter<Float> SCALE = EntityDataManager.func_187226_a(Entity_SpecialCreeper.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Byte> EXPLODE_FLAGS = EntityDataManager.func_187226_a(Entity_SpecialCreeper.class, (DataSerializer)DataSerializers.field_187191_a);
    static final DataParameter<Boolean> POWERED = ObfuscationHelper.EntityCreeper_POWERED.get();
    private static final byte EXPLODE_FLAG_DEFUSE_IN_WATER = 1;
    private static final byte EXPLODE_FLAG_ON_FIRE = 2;
    private static final byte EXPLODE_FLAG_WHEN_SHOT = 4;
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("textures/entity/creeper/creeper.png")};
    private SpecialMobData specialData;
    public int field_70833_d;
    public int field_70834_e;
    public int field_82225_f = 30;
    public int field_82226_g = 3;
    private boolean playingDead = false;

    public static BestiaryInfo GET_BESTIARY_INFO() {
        BestiaryInfo info = new BestiaryInfo(0);
        return info;
    }

    static String GET_TEXTURE_PATH(String type) {
        return "specialmobs:textures/entity/creeper/" + type + ".png";
    }

    static void ADD_BASE_LOOT(LootTableBuilder loot) {
        loot.addLootTable("main", "Base loot", LootTableList.field_186434_p);
    }

    public Entity_SpecialCreeper(World world) {
        super(world);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.initTypeAI();
    }

    protected void initTypeAI() {
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.specialData = new SpecialMobData<Entity_SpecialCreeper>(this, SCALE);
        this.field_70180_af.func_187214_a(EXPLODE_FLAGS, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.applyAttributeAdjustments();
    }

    protected void adjustTypeAttributes() {
    }

    @Override
    public final SpecialMobData getSpecialData() {
        return this.specialData;
    }

    @Override
    public final void applyAttributeAdjustments() {
        float prevMax = this.func_110138_aP();
        this.adjustTypeAttributes();
        this.func_70606_j(this.func_110138_aP() + this.func_110143_aJ() - prevMax);
    }

    @Override
    public final int getExperience() {
        return this.field_70728_aV;
    }

    @Override
    public final void setExperience(int xp) {
        this.field_70728_aV = xp;
    }

    @Override
    public final void setImmuneToFire(boolean immune) {
        this.field_70178_ae = immune;
    }

    @Override
    public ResourceLocation[] getDefaultTextures() {
        return TEXTURES;
    }

    public boolean canNotExplodeWhenWet() {
        return this.getExplodeFlag((byte)1);
    }

    public void setCanNotExplodeWhenWet(boolean value) {
        this.setExplodeFlag((byte)1, value);
        if (value) {
            this.func_184644_a(PathNodeType.WATER, PathNodeType.LAVA.func_186289_a());
        } else {
            this.func_184644_a(PathNodeType.WATER, PathNodeType.WATER.func_186289_a());
        }
    }

    public boolean explodesWhenBurning() {
        return this.getExplodeFlag((byte)2);
    }

    public void setExplodesWhenBurning(boolean value) {
        this.setExplodeFlag((byte)2, value);
        if (value) {
            this.func_184644_a(PathNodeType.DANGER_FIRE, PathNodeType.DAMAGE_FIRE.func_186289_a());
            this.func_184644_a(PathNodeType.DAMAGE_FIRE, PathNodeType.BLOCKED.func_186289_a());
        } else {
            this.func_184644_a(PathNodeType.DANGER_FIRE, PathNodeType.DANGER_FIRE.func_186289_a());
            this.func_184644_a(PathNodeType.DAMAGE_FIRE, PathNodeType.DAMAGE_FIRE.func_186289_a());
        }
    }

    public boolean explodesWhenShot() {
        return this.getExplodeFlag((byte)4);
    }

    public void setExplodesWhenShot(boolean value) {
        this.setExplodeFlag((byte)4, value);
    }

    private boolean getExplodeFlag(byte flag) {
        return ((Byte)this.field_70180_af.func_187225_a(EXPLODE_FLAGS) & flag) != 0;
    }

    private void setExplodeFlag(byte flag, boolean value) {
        byte allFlags = (Byte)this.field_70180_af.func_187225_a(EXPLODE_FLAGS);
        if (value == ((allFlags & flag) == 0)) {
            this.field_70180_af.func_187227_b(EXPLODE_FLAGS, (Object)((byte)(allFlags ^ flag)));
        }
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        super.func_70077_a(lightningBolt);
        if (this.explodesWhenBurning()) {
            this.func_70066_B();
        }
    }

    public boolean func_70089_S() {
        if (this.playingDead) {
            this.playingDead = false;
            return false;
        }
        return super.func_70089_S();
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            if (this.func_70026_G() && this.canNotExplodeWhenWet()) {
                this.func_70829_a(-1);
            } else if (this.func_146078_ca() || this.func_70027_ad() && this.explodesWhenBurning()) {
                this.func_70829_a(1);
            }
            this.field_70834_e = this.field_70833_d;
            int creeperState = this.func_70832_p();
            if (creeperState > 0) {
                if (this.field_70833_d == 0) {
                    this.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 0.5f);
                }
                this.onExplodingUpdate();
            }
            this.field_70833_d += creeperState;
            if (this.field_70833_d < 0) {
                this.field_70833_d = 0;
            }
            if (this.field_70833_d >= this.field_82225_f) {
                this.field_70833_d = this.field_82225_f;
                if (!this.field_70170_p.field_72995_K) {
                    boolean powered = this.func_70830_n();
                    boolean griefing = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this);
                    this.field_70729_aU = true;
                    this.explodeByType(powered, griefing);
                    this.func_70106_y();
                    this.spawnLingeringCloud(powered);
                }
            }
        }
        this.playingDead = true;
        super.func_70071_h_();
    }

    private void spawnLingeringCloud(boolean powered) {
        Collection activePotions = this.func_70651_bq();
        if (this.alwaysMakePotionCloud() || !activePotions.isEmpty()) {
            EntityAreaEffectCloud potionCloud = new EntityAreaEffectCloud(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            potionCloud.func_184495_b(-0.5f);
            potionCloud.func_184485_d(10);
            potionCloud.func_184486_b(potionCloud.func_184489_o() / 2);
            potionCloud.func_184487_c(-potionCloud.func_184490_j() / (float)potionCloud.func_184489_o());
            for (PotionEffect potionEffect : activePotions) {
                potionCloud.func_184496_a(new PotionEffect(potionEffect));
            }
            this.potionCloudByType(potionCloud, powered);
            potionCloud.func_184481_a((EntityLivingBase)this);
            this.field_70170_p.func_72838_d((Entity)potionCloud);
        }
    }

    public void onExplodingUpdate() {
    }

    public void explodeByType(boolean powered, boolean griefing) {
        float power = (float)this.field_82226_g * (powered ? 2.0f : 1.0f);
        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, power, griefing);
    }

    public boolean alwaysMakePotionCloud() {
        return false;
    }

    public void potionCloudByType(EntityAreaEffectCloud potionCloud, boolean powered) {
        potionCloud.func_184483_a(((float)this.field_82226_g - 0.5f) * (powered ? 2.0f : 1.0f));
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (damageSource != null && damageSource.func_76364_f() != damageSource.func_76346_g() && this.explodesWhenShot()) {
            this.func_146079_cb();
        }
        return super.func_70097_a(damageSource, damage);
    }

    protected void onTypeAttack(Entity target) {
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.getSpecialData().onUpdate();
    }

    public boolean func_70652_k(Entity target) {
        if (super.func_70652_k(target)) {
            this.onTypeAttack(target);
            return true;
        }
        return false;
    }

    public float func_70047_e() {
        return super.func_70047_e();
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        saveTag.func_74757_a(TAG_DRY_EXPLODE, this.canNotExplodeWhenWet());
        saveTag.func_74757_a(TAG_WHEN_BURNING_EXPLODE, this.explodesWhenBurning());
        saveTag.func_74757_a(TAG_WHEN_SHOT_EXPLODE, this.explodesWhenShot());
        this.getSpecialData().writeToNBT(saveTag);
        tag.func_74777_a(TAG_FUSE_TIME, (short)this.field_82225_f);
        tag.func_74774_a(TAG_EXPLOSION_RADIUS, (byte)this.field_82226_g);
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        if (saveTag.func_74764_b(TAG_DRY_EXPLODE)) {
            this.setCanNotExplodeWhenWet(saveTag.func_74767_n(TAG_DRY_EXPLODE));
        }
        if (saveTag.func_74764_b(TAG_WHEN_BURNING_EXPLODE)) {
            this.setExplodesWhenBurning(saveTag.func_74767_n(TAG_WHEN_BURNING_EXPLODE));
        }
        if (saveTag.func_74764_b(TAG_WHEN_SHOT_EXPLODE)) {
            this.setExplodesWhenShot(saveTag.func_74767_n(TAG_WHEN_SHOT_EXPLODE));
        }
        this.getSpecialData().readFromNBT(saveTag);
        if (tag.func_74764_b(TAG_FUSE_TIME)) {
            this.field_82225_f = tag.func_74765_d(TAG_FUSE_TIME);
        }
        if (tag.func_74764_b(TAG_EXPLOSION_RADIUS)) {
            this.field_82226_g = tag.func_74771_c(TAG_EXPLOSION_RADIUS);
        }
    }

    public void func_70015_d(int time) {
        if (!this.getSpecialData().isImmuneToBurning()) {
            super.func_70015_d(time);
        }
    }

    public boolean func_184652_a(EntityPlayer player) {
        return !this.func_110167_bD() && this.getSpecialData().allowLeashing();
    }

    public void func_70110_aj() {
        if (!this.getSpecialData().isImmuneToWebs()) {
            super.func_70110_aj();
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        super.func_180430_e(distance, damageMultiplier * this.getSpecialData().getFallDamageMultiplier());
    }

    public boolean func_145773_az() {
        return this.getSpecialData().ignorePressurePlates();
    }

    public boolean func_70648_aU() {
        return this.getSpecialData().canBreatheInWater();
    }

    public boolean func_96092_aw() {
        return !this.getSpecialData().ignoreWaterPush();
    }

    public boolean func_70687_e(PotionEffect effect) {
        return this.getSpecialData().isPotionApplicable(effect);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData data) {
        data = super.func_180482_a(difficulty, data);
        if (POWERED != null && this.field_70170_p.func_72911_I() && this.field_70146_Z.nextDouble() < (double)Config.get().CREEPERS.CHARGED_CHANCE) {
            this.field_70180_af.func_187227_b(POWERED, (Object)true);
        }
        return data;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70831_j(float partialTick) {
        return ((float)this.field_70834_e + (float)(this.field_70833_d - this.field_70834_e) * partialTick) / (float)(this.field_82225_f - 2);
    }
}

