/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity.blaze;

import fathertoast.specialmobs.bestiary.BestiaryInfo;
import fathertoast.specialmobs.entity.blaze.Entity_SpecialBlaze;
import fathertoast.specialmobs.loot.LootTableBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.init.Items;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityJoltBlaze
extends Entity_SpecialBlaze {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(EntityJoltBlaze.GET_TEXTURE_PATH("jolt"))};
    public static ResourceLocation LOOT_TABLE;

    public static BestiaryInfo GET_BESTIARY_INFO() {
        BestiaryInfo info = new BestiaryInfo(4824238);
        return info;
    }

    public static void BUILD_LOOT_TABLE(LootTableBuilder loot) {
        EntityJoltBlaze.ADD_BASE_LOOT(loot);
        loot.addCommonDrop("common", "Redstone dust", Items.field_151137_ax);
    }

    public EntityJoltBlaze(World world) {
        super(world);
    }

    @Override
    public ResourceLocation[] getDefaultTextures() {
        return TEXTURES;
    }

    protected ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    @Override
    protected void adjustTypeAttributes() {
        this.field_70728_aV += 2;
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111267_a, 10.0);
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_188791_g, 10.0);
        this.getSpecialData().multAttribute(SharedMonsterAttributes.field_111263_d, 1.3);
    }

    @Override
    protected void initTypeAI() {
        this.disableRangedAI();
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.func_70638_az() != null && this.field_70146_Z.nextInt(20) == 0 && this.func_70638_az().func_70068_e((Entity)this) > 256.0) {
            for (int i = 0; i < 16; ++i) {
                if (!this.teleportToEntity((Entity)this.func_70638_az())) continue;
                this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, false));
                break;
            }
        }
        super.func_70636_d();
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (!this.field_70170_p.field_72995_K && !DamageSource.field_76369_e.equals(damageSource)) {
            double xI = this.field_70165_t;
            double yI = this.field_70163_u;
            double zI = this.field_70161_v;
            for (int i = 0; i < 64; ++i) {
                if (!this.teleportRandomly()) continue;
                if (damageSource instanceof EntityDamageSourceIndirect) {
                    return true;
                }
                boolean hit = super.func_70097_a(damageSource, damage);
                if (this.func_110143_aJ() > 0.0f) {
                    this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, xI, yI, zI, false));
                } else {
                    this.func_70107_b(xI, yI, zI);
                }
                return hit;
            }
        }
        return super.func_70097_a(damageSource, damage);
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
    }

    private boolean teleportRandomly() {
        double targetX = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 16.0;
        double targetY = this.field_70163_u + (double)(this.field_70146_Z.nextInt(12) - 4);
        double targetZ = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 16.0;
        return this.teleportTo(targetX, targetY, targetZ);
    }

    private boolean teleportToEntity(Entity entity) {
        Vec3d vec3d = new Vec3d(this.field_70165_t - entity.field_70165_t, this.func_174813_aQ().field_72338_b + (double)(this.field_70131_O / 2.0f) - entity.field_70163_u + (double)entity.func_70047_e(), this.field_70161_v - entity.field_70161_v);
        vec3d = vec3d.func_72432_b();
        double targetX = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72450_a * 16.0;
        double targetY = this.field_70163_u + (double)(this.field_70146_Z.nextInt(8) - 2) - vec3d.field_72448_b * 16.0;
        double targetZ = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3d.field_72449_c * 16.0;
        return this.teleportTo(targetX, targetY, targetZ);
    }

    private boolean teleportTo(double x, double y, double z) {
        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)this, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        return this.func_184595_k(event.getTargetX(), event.getTargetY(), event.getTargetZ());
    }
}

