/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity.blaze;

import fathertoast.specialmobs.bestiary.BestiaryInfo;
import fathertoast.specialmobs.entity.SpecialMobData;
import fathertoast.specialmobs.entity.blaze.Entity_SpecialBlaze;
import fathertoast.specialmobs.loot.LootTableBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityHellfireBlaze
extends Entity_SpecialBlaze {
    private static final String TAG_EXPLOSION_POWER = "ExplosionPower";
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(EntityHellfireBlaze.GET_TEXTURE_PATH("hellfire"))};
    public static ResourceLocation LOOT_TABLE;
    private int explosionPower = 2;

    public static BestiaryInfo GET_BESTIARY_INFO() {
        BestiaryInfo info = new BestiaryInfo(0xDDDDDD);
        return info;
    }

    public static void BUILD_LOOT_TABLE(LootTableBuilder loot) {
        EntityHellfireBlaze.ADD_BASE_LOOT(loot);
        loot.addCommonDrop("common", "Gunpowder", Items.field_151016_H);
    }

    public EntityHellfireBlaze(World world) {
        super(world);
    }

    @Override
    public ResourceLocation[] getDefaultTextures() {
        return TEXTURES;
    }

    protected ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    @Override
    protected void adjustTypeAttributes() {
        this.field_70728_aV += 2;
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111267_a, 10.0);
    }

    @Override
    protected void initTypeAI() {
        this.getSpecialData().rangedAttackSpread = 0.0f;
        this.setRangedAI(1, 0, 60, 100, 40.0f);
    }

    @Override
    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        this.field_70170_p.func_180498_a(null, 1018, new BlockPos((Entity)this), 0);
        double dX = target.field_70165_t - this.field_70165_t;
        double dY = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 2.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
        double dZ = target.field_70161_v - this.field_70161_v;
        float accelVariance = MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)this.func_70068_e((Entity)target))) * this.getSpecialData().rangedAttackSpread / 28.0f;
        EntityLargeFireball fireball = new EntityLargeFireball(this.field_70170_p, (EntityLivingBase)this, dX + this.field_70146_Z.nextGaussian() * (double)accelVariance, dY, dZ + this.field_70146_Z.nextGaussian() * (double)accelVariance);
        fireball.field_92057_e = this.explosionPower;
        fireball.field_70163_u = this.field_70163_u + (double)(this.field_70131_O / 2.0f) + 0.5;
        this.field_70170_p.func_72838_d((Entity)fireball);
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        saveTag.func_74768_a(TAG_EXPLOSION_POWER, this.explosionPower);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        if (saveTag.func_150297_b(TAG_EXPLOSION_POWER, 99)) {
            this.explosionPower = saveTag.func_74762_e(TAG_EXPLOSION_POWER);
        }
    }
}

