/*
 * Decompiled with CFR 0.152.
 */
package openeye.utils;

import com.mojang.authlib.GameProfile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import openeye.logic.Sanitizers;

public abstract class NameCollector {
    private static void tryAddPlayer(EntityPlayer player) {
        GameProfile profile = player.func_146103_bH();
        if (profile != null) {
            Sanitizers.mainSanitizer.addPre(200, Sanitizers.replaceNoDuplicates(profile.getId(), "[player id]"));
            Sanitizers.mainSanitizer.addPre(300, Sanitizers.replaceNoDuplicates(profile.getName(), "[player name]"));
        }
    }

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new Hooks());
    }

    public static class Hooks {
        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void onWorldLoad(WorldEvent.Load evt) {
            Sanitizers.addWorldNames(evt.getWorld());
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void onEntityJoin(EntityJoinWorldEvent evt) {
            if (evt.getEntity() instanceof EntityPlayer) {
                NameCollector.tryAddPlayer((EntityPlayer)evt.getEntity());
            }
        }

        public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent evt) {
            NameCollector.tryAddPlayer(evt.player);
        }
    }
}

