/*
 * Decompiled with CFR 0.152.
 */
package openeye.notes;

import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class ScreenNotificationHolder {
    private final Style REMOVE_FILE_STYLE = new Style().func_150227_a(Boolean.valueOf(true)).func_150238_a(TextFormatting.RED);
    private final Style KNOWN_CRASH_STYLE = new Style().func_150238_a(TextFormatting.GREEN);
    private final Style INTRO_STYLE = new Style().func_150238_a(TextFormatting.GOLD);
    private Entry selectedLine;

    public void addLine(int level, ITextComponent msg) {
        if (this.selectedLine == null || level > this.selectedLine.level) {
            this.selectedLine = new Entry(level, msg);
        }
    }

    public void signalDangerousFile() {
        this.addLine(64, new TextComponentTranslation("openeye.main_screen.remove_file", new Object[0]).func_150255_a(this.REMOVE_FILE_STYLE));
    }

    public void signalCrashReported() {
        this.addLine(8, (ITextComponent)new TextComponentTranslation("openeye.main_screen.crash_reported", new Object[0]));
    }

    public void signalKnownCrash() {
        this.addLine(32, new TextComponentTranslation("openeye.main_screen.known_crash", new Object[0]).func_150255_a(this.KNOWN_CRASH_STYLE));
    }

    public void signalIntroStuff() {
        this.addLine(256, new TextComponentTranslation("openeye.main_screen.intro", new Object[0]).func_150255_a(this.INTRO_STYLE));
    }

    public ITextComponent getSelectedLine() {
        return this.selectedLine != null ? this.selectedLine.msg : null;
    }

    private static class Entry {
        final int level;
        public final ITextComponent msg;

        private Entry(int level, ITextComponent msg) {
            this.level = level;
            this.msg = msg;
        }
    }
}

