/*
 * Decompiled with CFR 0.152.
 */
package openeye.notes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import openeye.Log;
import openeye.notes.CommandNotes;
import openeye.notes.entries.NoteEntry;
import openeye.storage.IAppendableStorage;
import openeye.storage.IDataSource;

final class JsonNoteSink
implements CommandNotes.INoteSink {
    private final IAppendableStorage<Object> notesDump;

    JsonNoteSink(IAppendableStorage<Object> notesDump) {
        this.notesDump = notesDump;
    }

    @Override
    public void dump(Collection<NoteEntry> notes, ICommandSender sender) throws CommandException {
        JsonArray result = new JsonArray();
        for (NoteEntry note : notes) {
            JsonObject object = note.toJson();
            result.add((JsonElement)object);
        }
        try {
            IDataSource<Object> target = this.notesDump.createNew();
            target.store(result);
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("openeye.chat.dumped", new Object[]{target.getId()}));
        }
        catch (Throwable t) {
            Log.warn(t, "Failed to store notes", new Object[0]);
            throw new CommandException("openeye.chat.store_failed", new Object[0]);
        }
    }
}

