/*
 * Decompiled with CFR 0.152.
 */
package openeye.notes;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.SyntaxErrorException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import openeye.logic.GsonUtils;
import openeye.notes.ConsoleNoteSink;
import openeye.notes.JsonNoteSink;
import openeye.notes.NoteCollector;
import openeye.notes.entries.NoteEntry;
import openeye.storage.GsonSimpleStorage;

public class CommandNotes
implements ICommand {
    private static final String COMMAND_NAME = "eye_notes";
    private final Map<String, INoteSink> sinks = Maps.newHashMap();

    public CommandNotes(File reportDir) {
        GsonSimpleStorage<Object> notesDump = new GsonSimpleStorage<Object>(reportDir, "notes", "json", Object.class, GsonUtils.PRETTY_GSON);
        this.sinks.put("console", new ConsoleNoteSink());
        this.sinks.put("json", new JsonNoteSink(notesDump));
    }

    public int compareTo(ICommand o) {
        return COMMAND_NAME.compareTo(o.func_71517_b());
    }

    public String func_71517_b() {
        return COMMAND_NAME;
    }

    public String func_71518_a(ICommandSender sender) {
        StringBuilder builder = new StringBuilder(COMMAND_NAME).append(" <");
        Joiner.on((char)'|').appendTo(builder, this.sinks.keySet());
        builder.append(">");
        return builder.toString();
    }

    public List<String> func_71514_a() {
        return Lists.newArrayList();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] command) throws CommandException {
        if (command.length != 1) {
            throw new SyntaxErrorException();
        }
        String sinkType = command[0];
        INoteSink sink = this.sinks.get(sinkType);
        if (sink == null) {
            throw new SyntaxErrorException();
        }
        sink.dump(NoteCollector.INSTANCE.getNotes(), sender);
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender.func_70003_b(4, COMMAND_NAME);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] command, BlockPos pos) {
        ArrayList result = Lists.newArrayList();
        if (command.length == 1) {
            String prefix = command[0];
            for (String name : this.sinks.keySet()) {
                if (!name.startsWith(prefix)) continue;
                result.add(name);
            }
        }
        return result;
    }

    public boolean func_82358_a(String[] command, int index) {
        return false;
    }

    static interface INoteSink {
        public void dump(Collection<NoteEntry> var1, ICommandSender var2) throws CommandException;
    }
}

