/*
 * Decompiled with CFR 0.152.
 */
package openeye.logic;

import com.google.common.base.Strings;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import openeye.Log;
import openeye.logic.Config;

public class Sanitizer {
    private final Sanitizer parent;
    private static final Comparator<Integer> REVERSED = (o1, o2) -> o2 - o1;
    private final Multimap<Integer, ITransformer> pre = Sanitizer.createPriorityList();
    private final Multimap<Integer, ITransformer> post = Sanitizer.createPriorityList();

    public Sanitizer() {
        this(null);
    }

    public Sanitizer(Sanitizer parent) {
        this.parent = parent;
    }

    private static <V> Multimap<Integer, V> createPriorityList() {
        return Multimaps.newMultimap(new TreeMap(REVERSED), ArrayList::new);
    }

    public void addPre(int priority, ITransformer transformer) {
        if (transformer != null) {
            this.pre.put((Object)priority, (Object)transformer);
        }
    }

    public void addPost(int priority, ITransformer transformer) {
        if (transformer != null) {
            this.post.put((Object)priority, (Object)transformer);
        }
    }

    public String sanitize(String input) {
        if (Strings.isNullOrEmpty((String)input)) {
            return "";
        }
        for (Map.Entry transformers : this.pre.asMap().entrySet()) {
            for (ITransformer transformer : (Collection)transformers.getValue()) {
                if (Config.debugSanitizer) {
                    Log.info("%d %s", transformers.getKey(), transformer);
                }
                input = transformer.transform(input);
            }
        }
        if (this.parent != null) {
            input = this.parent.sanitize(input);
        }
        for (Map.Entry transformers : this.post.asMap().entrySet()) {
            for (ITransformer transformer : (Collection)transformers.getValue()) {
                if (Config.debugSanitizer) {
                    Log.info("%d %s", transformers.getKey(), transformer);
                }
                input = transformer.transform(input);
            }
        }
        return input;
    }

    public static interface ITransformer {
        public String transform(String var1);
    }
}

