/*
 * Decompiled with CFR 0.152.
 */
package openeye.logic;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.ContainerType;
import net.minecraftforge.fml.common.discovery.ModCandidate;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.VersionRange;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import openeye.Log;
import openeye.logic.ReportBuilders;
import openeye.protocol.Artifact;
import openeye.protocol.FileSignature;
import openeye.protocol.reports.ReportCrash;
import openeye.protocol.reports.ReportFileContents;
import openeye.protocol.reports.ReportFileInfo;
import org.apache.logging.log4j.Level;

public class ModMetaCollector {
    private static final String SIGNATURE_MINECRAFT_SERVER_JAR = "special:minecraft_server";
    private static final String SIGNATURE_MINECRAFT_JAR = "special:minecraft";
    private static final String SIGNATURE_NONE = "special:none";
    private final Map<File, FileMeta> files = Maps.newHashMap();
    private final Map<String, FileMeta> signatures = Maps.newHashMap();
    private final long operationDuration;
    private final ASMDataTable table;
    private Map<File, String> specialSignatures = Maps.newHashMap();

    ModMetaCollector(ASMDataTable table, LaunchClassLoader loader, Collection<ITweaker> tweakers) {
        Log.debug("Starting mod metadata collection", new Object[0]);
        this.table = table;
        long start = System.nanoTime();
        this.assignSignatureToClassSource(SIGNATURE_MINECRAFT_SERVER_JAR, "net.minecraft.server.MinecraftServer");
        this.assignSignatureToClassSource(SIGNATURE_MINECRAFT_JAR, "net.minecraft.client.main.Main");
        Collection<ModCandidate> allCandidates = ModMetaCollector.stealCandidates(table);
        this.collectFilesFromModCandidates(allCandidates);
        this.collectFilesFromClassTransformers(loader, table);
        this.collectFilesFromTweakers(tweakers, table);
        this.collectFilesFromModContainers(table);
        this.fillSignaturesMap();
        this.operationDuration = System.nanoTime() - start;
        Log.debug("Collection of mod metadata finished. Duration: %.4f ms", (double)this.operationDuration / 1000000.0);
    }

    private FileMeta createFileMeta(File file) {
        String signature = this.specialSignatures.get(file);
        return new FileMeta(file, signature);
    }

    private void assignSignatureToClassSource(String signature, String mainCls) {
        try {
            Class<?> cls = Class.forName(mainCls);
            CodeSource src = cls.getProtectionDomain().getCodeSource();
            URL jarUrl = ModMetaCollector.extractJarUrl(src.getLocation());
            File sourceFile = new File(jarUrl.toURI());
            Preconditions.checkState((boolean)sourceFile.isFile(), (String)"Path %s is not file", (Object)sourceFile);
            this.specialSignatures.put(sourceFile, signature);
            Log.debug("Signature '%s' assigned to file '%s'", signature, sourceFile);
        }
        catch (ClassNotFoundException e) {
            Log.debug("Failed to assign signature '%s' to source of class %s - class not found", signature, mainCls);
        }
        catch (Exception e) {
            Log.log(Level.DEBUG, e, "Failed to assign signature '%s' to source of class %s", signature, mainCls);
        }
    }

    private static URL extractJarUrl(URL sourceUrl) throws Exception {
        Preconditions.checkState((boolean)sourceUrl.getProtocol().equalsIgnoreCase("jar"), (String)"%s is not jar path", (Object)sourceUrl);
        String jarFileSource = sourceUrl.getFile();
        int separator = jarFileSource.indexOf("!/");
        if (separator == -1) {
            throw new IllegalStateException("no !/ found in url spec:" + jarFileSource);
        }
        return new URL(jarFileSource.substring(0, separator));
    }

    private FileMeta fromModCandidate(ModCandidate candidate) {
        FileMeta fileMeta = this.createFileMeta(candidate.getModContainer());
        fileMeta.packages.addAll(candidate.getContainedPackages());
        for (ModContainer c : candidate.getContainedMods()) {
            fileMeta.mods.put(c.getModId(), new ModMeta(c));
        }
        return fileMeta;
    }

    private static String calculateSignature(File file) {
        try {
            return "sha256:" + Files.hash((File)file, (HashFunction)Hashing.sha256()).toString();
        }
        catch (Throwable t) {
            Log.warn(t, "Can't hash file %s", file);
            return SIGNATURE_NONE;
        }
    }

    private FileMeta getOrCreateData(File file) {
        FileMeta data = this.files.get(file);
        if (data == null) {
            data = this.createFileMeta(file);
            this.files.put(file, data);
        }
        return data;
    }

    private void collectFilesFromModCandidates(Collection<ModCandidate> candidates) {
        for (ModCandidate c : candidates) {
            File modContainer = c.getModContainer();
            if (this.files.containsKey(modContainer) || c.getSourceType() != ContainerType.JAR) continue;
            FileMeta meta = this.fromModCandidate(c);
            this.files.put(modContainer, meta);
        }
    }

    private static String extractPackage(String className) {
        int pkgIdx = className.lastIndexOf(46);
        if (pkgIdx == -1) {
            return null;
        }
        return className.substring(0, pkgIdx);
    }

    private static Set<ModCandidate> getCandidatesForClass(ASMDataTable table, String cls) {
        String packageName = ModMetaCollector.extractPackage(cls);
        if (Strings.isNullOrEmpty((String)packageName)) {
            return null;
        }
        return table.getCandidatesFor(packageName);
    }

    private void visitMeta(ASMDataTable table, String cls, IFileMetaVisitor visitor) {
        Set<ModCandidate> candidates = ModMetaCollector.getCandidatesForClass(table, cls);
        if (candidates != null) {
            for (ModCandidate c : candidates) {
                File container = c.getModContainer();
                if (container.isDirectory()) continue;
                FileMeta fileMeta = this.files.get(container);
                if (fileMeta == null) {
                    fileMeta = this.fromModCandidate(c);
                    this.files.put(container, fileMeta);
                }
                visitor.visit(fileMeta);
            }
        }
    }

    private void registerClassTransformer(ASMDataTable table, String cls) {
        this.visitMeta(table, cls, fileMeta -> fileMeta.classTransformers.add(cls));
    }

    private static Collection<ModCandidate> stealCandidates(ASMDataTable table) {
        try {
            Multimap packageMap = (Multimap)ReflectionHelper.getPrivateValue(ASMDataTable.class, (Object)table, (String[])new String[]{"packageMap"});
            if (packageMap != null) {
                return packageMap.values();
            }
        }
        catch (Throwable t) {
            Log.warn(t, "Can't get ModCandidate map, data will be missing from report", new Object[0]);
        }
        return ImmutableList.of();
    }

    private void collectFilesFromModContainers(ASMDataTable table) {
        File dummyEntry = new File("minecraft.jar");
        for (ModContainer c : Loader.instance().getModList()) {
            File f = c.getSource();
            if (f == null || f.equals(dummyEntry) || f.isDirectory()) continue;
            FileMeta meta = this.getOrCreateData(f);
            meta.mods.put(c.getModId(), new ModMeta(c));
        }
    }

    private void collectFilesFromTweakers(Collection<ITweaker> tweakers, ASMDataTable table) {
        try {
            Class<?> coreModWrapper = Class.forName("net.minecraftforge.fml.relauncher.CoreModManager$FMLPluginWrapper");
            Field nameField = coreModWrapper.getField("name");
            nameField.setAccessible(true);
            Field pluginField = coreModWrapper.getField("coreModInstance");
            pluginField.setAccessible(true);
            Field locationField = coreModWrapper.getField("location");
            locationField.setAccessible(true);
            for (ITweaker tweaker : tweakers) {
                try {
                    File location = (File)locationField.get(tweaker);
                    if (location == null || location.isDirectory()) continue;
                    String name = (String)nameField.get(tweaker);
                    IFMLLoadingPlugin plugin = (IFMLLoadingPlugin)pluginField.get(tweaker);
                    FileMeta meta = this.getOrCreateData(location);
                    meta.tweakers.add(new TweakMeta(name, plugin.getClass().getName()));
                }
                catch (Throwable t) {
                    Log.warn(t, "Can't get data for tweaker %s", tweaker);
                }
            }
        }
        catch (Throwable t) {
            Log.warn(t, "Can't get tweaker data", new Object[0]);
        }
    }

    private void collectFilesFromClassTransformers(LaunchClassLoader loader, ASMDataTable table) {
        if (loader != null) {
            List transformers = loader.getTransformers();
            for (IClassTransformer transformer : transformers) {
                this.registerClassTransformer(table, transformer.getClass().getName());
            }
        } else {
            Log.warn("LaunchClassLoader not available", new Object[0]);
        }
    }

    private void fillSignaturesMap() {
        for (FileMeta meta : this.files.values()) {
            this.signatures.put(meta.signature(), meta);
        }
    }

    public List<String> listSignatures() {
        ArrayList result = Lists.newArrayList();
        for (FileMeta meta : this.files.values()) {
            result.add(meta.signature);
        }
        return result;
    }

    public List<ReportCrash.FileState> collectStates() {
        ArrayList result = Lists.newArrayList();
        for (FileMeta meta : this.files.values()) {
            result.add(meta.getStates());
        }
        return result;
    }

    public List<FileSignature> getAllFiles() {
        ArrayList result = Lists.newArrayList();
        for (FileMeta meta : this.files.values()) {
            FileSignature tmp = new FileSignature();
            tmp.signature = meta.signature();
            tmp.filename = meta.container.getName();
            result.add(meta.createFileSignature());
        }
        return result;
    }

    public Set<String> getAllSignatures() {
        HashSet result = Sets.newHashSet();
        for (FileMeta meta : this.files.values()) {
            result.add(meta.signature());
        }
        return result;
    }

    public long getCollectingDuration() {
        return this.operationDuration;
    }

    public ReportFileInfo generateFileReport(String signature) {
        FileMeta meta = this.signatures.get(signature);
        return meta != null ? meta.generateReport() : null;
    }

    public ReportFileContents generateFileContentsReport(String signature) {
        FileMeta meta = this.signatures.get(signature);
        return meta != null ? meta.generateFileContentsReport() : null;
    }

    public Set<String> getModsForSignature(String signature) {
        FileMeta meta = this.signatures.get(signature);
        if (meta != null) {
            return ImmutableSet.copyOf(meta.mods.keySet());
        }
        return ImmutableSet.of();
    }

    public FileSignature getFileForSignature(String signature) {
        FileMeta meta = this.signatures.get(signature);
        return meta != null ? meta.createFileSignature() : null;
    }

    public File getContainerForSignature(String signature) {
        FileMeta meta = this.signatures.get(signature);
        return meta != null ? meta.container : null;
    }

    public ClassSource identifyClassSource(String className) {
        FileMeta meta;
        String packageName = ModMetaCollector.extractPackage(className);
        ClassSource result = new ClassSource();
        if (packageName != null && (packageName.startsWith("net.minecraft") || packageName.startsWith("net.minecraftforge") || packageName.startsWith("cpw.mods.fml"))) {
            return null;
        }
        try {
            URL sourceUrl;
            File sourceFile;
            Class<?> cls = Class.forName(className);
            CodeSource src = cls.getProtectionDomain().getCodeSource();
            if (src != null && (meta = this.files.get(sourceFile = new File((sourceUrl = ModMetaCollector.extractJarUrl(src.getLocation())).toURI()))) != null) {
                result.loadedFrom = meta.signature();
            }
        }
        catch (Throwable cls) {
            // empty catch block
        }
        Set candidates = this.table.getCandidatesFor(packageName);
        for (ModCandidate c : candidates) {
            File container = c.getModContainer();
            if (container == null || (meta = this.files.get(container)) == null) continue;
            result.containingClasses.add(meta.signature());
        }
        return result;
    }

    public static class ClassSource {
        public String loadedFrom;
        public final Set<String> containingClasses = Sets.newHashSet();
    }

    private static interface IFileMetaVisitor {
        public void visit(FileMeta var1);
    }

    private static class FileMeta {
        public final Set<String> classTransformers = Sets.newHashSet();
        public final Map<String, ModMeta> mods = Maps.newHashMap();
        public final List<TweakMeta> tweakers = Lists.newArrayList();
        public final Set<String> packages = Sets.newHashSet();
        public final File container;
        private String signature;

        private FileMeta(File container, String signature) {
            this.container = container;
            this.signature = signature;
        }

        public String signature() {
            if (this.signature == null) {
                this.signature = ModMetaCollector.calculateSignature(this.container);
            }
            return this.signature;
        }

        public Long getSize() {
            try {
                return this.container.length();
            }
            catch (Throwable t) {
                Log.info(t, "Can't get size info for file %s", this.container);
                return null;
            }
        }

        public ReportCrash.FileState getStates() {
            ReportCrash.FileState result = new ReportCrash.FileState();
            result.signature = this.signature();
            ArrayList mods = Lists.newArrayList();
            for (ModMeta meta : this.mods.values()) {
                mods.add(meta.getState());
            }
            result.mods = mods;
            return result;
        }

        public ReportFileInfo generateReport() {
            ReportFileInfo report = new ReportFileInfo();
            report.signature = this.signature();
            report.size = this.getSize();
            ImmutableList.Builder modsBuilder = ImmutableList.builder();
            for (ModMeta m : this.mods.values()) {
                modsBuilder.add((Object)m.toSerializable());
            }
            report.mods = modsBuilder.build();
            ImmutableList.Builder tweaksBuilder = ImmutableList.builder();
            for (TweakMeta t : this.tweakers) {
                tweaksBuilder.add((Object)t.toSerializable());
            }
            report.tweakers = tweaksBuilder.build();
            report.classTransformers = ImmutableList.copyOf(this.classTransformers);
            report.packages = ImmutableList.copyOf(this.packages);
            return report;
        }

        public ReportFileContents generateFileContentsReport() {
            ReportFileContents report = new ReportFileContents();
            report.signature = this.signature();
            ReportBuilders.fillFileContents(this.container, report);
            return report;
        }

        public FileSignature createFileSignature() {
            FileSignature result = new FileSignature();
            result.signature = this.signature();
            result.filename = this.container.getName();
            return result;
        }
    }

    private static class ModMeta {
        private final String modId;
        private final String name;
        private final String version;
        private final ModMetadata metadata;
        private final ModContainer container;

        private ModMeta(ModContainer container) {
            this.container = container;
            this.modId = Strings.nullToEmpty((String)container.getModId());
            this.name = Strings.nullToEmpty((String)container.getName());
            this.version = Strings.nullToEmpty((String)container.getVersion());
            this.metadata = container.getMetadata();
        }

        private static <T> Collection<T> safeCopy(Collection<T> input) {
            if (input == null) {
                return ImmutableList.of();
            }
            return ImmutableList.copyOf(input);
        }

        private static Collection<Artifact> copyArtifacts(Collection<ArtifactVersion> input) {
            if (input == null) {
                return ImmutableList.of();
            }
            ImmutableList.Builder result = ImmutableList.builder();
            for (ArtifactVersion version : input) {
                Artifact tmp = new Artifact();
                tmp.label = version.getLabel();
                tmp.version = version.getVersionString();
                result.add((Object)tmp);
            }
            return result.build();
        }

        public ReportFileInfo.SerializableMod toSerializable() {
            ReportFileInfo.SerializableMod result = new ReportFileInfo.SerializableMod();
            result.modId = this.modId;
            result.name = this.name;
            result.version = this.version;
            VersionRange mcVersionRange = this.container.acceptableMinecraftVersionRange();
            if (mcVersionRange != null) {
                result.mcVersion = Strings.nullToEmpty((String)mcVersionRange.toString());
            }
            result.description = Strings.nullToEmpty((String)this.metadata.description);
            result.url = Strings.nullToEmpty((String)this.metadata.url);
            result.updateUrl = Strings.nullToEmpty((String)this.metadata.updateUrl);
            result.credits = Strings.nullToEmpty((String)this.metadata.credits);
            result.parent = Strings.nullToEmpty((String)this.metadata.parent);
            result.authors = ModMeta.safeCopy(this.metadata.authorList);
            result.requiredMods = ModMeta.copyArtifacts(this.metadata.requiredMods);
            result.dependants = ModMeta.copyArtifacts(this.metadata.dependants);
            result.dependencies = ModMeta.copyArtifacts(this.metadata.dependencies);
            return result;
        }

        public ReportCrash.ModState getState() {
            ReportCrash.ModState state = new ReportCrash.ModState();
            state.modId = this.modId;
            state.state = Loader.instance().getModState(this.container).toString();
            return state;
        }
    }

    private static class TweakMeta {
        private final String pluginName;
        private final String className;

        private TweakMeta(String pluginName, String className) {
            this.pluginName = Strings.nullToEmpty((String)pluginName);
            this.className = Strings.nullToEmpty((String)className);
        }

        public ReportFileInfo.SerializableTweak toSerializable() {
            ReportFileInfo.SerializableTweak result = new ReportFileInfo.SerializableTweak();
            result.plugin = this.pluginName;
            result.cls = this.className;
            return result;
        }
    }
}

