/*
 * Decompiled with CFR 0.152.
 */
package openeye;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.io.File;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.RunnableFuture;
import net.minecraft.command.ICommand;
import net.minecraftforge.fml.client.FMLFileResourcePack;
import net.minecraftforge.fml.client.FMLFolderResourcePack;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import openeye.Log;
import openeye.Proxy;
import openeye.logic.Bootstrap;
import openeye.logic.Config;
import openeye.logic.ModCollectorFactory;
import openeye.logic.ModMetaCollector;
import openeye.logic.SenderWorker;
import openeye.logic.StateHolder;
import openeye.logic.ThrowableLogger;
import openeye.notes.CommandNotes;
import openeye.protocol.FileSignature;
import openeye.utils.NameCollector;

public class Mod
extends DummyModContainer {
    private LoadController controller;
    private SenderWorker worker;

    public Mod() {
        super(new ModMetadata());
        ModMetadata meta = this.getMetadata();
        meta.autogenerated = false;
        meta.modId = "OpenEye";
        meta.name = "OpenEye";
        meta.version = "0.8";
        meta.authorList = Arrays.asList("boq", "Mikee");
        meta.url = "https://openmods.info/";
        meta.description = "We see you...";
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        this.controller = controller;
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void onModConstruct(FMLConstructionEvent evt) {
        Proxy.instance().first();
        ModCollectorFactory factory = new ModCollectorFactory();
        RunnableFuture<ModMetaCollector> collector = factory.createCollector(evt.getASMHarvestedData(), Bootstrap.instance.getLoader(), Bootstrap.instance.getTweakers());
        Mod.startMetadataCollection(collector);
        ThrowableLogger.enableResolving(collector);
        long now = System.currentTimeMillis();
        if (StateHolder.state().suspendUntilTimestamp > now) {
            Log.debug("Communication with server suspended, OpenEye will not send or receive any data", new Object[0]);
        } else if (!Proxy.instance().isSnooperEnabled()) {
            Log.debug("Snooper disabled, OpenEye will not send or receive any data from server", new Object[0]);
        } else {
            this.worker = new SenderWorker(collector, StateHolder.state());
            this.worker.start();
        }
    }

    private static void startMetadataCollection(RunnableFuture<ModMetaCollector> collector) {
        Thread modCollector = new Thread(collector);
        modCollector.setName("OpenEye mod meta collector");
        modCollector.start();
    }

    @Subscribe
    public void onInit(FMLInitializationEvent evt) {
        if (this.worker != null) {
            this.worker.waitForFirstMsg();
            this.handleUnwantedFiles();
        }
        NameCollector.register();
        Proxy.instance().init();
    }

    private void handleUnwantedFiles() {
        Collection<FileSignature> dangerousMods = this.worker.listDangerousFiles();
        if (!dangerousMods.isEmpty()) {
            for (FileSignature signature : dangerousMods) {
                Log.warn("File suggested for deletion: %s (%s)", signature.filename, signature.signature);
            }
        }
    }

    public static void crash1() {
        try {
            File mcDir = Bootstrap.instance.getMcLocation();
            throw new ProtocolException("128.0.0.1 deep one: " + new File(mcDir, "hello.txt"));
        }
        catch (Exception e) {
            throw new RuntimeException("u wot m8: 127.0.0.4:5262", e);
        }
    }

    public static void crash2() {
        try {
            Mod.crash1();
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e);
        }
    }

    @Subscribe
    public void onInit(FMLPostInitializationEvent evt) {
        if (Config.crashOnStartup) {
            try {
                Mod.crash2();
            }
            catch (RuntimeException e) {
                this.controller.errorOccurred((ModContainer)this, (Throwable)new RuntimeException("Goodbye, cruel world!", e));
            }
        }
    }

    @Subscribe
    public void onServerStart(FMLServerStartingEvent evt) {
        evt.registerServerCommand((ICommand)new CommandNotes(evt.getServer().func_71209_f(".")));
    }

    public File getSource() {
        File injectedSource = Bootstrap.instance.getSelfLocation();
        if (injectedSource != null) {
            return injectedSource;
        }
        URL url = ((Object)((Object)this)).getClass().getResource(".");
        try {
            File rootFile = new File(url.toURI());
            if (rootFile.getName().equals("openeye")) {
                rootFile = rootFile.getParentFile();
            }
            return rootFile;
        }
        catch (Exception e) {
            Log.info(e, "Failed to extract source from URL %s", url);
            return null;
        }
    }

    public Class<?> getCustomResourcePackClass() {
        File source = this.getSource();
        if (source == null) {
            Log.warn("Failed to get source, resource pack missing", new Object[0]);
            return null;
        }
        return source.isDirectory() ? FMLFolderResourcePack.class : FMLFileResourcePack.class;
    }
}

