/*
 * Decompiled with CFR 0.152.
 */
package capsule.network.server;

import capsule.Config;
import capsule.StructureSaver;
import capsule.helpers.Capsule;
import capsule.items.CapsuleItem;
import capsule.network.CapsuleLeftClickQueryToServer;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CapsuleLeftClickQueryHandler
implements IMessageHandler<CapsuleLeftClickQueryToServer, IMessage> {
    protected static final Logger LOGGER = LogManager.getLogger(CapsuleLeftClickQueryHandler.class);

    public IMessage onMessage(CapsuleLeftClickQueryToServer message, MessageContext ctx) {
        if (ctx.side != Side.SERVER) {
            LOGGER.error("CapsuleLeftClickQueryToServer received on wrong side:" + ctx.side);
            return null;
        }
        if (!message.isMessageValid()) {
            LOGGER.error("CapsuleLeftClickQueryToServer was invalid" + message.toString());
            return null;
        }
        EntityPlayerMP sendingPlayer = ctx.getServerHandler().field_147369_b;
        if (sendingPlayer == null) {
            LOGGER.error("EntityPlayerMP was null when CapsuleLeftClickQueryToServer was received");
            return null;
        }
        sendingPlayer.func_71121_q().func_152344_a(() -> {
            ItemStack stack = sendingPlayer.func_184614_ca();
            if (stack.func_77973_b() instanceof CapsuleItem && CapsuleItem.isBlueprint(stack) && stack.func_77952_i() == 3) {
                Map<StructureSaver.ItemStackKey, Integer> missing = Capsule.reloadBlueprint(stack, sendingPlayer.func_71121_q(), (EntityPlayer)sendingPlayer);
                if (missing != null && missing.size() > 0) {
                    String missingListText = missing.entrySet().stream().map(entry -> entry.getValue() + " " + ((StructureSaver.ItemStackKey)entry.getKey()).itemStack.func_77973_b().func_77653_i(((StructureSaver.ItemStackKey)entry.getKey()).itemStack)).collect(Collectors.joining("\n* "));
                    sendingPlayer.func_145747_a((ITextComponent)new TextComponentTranslation("Missing : \n* " + missingListText, new Object[0]));
                }
            } else if (stack.func_77973_b() instanceof CapsuleItem && CapsuleItem.canRotate(stack)) {
                PlacementSettings placement = CapsuleItem.getPlacement(stack);
                if (sendingPlayer.func_70093_af()) {
                    if (CapsuleItem.isBlueprint(stack) && Config.allowBlueprintMirror || !CapsuleItem.isBlueprint(stack) && Config.allowStandardMirror) {
                        switch (placement.func_186212_b()) {
                            case FRONT_BACK: {
                                placement.func_186214_a(Mirror.LEFT_RIGHT);
                                break;
                            }
                            case LEFT_RIGHT: {
                                placement.func_186214_a(Mirror.NONE);
                                break;
                            }
                            case NONE: {
                                placement.func_186214_a(Mirror.FRONT_BACK);
                            }
                        }
                        sendingPlayer.func_145747_a((ITextComponent)new TextComponentTranslation("[ ]: " + Capsule.getMirrorLabel(placement), new Object[0]));
                    } else {
                        sendingPlayer.func_145747_a((ITextComponent)new TextComponentTranslation("Mirroring disabled by config", new Object[0]));
                    }
                } else {
                    placement.func_186220_a(placement.func_186215_c().func_185830_a(Rotation.CLOCKWISE_90));
                    sendingPlayer.func_145747_a((ITextComponent)new TextComponentTranslation("\u27f3: " + Capsule.getRotationLabel(placement), new Object[0]));
                }
                CapsuleItem.setPlacement(stack, placement);
            }
        });
        return null;
    }
}

