/*
 * Decompiled with CFR 0.152.
 */
package capsule.items;

import capsule.Main;
import capsule.helpers.Blueprint;
import capsule.items.CapsuleItem;
import capsule.recipes.BlueprintCapsuleRecipeFactory;
import capsule.recipes.BlueprintChangeRecipeFactory;
import capsule.recipes.PrefabsBlueprintCapsuleRecipe;
import capsule.recipes.RecoveryCapsuleRecipeFactory;
import capsule.recipes.UpgradeCapsuleRecipeFactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.commons.lang3.tuple.Pair;

public class CapsuleItems {
    private static final int UPGRADE_STEP = 2;
    public static CapsuleItem capsule;
    public static String CAPSULE_REGISTERY_NAME;
    public static TreeMap<ItemStack, IRecipe> capsuleList;
    public static TreeMap<ItemStack, IRecipe> opCapsuleList;
    public static List<Pair<ItemStack, IRecipe>> blueprintCapsules;
    public static Pair<ItemStack, IRecipe> unlabelledCapsule;
    public static Pair<ItemStack, RecoveryCapsuleRecipeFactory.RecoveryCapsuleRecipe> recoveryCapsule;
    public static Pair<ItemStack, BlueprintChangeRecipeFactory.BlueprintChangeRecipe> blueprintChangedCapsule;
    public static Pair<ItemStack, UpgradeCapsuleRecipeFactory.UpgradeCapsuleRecipe> upgradedCapsule;

    private static double compare(ItemStack capsule) {
        return (double)CapsuleItem.getSize(capsule) + (double)CapsuleItem.getMaterialColor(capsule) * 1.0E-12;
    }

    public static void registerItems(RegistryEvent.Register<Item> event) {
        capsule = new CapsuleItem(CAPSULE_REGISTERY_NAME);
        capsule.func_77637_a(Main.tabCapsule);
        event.getRegistry().register(capsule.setRegistryName(CAPSULE_REGISTERY_NAME));
    }

    public static void registerRecipes(RegistryEvent.Register<IRecipe> event, ArrayList<String> prefabsTemplatesList) {
        Blueprint.createDynamicPrefabRecipes(event, prefabsTemplatesList);
        for (IRecipe recipe : event.getRegistry().getValuesCollection()) {
            if (!recipe.getRegistryName().toString().startsWith("capsule:")) continue;
            if (recipe instanceof BlueprintCapsuleRecipeFactory.BlueprintCapsuleRecipe) {
                blueprintCapsules.add((Pair<ItemStack, IRecipe>)Pair.of((Object)recipe.func_77571_b(), (Object)recipe));
                continue;
            }
            if (recipe instanceof RecoveryCapsuleRecipeFactory.RecoveryCapsuleRecipe) {
                recoveryCapsule = Pair.of((Object)recipe.func_77571_b(), (Object)((Object)((RecoveryCapsuleRecipeFactory.RecoveryCapsuleRecipe)recipe)));
                continue;
            }
            if (recipe instanceof UpgradeCapsuleRecipeFactory.UpgradeCapsuleRecipe) {
                upgradedCapsule = Pair.of((Object)recipe.func_77571_b(), (Object)((Object)((UpgradeCapsuleRecipeFactory.UpgradeCapsuleRecipe)recipe)));
                continue;
            }
            if (recipe instanceof BlueprintChangeRecipeFactory.BlueprintChangeRecipe) {
                blueprintChangedCapsule = Pair.of((Object)recipe.func_77571_b(), (Object)((Object)((BlueprintChangeRecipeFactory.BlueprintChangeRecipe)recipe)));
                continue;
            }
            if (recipe instanceof PrefabsBlueprintCapsuleRecipe) {
                blueprintCapsules.add((Pair<ItemStack, IRecipe>)Pair.of((Object)recipe.func_77571_b(), (Object)recipe));
                continue;
            }
            ItemStack output = recipe.func_77571_b();
            if (!(output.func_77973_b() instanceof CapsuleItem) || !(recipe instanceof ShapedOreRecipe)) continue;
            if (CapsuleItem.isOverpowered(output)) {
                opCapsuleList.put(output, recipe);
                continue;
            }
            capsuleList.put(output, recipe);
        }
        if (capsuleList.size() > 0) {
            unlabelledCapsule = Pair.of((Object)CapsuleItems.getUnlabelledCapsule(capsuleList.firstKey()), null);
        }
    }

    public static ItemStack getUnlabelledCapsule(ItemStack capsule) {
        ItemStack unlabelledCapsule = capsule.func_77946_l();
        unlabelledCapsule.func_77964_b(2);
        CapsuleItem.setStructureName(unlabelledCapsule, "StructureNameExample");
        return unlabelledCapsule;
    }

    public static ItemStack getUpgradedCapsule(ItemStack ironCapsule, int upLevel) {
        ItemStack capsuleUp = ironCapsule.func_77946_l();
        CapsuleItem.setSize(capsuleUp, CapsuleItem.getSize(ironCapsule) + upLevel * 2);
        CapsuleItem.setUpgradeLevel(capsuleUp, upLevel);
        capsuleUp.func_77983_a("upgraded", (NBTBase)new NBTTagInt(upLevel));
        return capsuleUp;
    }

    static {
        CAPSULE_REGISTERY_NAME = "capsule";
        capsuleList = new TreeMap(Comparator.comparingDouble(CapsuleItems::compare));
        opCapsuleList = new TreeMap(Comparator.comparingDouble(CapsuleItems::compare));
        blueprintCapsules = new ArrayList<Pair<ItemStack, IRecipe>>();
        unlabelledCapsule = null;
        recoveryCapsule = null;
        blueprintChangedCapsule = null;
        upgradedCapsule = null;
    }
}

