/*
 * Decompiled with CFR 0.152.
 */
package capsule.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.Template;

public class Spacial {
    public static final float MAX_BLOCKS_PER_TICK_THROW = 1.2f;

    public static BlockPos findBottomBlock(EntityItem entityItem) {
        return Spacial.findBottomBlock(entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v);
    }

    public static BlockPos findBottomBlock(double x, double y, double z) {
        Iterable blockPoss = BlockPos.func_177980_a((BlockPos)new BlockPos(x, y - 1.0, z), (BlockPos)new BlockPos(x + 1.0, y + 1.0, z + 1.0));
        BlockPos closest = null;
        double closestDistance = 1000.0;
        for (BlockPos pos : blockPoss) {
            double distance = pos.func_177957_d(x, y, z);
            if (!(distance < closestDistance)) continue;
            closest = pos;
            closestDistance = distance;
        }
        return closest;
    }

    public static boolean isImmergedInLiquid(Entity entity) {
        if (entity == null) {
            return false;
        }
        return !entity.func_70038_c(0.0, 1.5, 0.0);
    }

    public static RayTraceResult clientRayTracePreview(EntityPlayer thePlayer, float partialTicks, int size) {
        int blockReachDistance = 18 + size;
        Vec3d vec3d = thePlayer.func_174824_e(partialTicks);
        Vec3d vec3d1 = thePlayer.func_70676_i(partialTicks);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * (double)blockReachDistance, vec3d1.field_72448_b * (double)blockReachDistance, vec3d1.field_72449_c * (double)blockReachDistance);
        boolean stopOnLiquid = !Spacial.isImmergedInLiquid((Entity)thePlayer);
        RayTraceResult rtc = thePlayer.func_130014_f_().func_72901_a(vec3d, vec3d2, stopOnLiquid);
        return rtc;
    }

    @Nullable
    public static BlockPos findSpecificBlock(EntityItem entityItem, int maxRange, Class searchedBlock) {
        if (searchedBlock == null) {
            return null;
        }
        double i = entityItem.field_70165_t;
        double j = entityItem.field_70163_u;
        double k = entityItem.field_70161_v;
        for (int range = 1; range < maxRange; ++range) {
            Iterable blockPoss = BlockPos.func_177975_b((BlockPos)new BlockPos(i - (double)range, j - (double)range, k - (double)range), (BlockPos)new BlockPos(i + (double)range, j + (double)range, k + (double)range));
            for (BlockPos pos : blockPoss) {
                Block block = entityItem.func_130014_f_().func_175667_e(pos) ? entityItem.func_130014_f_().func_180495_p(pos).func_177230_c() : null;
                if (block == null || !block.getClass().equals(searchedBlock)) continue;
                return new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return null;
    }

    public static List<AxisAlignedBB> mergeVoxels(List<Template.BlockInfo> blocks) {
        HashMap blocksByPos = new HashMap();
        HashMap bbByPos = new HashMap();
        blocks.forEach(b -> blocksByPos.put(b.field_186242_a, b));
        blocks.forEach(block -> {
            BlockPos destPos = block.field_186242_a;
            BlockPos below = block.field_186242_a.func_177982_a(0, -1, 0);
            if (bbByPos.containsKey(below) && blocksByPos.containsKey(below) && ((Template.BlockInfo)blocksByPos.get((Object)below)).field_186243_b.func_177230_c() == block.field_186243_b.func_177230_c()) {
                StructureBoundingBox bb = (StructureBoundingBox)bbByPos.get(below);
                ++bb.field_78894_e;
                bbByPos.put(destPos, bb);
            } else {
                StructureBoundingBox column = new StructureBoundingBox((Vec3i)block.field_186242_a, (Vec3i)block.field_186242_a);
                bbByPos.put(destPos, column);
            }
        });
        List<StructureBoundingBox> allBB = bbByPos.values().stream().distinct().collect(Collectors.toList());
        ArrayList toRemove = new ArrayList();
        allBB.forEach(bb -> {
            if (!toRemove.contains(bb)) {
                StructureBoundingBox matchingBB = Spacial.findMatchingExpandingX(bb, allBB);
                while (matchingBB != null) {
                    toRemove.add(matchingBB);
                    bb.func_78888_b(matchingBB);
                    matchingBB = Spacial.findMatchingExpandingX(bb, allBB);
                }
            }
        });
        allBB.removeAll(toRemove);
        toRemove.clear();
        allBB.forEach(bb -> {
            if (!toRemove.contains(bb)) {
                StructureBoundingBox matchingBB = Spacial.findMatchingExpandingZ(bb, allBB);
                while (matchingBB != null) {
                    toRemove.add(matchingBB);
                    bb.func_78888_b(matchingBB);
                    matchingBB = Spacial.findMatchingExpandingZ(bb, allBB);
                }
            }
        });
        allBB.removeAll(toRemove);
        return allBB.stream().map(bb -> new AxisAlignedBB(new BlockPos(bb.field_78897_a, bb.field_78895_b, bb.field_78896_c), new BlockPos(bb.field_78893_d, bb.field_78894_e, bb.field_78892_f))).collect(Collectors.toList());
    }

    private static StructureBoundingBox findMatchingExpandingX(StructureBoundingBox bb, List<StructureBoundingBox> allBB) {
        return allBB.stream().filter(candidate -> candidate != bb && candidate.field_78895_b == bb.field_78895_b && candidate.field_78894_e == bb.field_78894_e && candidate.field_78896_c == bb.field_78896_c && candidate.field_78892_f == bb.field_78892_f && candidate.field_78897_a == bb.field_78893_d + 1).findFirst().orElse(null);
    }

    private static StructureBoundingBox findMatchingExpandingZ(StructureBoundingBox bb, List<StructureBoundingBox> allBB) {
        return allBB.stream().filter(candidate -> candidate != bb && candidate.field_78895_b == bb.field_78895_b && candidate.field_78894_e == bb.field_78894_e && candidate.field_78897_a == bb.field_78897_a && candidate.field_78893_d == bb.field_78893_d && candidate.field_78896_c == bb.field_78892_f + 1).findFirst().orElse(null);
    }

    public static boolean isThrowerUnderLiquid(EntityItem entityItem) {
        String thrower = entityItem.func_145800_j();
        if (StringUtils.func_151246_b((String)thrower)) {
            return false;
        }
        EntityPlayer player = entityItem.func_130014_f_().func_72924_a(thrower);
        boolean underLiquid = Spacial.isImmergedInLiquid((Entity)player);
        return underLiquid;
    }

    public static boolean isEntityCollidingLiquid(EntityItem entityItem) {
        return !entityItem.func_70038_c(0.0, -0.1, 0.0);
    }

    public static boolean entityItemShouldAndCollideLiquid(EntityItem entityItem) {
        boolean throwerInLiquid = Spacial.isThrowerUnderLiquid(entityItem);
        boolean entityInLiquid = Spacial.isEntityCollidingLiquid(entityItem);
        return !throwerInLiquid && entityInLiquid;
    }

    public static void moveEntityItemToDeployPos(EntityItem entityItem, ItemStack capsule, boolean keepMomentum) {
        if (capsule.func_77978_p() == null) {
            return;
        }
        BlockPos dest = BlockPos.func_177969_a((long)capsule.func_77978_p().func_74763_f("deployAt"));
        double diffX = (double)dest.func_177958_n() + 0.5 - entityItem.field_70165_t;
        double diffZ = (double)dest.func_177952_p() + 0.5 - entityItem.field_70161_v;
        double distance = MathHelper.func_76133_a((double)(diffX * diffX + diffZ * diffZ));
        double requiredVelocity = distance / 10.0;
        double velocity = Math.min(requiredVelocity, (double)1.2f);
        double normalizedDiffX = diffX / distance;
        double normalizedDiffZ = diffZ / distance;
        entityItem.field_70159_w = keepMomentum ? 0.9 * entityItem.field_70159_w + 0.1 * normalizedDiffX * velocity : normalizedDiffX * velocity;
        entityItem.field_70179_y = keepMomentum ? 0.9 * entityItem.field_70179_y + 0.1 * normalizedDiffZ * velocity : normalizedDiffZ * velocity;
    }
}

