/*
 * Decompiled with CFR 0.152.
 */
package capsule.helpers;

import capsule.CommonProxy;
import capsule.Config;
import capsule.StructureSaver;
import capsule.blocks.BlockCapsuleMarker;
import capsule.helpers.Blueprint;
import capsule.helpers.MinecraftNBT;
import capsule.helpers.Spacial;
import capsule.items.CapsuleItem;
import capsule.items.CapsuleItems;
import capsule.loot.CapsuleLootEntry;
import capsule.network.CapsuleUndeployNotifToClient;
import capsule.structure.CapsuleTemplate;
import capsule.structure.CapsuleTemplateManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Capsule {
    protected static final Logger LOGGER = LogManager.getLogger(Capsule.class);

    public static String getMirrorLabel(PlacementSettings placement) {
        switch (placement.func_186212_b()) {
            case FRONT_BACK: {
                return TextFormatting.STRIKETHROUGH + "[ ]";
            }
            case LEFT_RIGHT: {
                return "[I]";
            }
        }
        return "[ ]";
    }

    public static String getRotationLabel(PlacementSettings placement) {
        switch (placement.func_186215_c()) {
            case CLOCKWISE_90: {
                return "90";
            }
            case CLOCKWISE_180: {
                return "180";
            }
            case COUNTERCLOCKWISE_90: {
                return "270";
            }
        }
        return "0";
    }

    public static void resentToCapsule(ItemStack capsule, EntityPlayer playerIn) {
        WorldServer world;
        Integer dimensionId = CapsuleItem.getDimension(capsule);
        MinecraftServer server = playerIn.func_184102_h();
        if (server == null) {
            return;
        }
        WorldServer worldServer = world = dimensionId != null ? server.func_71218_a(dimensionId.intValue()) : (WorldServer)playerIn.func_130014_f_();
        if (capsule.func_77978_p() == null) {
            return;
        }
        NBTTagCompound spawnPos = capsule.func_77978_p().func_74775_l("spawnPosition");
        BlockPos startPos = new BlockPos(spawnPos.func_74762_e("x"), spawnPos.func_74762_e("y"), spawnPos.func_74762_e("z"));
        int size = CapsuleItem.getSize(capsule);
        if (CapsuleItem.isBlueprint(capsule)) {
            boolean blueprintMatch = StructureSaver.undeployBlueprint(world, playerIn.func_70005_c_(), capsule, startPos, size, CapsuleItem.getExcludedBlocs(capsule));
            if (blueprintMatch) {
                CapsuleItem.setState(capsule, 7);
                CapsuleItem.cleanDeploymentTags(capsule);
                Capsule.notifyUndeploy(playerIn, startPos, size);
            } else {
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("capsule.error.blueprintDontMatch", new Object[0]));
            }
        } else {
            boolean storageOK;
            CapsuleTemplate template = StructureSaver.undeploy(world, playerIn.func_70005_c_(), capsule.func_77978_p().func_74779_i("structureName"), startPos, size, CapsuleItem.getExcludedBlocs(capsule), CapsuleItem.getOccupiedSourcePos(capsule));
            boolean bl = storageOK = template != null;
            if (storageOK) {
                CapsuleItem.setState(capsule, 2);
                CapsuleItem.cleanDeploymentTags(capsule);
                CapsuleItem.setCanRotate(capsule, template.canRotate());
                CapsuleItem.setPlacement(capsule, new PlacementSettings());
                Capsule.notifyUndeploy(playerIn, startPos, size);
            } else {
                LOGGER.error("Error occured during undeploy of capsule.");
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("capsule.error.technicalError", new Object[0]));
            }
        }
    }

    private static void notifyUndeploy(EntityPlayer playerIn, BlockPos startPos, int size) {
        BlockPos center = startPos.func_177982_a(size / 2, size / 2, size / 2);
        CommonProxy.simpleNetworkWrapper.sendToAllAround((IMessage)new CapsuleUndeployNotifToClient(center, playerIn.func_180425_c(), size), new NetworkRegistry.TargetPoint(playerIn.field_71093_bK, (double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p(), (double)(200 + size)));
    }

    public static boolean deployCapsule(ItemStack capsule, BlockPos anchorBlockPos, String thrower, int extendLength, WorldServer world) {
        BlockPos dest;
        boolean didSpawn = false;
        if (capsule.func_77978_p() != null && capsule.func_77978_p().func_74764_b("deployAt")) {
            BlockPos centerDest = BlockPos.func_177969_a((long)capsule.func_77978_p().func_74763_f("deployAt"));
            dest = centerDest.func_177982_a(-extendLength, 0, -extendLength);
            capsule.func_77978_p().func_82580_o("deployAt");
        } else {
            dest = anchorBlockPos.func_177982_a(-extendLength, 1, -extendLength);
        }
        String structureName = capsule.func_77978_p().func_74779_i("structureName");
        ArrayList<String> outEntityBlocking = new ArrayList<String>();
        boolean result = StructureSaver.deploy(capsule, world, thrower, dest, Config.overridableBlocks, outEntityBlocking, CapsuleItem.getPlacement(capsule));
        if (result) {
            if (!CapsuleItem.isReward(capsule)) {
                CapsuleItem.saveSpawnPosition(capsule, dest, world.field_73011_w.getDimension());
                CapsuleItem.setState(capsule, 3);
                if (!CapsuleItem.isBlueprint(capsule)) {
                    Capsule.clearTemplate(world, structureName);
                }
            }
            didSpawn = true;
        } else {
            CapsuleItem.revertStateFromActivated(capsule);
        }
        return didSpawn;
    }

    public static boolean captureContentIntoCapsule(ItemStack capsule, BlockPos anchor, String thrower, int size, int extendLength, WorldServer playerWorld) {
        if (anchor != null) {
            BlockPos source = anchor.func_177982_a(-extendLength, 1, -extendLength);
            return Capsule.captureAtPosition(capsule, thrower, size, playerWorld, source);
        }
        CapsuleItem.revertStateFromActivated(capsule);
        EntityPlayer player = playerWorld.func_72924_a(thrower);
        if (player != null) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("capsule.error.noCaptureBase", new Object[0]));
        }
        return false;
    }

    public static boolean captureAtPosition(ItemStack capsule, String thrower, int size, WorldServer playerWorld, BlockPos source) {
        String capsuleID;
        CapsuleTemplate template;
        boolean storageOK;
        String player = "CapsuleMod";
        if (thrower != null) {
            player = thrower;
        }
        boolean bl = storageOK = (template = StructureSaver.undeploy(playerWorld, player, capsuleID = StructureSaver.getUniqueName(playerWorld, player), source, size, CapsuleItem.getExcludedBlocs(capsule), null)) != null;
        if (storageOK) {
            CapsuleItem.setState(capsule, 2);
            CapsuleItem.setStructureName(capsule, capsuleID);
            CapsuleItem.setCanRotate(capsule, template.canRotate());
            CapsuleItem.setPlacement(capsule, new PlacementSettings());
            return true;
        }
        CapsuleItem.revertStateFromActivated(capsule);
        return false;
    }

    public static void showUndeployParticules(WorldClient world, BlockPos posFrom, BlockPos posTo, int size) {
        for (int i = 0; i < 8 * size; ++i) {
            double x = (double)posFrom.func_177958_n() + 0.5 + Math.random() * (double)size - (double)size * 0.5;
            double y = (double)posFrom.func_177956_o() + Math.random() * (double)size - (double)size * 0.5;
            double z = (double)posFrom.func_177952_p() + 0.5 + Math.random() * (double)size - (double)size * 0.5;
            Vec3d speed = new Vec3d((double)posTo.func_177958_n() - x, (double)posTo.func_177956_o() - y, (double)posTo.func_177952_p() - z);
            double speedFactor = (double)0.1f + speed.func_72433_c() * (double)0.04f;
            speed = speed.func_72432_b();
            world.func_175688_a(EnumParticleTypes.CLOUD, x, y, z, speed.field_72450_a * speedFactor, speed.field_72448_b * speedFactor, speed.field_72449_c * speedFactor, new int[0]);
        }
    }

    public static void showDeployParticules(WorldServer world, BlockPos blockpos, int size) {
        double d0 = (double)blockpos.func_177958_n() + 0.5;
        double d1 = (double)blockpos.func_177956_o() + 0.5;
        double d2 = (double)blockpos.func_177952_p() + 0.5;
        world.func_175739_a(EnumParticleTypes.CLOUD, d0, d1, d2, 8 * size, 0.5, 0.25, 0.5, 0.01 + 0.05 * (double)size, new int[0]);
    }

    @Nullable
    public static Map<StructureSaver.ItemStackKey, Integer> reloadBlueprint(ItemStack blueprint, WorldServer world, EntityPlayer player) {
        Map<StructureSaver.ItemStackKey, Integer> missingMaterials = Blueprint.getMaterialList(blueprint, world, player);
        if (missingMaterials == null) {
            if (player != null) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("capsule.error.technicalError", new Object[0]));
            }
            return null;
        }
        IItemHandler inv = CapsuleItem.getSourceInventory(blueprint, world);
        IItemHandler inv2 = player == null ? null : (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        Map<Integer, Integer> inv1SlotQuantityProvisions = Capsule.recordSlotQuantityProvisions(missingMaterials, inv);
        Map<Integer, Integer> inv2SlotQuantityProvisions = Capsule.recordSlotQuantityProvisions(missingMaterials, inv2);
        if (missingMaterials.size() == 0) {
            if (inv != null) {
                inv1SlotQuantityProvisions.forEach((slot, qty) -> Capsule.extractItemOrFluid(inv, slot, qty));
            }
            if (inv2 != null) {
                inv2SlotQuantityProvisions.forEach((slot, qty) -> Capsule.extractItemOrFluid(inv2, slot, qty));
            }
            CapsuleItem.setState(blueprint, 7);
            CapsuleItem.cleanDeploymentTags(blueprint);
        } else if (player != null && player.func_184812_l_()) {
            CapsuleItem.setState(blueprint, 7);
            CapsuleItem.cleanDeploymentTags(blueprint);
            missingMaterials.clear();
        }
        return missingMaterials;
    }

    public static void extractItemOrFluid(IItemHandler inv, Integer slot, Integer qty) {
        ItemStack item = inv.extractItem(slot.intValue(), qty.intValue(), false);
        ItemStack container = ForgeHooks.getContainerItem((ItemStack)item);
        inv.insertItem(slot.intValue(), container, false);
    }

    private static Map<Integer, Integer> recordSlotQuantityProvisions(Map<StructureSaver.ItemStackKey, Integer> missingMaterials, IItemHandler inv) {
        HashMap<Integer, Integer> invSlotQuantityProvisions = new HashMap<Integer, Integer>();
        if (inv != null) {
            int size = inv.getSlots();
            for (int invSlot = 0; invSlot < size; ++invSlot) {
                ItemStack invStack = inv.getStackInSlot(invSlot);
                StructureSaver.ItemStackKey stackKey = new StructureSaver.ItemStackKey(invStack);
                Integer missing = missingMaterials.get(stackKey);
                if (missing == null || missing <= 0 || invStack.func_190916_E() <= 0) continue;
                if (invStack.func_190916_E() >= missing) {
                    missingMaterials.remove(stackKey);
                    invSlotQuantityProvisions.put(invSlot, missing);
                    continue;
                }
                missingMaterials.put(stackKey, missing - invStack.func_190916_E());
                invSlotQuantityProvisions.put(invSlot, invStack.func_190916_E());
            }
        }
        return invSlotQuantityProvisions;
    }

    public static EntityItem throwCapsule(ItemStack capsule, EntityPlayer playerIn, BlockPos destination) {
        double startPosition = playerIn.field_70163_u - 0.3 + (double)playerIn.func_70047_e();
        EntityItem entityitem = new EntityItem(playerIn.func_130014_f_(), playerIn.field_70165_t, startPosition, playerIn.field_70161_v, capsule);
        entityitem.func_174867_a(20);
        entityitem.func_145799_b(playerIn.func_70005_c_());
        entityitem.func_174873_u();
        if (destination != null && capsule.func_77978_p() != null) {
            capsule.func_77978_p().func_74772_a("deployAt", destination.func_177986_g());
            Spacial.moveEntityItemToDeployPos(entityitem, capsule, false);
            BlockPos playerPos = playerIn.func_180425_c();
            double diffX = (double)destination.func_177958_n() + 0.5 - (double)playerPos.func_177958_n();
            double diffZ = (double)destination.func_177952_p() + 0.5 - (double)playerPos.func_177952_p();
            double flatDistance = MathHelper.func_76133_a((double)(diffX * diffX + diffZ * diffZ));
            double diffY = (double)(destination.func_177956_o() - playerPos.func_177956_o()) + Math.min(1.0, flatDistance / 3.0);
            double yVelocity = diffY / 10.0 - -0.19999999552965164;
            entityitem.field_70181_x = Math.max(0.05, yVelocity);
        } else {
            float f = 0.5f;
            entityitem.field_70159_w = (double)(-MathHelper.func_76126_a((float)(playerIn.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(playerIn.field_70125_A * ((float)Math.PI / 180))) * f) + playerIn.field_70159_w;
            entityitem.field_70179_y = (double)(MathHelper.func_76134_b((float)(playerIn.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(playerIn.field_70125_A * ((float)Math.PI / 180))) * f) + playerIn.field_70179_y;
            entityitem.field_70181_x = (double)(-MathHelper.func_76126_a((float)(playerIn.field_70125_A * ((float)Math.PI / 180))) * f + 0.1f) + playerIn.field_70181_x;
        }
        playerIn.func_184816_a(entityitem);
        playerIn.field_71071_by.func_70299_a(playerIn.field_71071_by.field_70461_c, ItemStack.field_190927_a);
        playerIn.func_130014_f_().func_184133_a(null, entityitem.func_180425_c(), SoundEvents.field_187737_v, SoundCategory.BLOCKS, 0.2f, 0.1f);
        return entityitem;
    }

    public static ItemStack newRewardCapsuleItemStack(String structureName, int baseColor, int materialColor, int size, @Nullable String label, @Nullable String author) {
        ItemStack capsule = Capsule.newEmptyCapsuleItemStack(baseColor, materialColor, size, false, label, null);
        CapsuleItem.setIsReward(capsule);
        CapsuleItem.setStructureName(capsule, structureName);
        CapsuleItem.setAuthor(capsule, author);
        return capsule;
    }

    public static ItemStack newLinkedCapsuleItemStack(String structureName, int baseColor, int materialColor, int size, boolean overpowered, @Nullable String label, @Nullable Integer upgraded) {
        ItemStack capsule = Capsule.newEmptyCapsuleItemStack(baseColor, materialColor, size, overpowered, label, upgraded);
        CapsuleItem.setStructureName(capsule, structureName);
        CapsuleItem.setState(capsule, 2);
        return capsule;
    }

    public static ItemStack newEmptyCapsuleItemStack(int baseColor, int materialColor, int size, boolean overpowered, @Nullable String label, @Nullable Integer upgraded) {
        ItemStack capsule = new ItemStack((Item)CapsuleItems.capsule, 1, 0);
        MinecraftNBT.setColor(capsule, baseColor);
        capsule.func_77983_a("color", (NBTBase)new NBTTagInt(materialColor));
        capsule.func_77983_a("size", (NBTBase)new NBTTagInt(size));
        if (upgraded != null) {
            capsule.func_77983_a("upgraded", (NBTBase)new NBTTagInt(upgraded.intValue()));
        }
        if (overpowered) {
            capsule.func_77983_a("overpowered", (NBTBase)new NBTTagByte(1));
        }
        if (label != null) {
            capsule.func_77983_a("label", (NBTBase)new NBTTagString(label));
        }
        return capsule;
    }

    public static void handleEntityItemOnGround(EntityItem entityItem, ItemStack capsule) {
        entityItem.field_70159_w = 0.0;
        entityItem.field_70179_y = 0.0;
        entityItem.field_70181_x = 0.0;
        int size = CapsuleItem.getSize(capsule);
        int extendLength = (size - 1) / 2;
        WorldServer itemWorld = (WorldServer)entityItem.func_130014_f_();
        if (CapsuleItem.hasStructureLink(capsule)) {
            BlockPos throwPos = Spacial.findBottomBlock(entityItem);
            boolean deployed = Capsule.deployCapsule(capsule, throwPos, entityItem.func_145800_j(), extendLength, itemWorld);
            if (deployed) {
                itemWorld.func_184133_a(null, entityItem.func_180425_c(), SoundEvents.field_187596_cD, SoundCategory.BLOCKS, 0.4f, 0.1f);
                Capsule.showDeployParticules(itemWorld, entityItem.func_180425_c(), size);
            }
            if (deployed && CapsuleItem.isOneUse(capsule)) {
                entityItem.func_70106_y();
            }
        } else {
            try {
                BlockPos anchor = Spacial.findSpecificBlock(entityItem, size + 2, BlockCapsuleMarker.class);
                boolean captured = Capsule.captureContentIntoCapsule(capsule, anchor, entityItem.func_145800_j(), size, extendLength, itemWorld);
                if (captured) {
                    BlockPos center = anchor.func_177982_a(0, size / 2, 0);
                    CommonProxy.simpleNetworkWrapper.sendToAllAround((IMessage)new CapsuleUndeployNotifToClient(center, entityItem.func_180425_c(), size), new NetworkRegistry.TargetPoint(entityItem.field_71093_bK, (double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p(), (double)(200 + size)));
                }
            }
            catch (Exception e) {
                LOGGER.error("Couldn't capture the content into the capsule", (Throwable)e);
            }
        }
    }

    public static String labelFromPath(String path) {
        if (path.contains("/")) {
            return WordUtils.capitalize((String)path.substring(path.lastIndexOf("/") + 1).replace("_", " "));
        }
        return WordUtils.capitalize((String)path.replace("_", " "));
    }

    public static ItemStack createLinkedCapsuleFromReward(String srcStructurePath, EntityPlayerMP player) {
        if (player == null) {
            return ItemStack.field_190927_a;
        }
        CapsuleTemplate srcTemplate = Capsule.getRewardTemplateIfExists(srcStructurePath, player.func_184102_h());
        if (srcTemplate == null) {
            return ItemStack.field_190927_a;
        }
        int size = Math.max(srcTemplate.getSize().func_177958_n(), Math.max(srcTemplate.getSize().func_177956_o(), srcTemplate.getSize().func_177952_p()));
        if (size % 2 == 0) {
            ++size;
        }
        String destStructureName = StructureSaver.getUniqueName(player.func_71121_q(), player.func_70005_c_() + "-" + srcStructurePath.replace("/", "_"));
        ItemStack capsule = Capsule.newLinkedCapsuleItemStack(destStructureName, CapsuleLootEntry.getRandomColor(), CapsuleLootEntry.getRandomColor(), size, false, Capsule.labelFromPath(srcStructurePath), 0);
        NBTTagCompound srcData = new NBTTagCompound();
        srcTemplate.writeToNBT(srcData);
        StructureSaver.duplicateTemplate(srcData, destStructureName, StructureSaver.getTemplateManager(player.func_71121_q()), player.func_184102_h());
        return capsule;
    }

    public static CapsuleTemplate getRewardTemplateIfExists(String structurePath, MinecraftServer server) {
        CapsuleTemplateManager srcTemplatemanager = StructureSaver.getRewardManager(server);
        return srcTemplatemanager.get(server, new ResourceLocation(structurePath));
    }

    public static boolean clearTemplate(WorldServer worldserver, String capsuleStructureId) {
        MinecraftServer minecraftserver = worldserver.func_73046_m();
        CapsuleTemplateManager templatemanager = StructureSaver.getTemplateManager(worldserver);
        if (templatemanager == null) {
            LOGGER.error("getTemplateManager returned null");
            return false;
        }
        CapsuleTemplate template = templatemanager.getTemplate(minecraftserver, new ResourceLocation(capsuleStructureId));
        List<Template.BlockInfo> blocks = template.blocks;
        List<Template.EntityInfo> entities = template.entities;
        blocks.clear();
        entities.clear();
        return templatemanager.writeTemplate(minecraftserver, new ResourceLocation(capsuleStructureId));
    }
}

