/*
 * Decompiled with CFR 0.152.
 */
package capsule.client;

import capsule.Config;
import capsule.blocks.CaptureTESR;
import capsule.blocks.TileEntityCapture;
import capsule.client.FakeWorld;
import capsule.client.RendererUtils;
import capsule.helpers.Spacial;
import capsule.items.CapsuleItem;
import capsule.structure.CapsuleTemplate;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

public class CapsulePreviewHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Map<String, List<AxisAlignedBB>> currentPreview = new HashMap<String, List<AxisAlignedBB>>();
    public static final Map<String, CapsuleTemplate> currentFullPreview = new HashMap<String, CapsuleTemplate>();
    private int lastSize = 0;
    private int lastColor = 0;
    private static int uncompletePreviewsCount = 0;
    private static int completePreviewsCount = 0;
    private static String uncompletePreviewsCountStructure = null;
    static double time = 0.0;
    static FakeWorld fakeWorld = new FakeWorld();
    public static final double NS_TO_MS = 1.0E-6;

    @SubscribeEvent
    public void onWorldRenderLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        time += 1.0;
        if (mc.field_71439_g != null) {
            this.tryPreviewRecall(mc.field_71439_g.func_184614_ca());
            this.tryPreviewDeploy(mc.field_71439_g, event.getPartialTicks(), mc.field_71439_g.func_184614_ca());
            this.tryPreviewLinkedInventory(mc.field_71439_g, mc.field_71439_g.func_184614_ca());
        }
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(TickEvent.PlayerTickEvent event) {
        if (event.player instanceof EntityPlayerSP && event.phase.equals((Object)TickEvent.Phase.START)) {
            EntityPlayerSP player = (EntityPlayerSP)event.player;
            this.tryPreviewCapture(player, player.func_184614_ca());
        }
    }

    @SubscribeEvent
    public void OnClientChatEvent(ClientChatEvent event) {
        if ("/capsule downloadTemplate".equals(event.getMessage())) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g != null) {
                ItemStack heldItem = mc.field_71439_g.func_184614_ca();
                String structureName = CapsuleItem.getStructureName(heldItem);
                if (heldItem.func_77973_b() instanceof CapsuleItem && structureName != null) {
                    CapsuleTemplate template = currentFullPreview.get(structureName);
                    Path path = new File("capsule_exports").toPath();
                    try {
                        Files.createDirectories(Files.exists(path, new LinkOption[0]) ? path.toRealPath(new LinkOption[0]) : path, new FileAttribute[0]);
                    }
                    catch (IOException var19) {
                        LOGGER.error("Failed to create parent directory: {}", (Object)path);
                    }
                    try {
                        NBTTagCompound compoundnbt = template.writeToNBT(new NBTTagCompound());
                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd-HH-mm");
                        Path filePath = path.resolve(df.format(new Date()) + "-" + structureName + ".nbt");
                        CompressedStreamTools.func_74799_a((NBTTagCompound)compoundnbt, (OutputStream)new DataOutputStream(new FileOutputStream(filePath.toFile())));
                        mc.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("\u2192 <minecraftInstance>/" + filePath.toString().replace("\\", "/")));
                    }
                    catch (Throwable var21) {
                        LOGGER.error((Object)var21);
                        mc.field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation("capsule.error.cantDownload", new Object[0]));
                    }
                } else {
                    mc.field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation("capsule.error.cantDownload", new Object[0]));
                }
            }
        }
    }

    private boolean tryPreviewCapture(EntityPlayerSP player, ItemStack heldItem) {
        if (!heldItem.func_190926_b()) {
            Item heldItemItem = heldItem.func_77973_b();
            if (heldItemItem instanceof CapsuleItem && (heldItem.func_77952_i() == 0 || heldItem.func_77952_i() == 4)) {
                CapsuleItem capsule = (CapsuleItem)heldItem.func_77973_b();
                if (heldItem.func_77942_o() && heldItem.func_77978_p().func_74764_b("size")) {
                    this.setCaptureTESizeColor(heldItem.func_77978_p().func_74762_e("size"), CapsuleItem.getBaseColor(heldItem), player.func_130014_f_());
                    return true;
                }
            } else {
                this.setCaptureTESizeColor(0, 0, player.func_130014_f_());
            }
        } else {
            this.setCaptureTESizeColor(0, 0, player.func_130014_f_());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryPreviewDeploy(EntityPlayerSP thePlayer, float partialTicks, ItemStack heldItemMainhand) {
        int size;
        RayTraceResult rtc;
        if (heldItemMainhand.func_77973_b() instanceof CapsuleItem && heldItemMainhand.func_77942_o() && (heldItemMainhand.func_77952_i() == 1 || heldItemMainhand.func_77952_i() == 6 || heldItemMainhand.func_77952_i() == 7 || CapsuleItem.getSize(heldItemMainhand) == 1 && heldItemMainhand.func_77952_i() != 3) && (rtc = Spacial.clientRayTracePreview((EntityPlayer)thePlayer, partialTicks, size = CapsuleItem.getSize(heldItemMainhand))) != null && rtc.field_72313_a == RayTraceResult.Type.BLOCK) {
            int extendSize = (size - 1) / 2;
            BlockPos destOriginPos = rtc.func_178782_a().func_177971_a(rtc.field_178784_b.func_176730_m()).func_177963_a((double)(-extendSize), 0.01, (double)(-extendSize));
            String structureName = heldItemMainhand.func_77978_p().func_74779_i("structureName");
            if (!structureName.equals(uncompletePreviewsCountStructure)) {
                uncompletePreviewsCountStructure = structureName;
                uncompletePreviewsCount = 0;
                completePreviewsCount = 0;
            }
            AxisAlignedBB errorBoundingBox = new AxisAlignedBB(0.0, 0.01, 0.0, 1.01, 1.01, 1.01);
            Map<String, List<AxisAlignedBB>> map = currentPreview;
            synchronized (map) {
                Map<String, CapsuleTemplate> map2 = currentFullPreview;
                synchronized (map2) {
                    boolean haveFullPreview = currentFullPreview.containsKey(structureName);
                    boolean isRenderComplete = false;
                    if (haveFullPreview && completePreviewsCount + uncompletePreviewsCount > 60) {
                        boolean bl = haveFullPreview = completePreviewsCount > uncompletePreviewsCount;
                    }
                    if (haveFullPreview) {
                        isRenderComplete = CapsulePreviewHandler.DisplayFullPreview(destOriginPos, structureName, extendSize, heldItemMainhand, (IBlockAccess)thePlayer.field_70170_p);
                        if (isRenderComplete) {
                            ++completePreviewsCount;
                        } else {
                            ++uncompletePreviewsCount;
                        }
                    }
                    if (currentPreview.containsKey(structureName) || size == 1) {
                        this.DisplayWireframePreview(thePlayer, heldItemMainhand, size, rtc, extendSize, destOriginPos, structureName, errorBoundingBox, haveFullPreview && isRenderComplete);
                    }
                }
            }
        }
    }

    private static boolean DisplayFullPreview(BlockPos destOriginPos, String structureName, int extendSize, ItemStack heldItemMainhand, IBlockAccess world) {
        boolean isRenderComplete = true;
        RenderManager info = Minecraft.func_71410_x().func_175598_ae();
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        CapsuleTemplate template = currentFullPreview.get(structureName);
        PlacementSettings placement = CapsuleItem.getPlacement(heldItemMainhand);
        BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
        float glitchIntensity = (float)(Math.cos(time * (double)0.1f) * Math.cos(time * (double)0.14f) * Math.cos(time * (double)0.12f)) - 0.3f;
        glitchIntensity = (float)Math.min(0.05, (double)Math.max(0.0f, glitchIntensity));
        float glitchIntensity2 = (float)(Math.cos(time * (double)0.12f) * Math.cos(time * (double)0.15f) * Math.cos(time * (double)0.14f)) * glitchIntensity;
        float glitchValue = (float)Math.min(0.12, Math.max(0.0, Math.tan(time * 0.5)));
        float glitchValuey = (float)Math.min(0.32, Math.max(0.0, Math.tan(time * 0.2)));
        float glitchValuez = (float)Math.min(0.12, Math.max(0.0, Math.tan(time * 0.8)));
        long start = System.nanoTime();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(glitchIntensity2 * glitchValue), (float)(glitchIntensity * glitchValuey), (float)(glitchIntensity2 * glitchValuez));
        GlStateManager.func_179152_a((float)(1.0f + glitchIntensity2 * glitchValuez), (float)(1.0f + glitchIntensity * glitchValuey), (float)1.0f);
        fakeWorld.clear();
        for (Template.BlockInfo blockInfo : template.blocks) {
            long elapsedTime;
            BlockPos blockpos = CapsuleTemplate.transformedBlockPos(placement, blockInfo.field_186242_a).func_177971_a((Vec3i)CapsuleTemplate.recenterRotation(extendSize, placement)).func_177971_a((Vec3i)destOriginPos);
            IBlockState state = blockInfo.field_186243_b;
            fakeWorld.add(blockpos, blockInfo);
            if (state != Blocks.field_150350_a.func_176223_P() && state.func_185901_i() != EnumBlockRenderType.INVISIBLE) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(-info.field_78730_l), (double)(-info.field_78731_m), (double)(-info.field_78728_n));
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179132_a((boolean)false);
                RenderHelper.func_74518_a();
                GlStateManager.func_179145_e();
                textureManager.func_110577_a(TextureMap.field_110575_b);
                if (Minecraft.func_71379_u()) {
                    GlStateManager.func_179103_j((int)7425);
                } else {
                    GlStateManager.func_179103_j((int)7424);
                }
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferBuilder = tessellator.func_178180_c();
                bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                blockrendererdispatcher.func_175018_a(state, blockpos, (IBlockAccess)fakeWorld, bufferBuilder);
                GlStateManager.func_179140_f();
                RenderHelper.func_74519_b();
                GlStateManager.func_179132_a((boolean)true);
                tessellator.func_78381_a();
                GlStateManager.func_179121_F();
            }
            ForgeHooksClient.setRenderLayer(null);
            if (completePreviewsCount + uncompletePreviewsCount > 60 || !((double)(elapsedTime = System.nanoTime() - start) * 1.0E-6 > 8.0)) continue;
            isRenderComplete = false;
            break;
        }
        GlStateManager.func_179121_F();
        return isRenderComplete;
    }

    private void DisplayWireframePreview(EntityPlayerSP thePlayer, ItemStack heldItemMainhand, int size, RayTraceResult rtc, int extendSize, BlockPos destOriginPos, String structureName, AxisAlignedBB errorBoundingBox, boolean haveFullPreview) {
        BlockPos pos;
        List<Object> blockspos = new ArrayList();
        if (size > 1) {
            blockspos = currentPreview.get(structureName);
        } else if (heldItemMainhand.func_77952_i() == 0) {
            pos = rtc.func_178782_a().func_177973_b((Vec3i)destOriginPos);
            blockspos.add(new AxisAlignedBB(pos, pos));
        }
        if (blockspos.isEmpty()) {
            pos = new BlockPos(extendSize, 0, extendSize);
            blockspos.add(new AxisAlignedBB(pos, pos));
        }
        RendererUtils.doPositionPrologue();
        RendererUtils.doWirePrologue();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        PlacementSettings placement = CapsuleItem.getPlacement(heldItemMainhand);
        for (AxisAlignedBB axisAlignedBB : blockspos) {
            BlockPos recenter = CapsuleTemplate.recenterRotation(extendSize, placement);
            AxisAlignedBB dest = CapsuleTemplate.transformedAxisAlignedBB(placement, axisAlignedBB).func_72317_d((double)destOriginPos.func_177958_n(), (double)destOriginPos.func_177956_o() + 0.01, (double)destOriginPos.func_177952_p()).func_72317_d((double)recenter.func_177958_n(), (double)recenter.func_177956_o(), (double)recenter.func_177952_p()).func_72321_a(1.0, 1.0, 1.0);
            int color = 0xDDDDDD;
            if (heldItemMainhand.func_77952_i() == 0) {
                GL11.glLineWidth((float)5.0f);
                color = CapsuleItem.getBaseColor(heldItemMainhand);
            } else {
                for (double j = dest.field_72339_c; j < dest.field_72334_f; j += 1.0) {
                    for (double k = dest.field_72338_b; k < dest.field_72337_e; k += 1.0) {
                        for (double l = dest.field_72340_a; l < dest.field_72336_d; l += 1.0) {
                            BlockPos pos2 = new BlockPos(l, k, j);
                            if (Config.overridableBlocks.contains(thePlayer.func_130014_f_().func_180495_p(pos2).func_177230_c())) continue;
                            GL11.glLineWidth((float)5.0f);
                            bufferBuilder.func_181668_a(2, DefaultVertexFormats.field_181705_e);
                            RendererUtils.setColor(0xAA0000, 50);
                            RendererUtils.drawCapsuleCube(errorBoundingBox.func_186670_a(pos2), bufferBuilder);
                            tessellator.func_78381_a();
                        }
                    }
                }
            }
            if (haveFullPreview) continue;
            GL11.glLineWidth((float)1.0f);
            bufferBuilder.func_181668_a(2, DefaultVertexFormats.field_181705_e);
            RendererUtils.setColor(color, 50);
            RendererUtils.drawCapsuleCube(dest, bufferBuilder);
            tessellator.func_78381_a();
        }
        RendererUtils.setColor(0xFFFFFF, 255);
        RendererUtils.doWireEpilogue();
        RendererUtils.doPositionEpilogue();
    }

    private void tryPreviewRecall(ItemStack heldItem) {
        Item heldItemItem;
        if (heldItem != null && (heldItemItem = heldItem.func_77973_b()) instanceof CapsuleItem && (heldItem.func_77952_i() == 3 || heldItem.func_77952_i() == 7) && heldItem.func_77942_o() && heldItem.func_77978_p().func_74764_b("spawnPosition")) {
            this.previewRecall(heldItem);
        }
    }

    private void tryPreviewLinkedInventory(EntityPlayerSP player, ItemStack heldItem) {
        Item heldItemItem;
        if (heldItem != null && (heldItemItem = heldItem.func_77973_b()) instanceof CapsuleItem && CapsuleItem.isBlueprint(heldItem) && CapsuleItem.hasSourceInventory(heldItem)) {
            BlockPos location = CapsuleItem.getSourceInventoryLocation(heldItem);
            Integer dimension = CapsuleItem.getSourceInventoryDimension(heldItem);
            if (location != null && dimension != null && dimension.equals(player.field_71093_bK) && location.func_177957_d(player.field_70165_t, player.field_70163_u, player.field_70161_v) < 3600.0) {
                this.previewLinkedInventory(location, heldItem);
            }
        }
    }

    private void previewLinkedInventory(BlockPos location, ItemStack capsule) {
        float shrink = 0.05f;
        AxisAlignedBB boundingBox = new AxisAlignedBB((double)(shrink + (float)location.func_177958_n()), (double)(shrink + (float)location.func_177956_o()), (double)(shrink + (float)location.func_177952_p()), (double)(1.0f - shrink + (float)location.func_177958_n()), (double)(1.0f - shrink + (float)location.func_177956_o()), (double)(1.0f - shrink + (float)location.func_177952_p()));
        RendererUtils.doPositionPrologue();
        RendererUtils.doOverlayPrologue();
        RendererUtils.setColor(6003967, 80);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        RendererUtils.drawCube(location, 0.0f, bufferBuilder);
        tessellator.func_78381_a();
        RendererUtils.setColor(0xFFFFFF, 255);
        RendererUtils.doOverlayEpilogue();
        RendererUtils.doPositionEpilogue();
    }

    private void previewRecall(ItemStack capsule) {
        if (capsule.func_77978_p() == null) {
            return;
        }
        NBTTagCompound linkPos = capsule.func_77978_p().func_74775_l("spawnPosition");
        int size = CapsuleItem.getSize(capsule);
        int extendSize = (size - 1) / 2;
        int color = CapsuleItem.getBaseColor(capsule);
        CaptureTESR.drawCaptureZone(linkPos.func_74762_e("x") + extendSize, linkPos.func_74762_e("y") - 1, linkPos.func_74762_e("z") + extendSize, size, extendSize, color);
    }

    private void setCaptureTESizeColor(int size, int color, World worldIn) {
        if (size == this.lastSize && color == this.lastColor) {
            return;
        }
        for (TileEntityCapture te : TileEntityCapture.instances) {
            if (te.func_145831_w() != worldIn) continue;
            TileEntityCapture tec = te;
            tec.getTileData().func_74768_a("size", size);
            tec.getTileData().func_74768_a("color", color);
            worldIn.func_175704_b(te.func_174877_v().func_177982_a(-size / 2, -size / 2, -size / 2), te.func_174877_v().func_177982_a(size / 2, size / 2, size / 2));
        }
        this.lastSize = size;
        this.lastColor = color;
    }
}

