/*
 * Decompiled with CFR 0.152.
 */
package capsule;

import capsule.CapsuleSavedData;
import capsule.Config;
import capsule.items.CapsuleItem;
import capsule.structure.CapsuleTemplate;
import capsule.structure.CapsuleTemplateManager;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StructureSaver {
    protected static final Logger LOGGER = LogManager.getLogger(StructureSaver.class);
    public static final String BLUEPRINT_PREFIX = "B-";
    public static Map<String, CapsuleTemplateManager> CapsulesManagers = new HashMap<String, CapsuleTemplateManager>();
    private static CapsuleTemplateManager RewardManager = null;
    private static List<String> outExcluded = new ArrayList<String>();

    public static CapsuleTemplateManager getRewardManager(MinecraftServer server) {
        if (RewardManager == null) {
            RewardManager = new CapsuleTemplateManager(server.func_71238_n().getPath(), (DataFixer)FMLCommonHandler.instance().getDataFixer());
            File rewardDir = new File(Config.rewardTemplatesPath);
            if (!rewardDir.exists()) {
                rewardDir.mkdirs();
            }
        }
        return RewardManager;
    }

    public static CapsuleTemplate undeploy(WorldServer worldserver, String playerID, String capsuleStructureId, BlockPos startPos, int size, List<Block> excluded, Map<BlockPos, Block> legacyItemOccupied) {
        boolean writingOK;
        MinecraftServer minecraftserver = worldserver.func_73046_m();
        if (minecraftserver == null) {
            LOGGER.error("worldserver.getMinecraftServer() returned null");
            return null;
        }
        ArrayList<Entity> outCapturedEntities = new ArrayList<Entity>();
        CapsuleTemplateManager templatemanager = StructureSaver.getTemplateManager(worldserver);
        if (templatemanager == null) {
            LOGGER.error("getTemplateManager returned null");
            return null;
        }
        CapsuleTemplate template = templatemanager.getTemplate(minecraftserver, new ResourceLocation(capsuleStructureId));
        Map<BlockPos, Block> occupiedPositions = template.occupiedPositions;
        if (legacyItemOccupied != null) {
            occupiedPositions = legacyItemOccupied;
        }
        List<BlockPos> transferedPositions = template.snapshotBlocksFromWorld((World)worldserver, startPos, new BlockPos(size, size, size), occupiedPositions, excluded, outCapturedEntities);
        template.removeOccupiedPositions();
        EntityPlayer player = null;
        if (playerID != null) {
            template.setAuthor(playerID);
            player = worldserver.func_72924_a(playerID);
        }
        if (writingOK = templatemanager.writeTemplate(minecraftserver, new ResourceLocation(capsuleStructureId))) {
            List<BlockPos> couldNotBeRemoved = StructureSaver.removeTransferedBlockFromWorld(transferedPositions, worldserver, player);
            for (Entity e : outCapturedEntities) {
                e.func_184174_b(false);
                e.func_70106_y();
            }
            if (couldNotBeRemoved != null) {
                template.removeBlocks(couldNotBeRemoved, startPos);
            }
            templatemanager.writeTemplate(minecraftserver, new ResourceLocation(capsuleStructureId));
        } else {
            StructureSaver.printWriteTemplateError(player, capsuleStructureId);
        }
        return template;
    }

    public static boolean undeployBlueprint(WorldServer worldserver, String playerID, ItemStack blueprintItemStack, BlockPos startPos, int size, List<Block> excluded) {
        MinecraftServer minecraftserver = worldserver.func_73046_m();
        if (minecraftserver == null) {
            return false;
        }
        Pair<CapsuleTemplateManager, CapsuleTemplate> blueprint = StructureSaver.getTemplate(blueprintItemStack, worldserver);
        CapsuleTemplate blueprintTemplate = (CapsuleTemplate)blueprint.getRight();
        if (blueprintTemplate == null) {
            return false;
        }
        CapsuleTemplate tempTemplate = new CapsuleTemplate();
        Map<BlockPos, Block> occupiedPositions = blueprintTemplate.occupiedPositions;
        Map<BlockPos, Block> legacyItemOccupied = CapsuleItem.getOccupiedSourcePos(blueprintItemStack);
        if (legacyItemOccupied != null) {
            occupiedPositions = legacyItemOccupied;
        }
        List<BlockPos> transferedPositions = tempTemplate.snapshotBlocksFromWorld((World)worldserver, startPos, new BlockPos(size, size, size), occupiedPositions, excluded, null);
        List worldBlocks = tempTemplate.blocks.stream().filter(b -> !StructureSaver.isFlowingLiquid(b)).collect(Collectors.toList());
        List blueprintBLocks = blueprintTemplate.blocks.stream().filter(b -> !StructureSaver.isFlowingLiquid(b)).collect(Collectors.toList());
        EntityPlayer player = null;
        if (playerID != null) {
            player = worldserver.func_72924_a(playerID);
        }
        if (blueprintBLocks.size() != worldBlocks.size()) {
            return false;
        }
        List tempTemplateSorted = worldBlocks.stream().map(StructureSaver::serializeComparable).sorted().collect(Collectors.toList());
        List blueprintTemplateSorted = blueprintBLocks.stream().map(StructureSaver::serializeComparable).sorted().collect(Collectors.toList());
        boolean blueprintMatch = IntStream.range(0, tempTemplateSorted.size()).allMatch(i -> ((String)tempTemplateSorted.get(i)).equals(blueprintTemplateSorted.get(i)));
        boolean bl = blueprintMatch = blueprintMatch && worldBlocks.stream().allMatch(b -> b.field_186244_c == null || !b.field_186244_c.func_74764_b("Items") || b.field_186244_c.func_150295_c("Items", 10).func_82582_d());
        if (blueprintMatch) {
            blueprintTemplate.removeOccupiedPositions();
            String capsuleStructureId = CapsuleItem.getStructureName(blueprintItemStack);
            boolean written = ((CapsuleTemplateManager)blueprint.getLeft()).writeTemplate(minecraftserver, new ResourceLocation(capsuleStructureId));
            if (written) {
                List<BlockPos> couldNotBeRemoved = StructureSaver.removeTransferedBlockFromWorld(transferedPositions, worldserver, player);
                if (couldNotBeRemoved != null) {
                    return false;
                }
            } else {
                StructureSaver.printWriteTemplateError(player, capsuleStructureId);
            }
        }
        return blueprintMatch;
    }

    public static String serializeComparable(Template.BlockInfo b) {
        return b.field_186243_b.func_177230_c().func_149739_a() + "@" + b.field_186243_b.func_177230_c().func_180651_a(b.field_186243_b) + (b.field_186244_c == null ? "" : StructureSaver.nbtStringNotEmpty(StructureSaver.filterIdentityNBT(b)));
    }

    public static NBTTagCompound filterIdentityNBT(Template.BlockInfo b) {
        NBTTagCompound nbt = b.field_186244_c.func_74737_b();
        List<String> converted = Config.getBlueprintIdentityNBT(b.field_186243_b.func_177230_c());
        nbt.func_150296_c().removeIf(key -> converted == null || !converted.contains(key));
        return nbt;
    }

    public static String nbtStringNotEmpty(NBTTagCompound nbt) {
        if (nbt.func_82582_d()) {
            return "";
        }
        return nbt.toString();
    }

    public static boolean isFlowingLiquid(Template.BlockInfo b) {
        return b.field_186243_b.func_177230_c() instanceof BlockLiquid && (Integer)b.field_186243_b.func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0;
    }

    @Nullable
    public static CapsuleTemplateManager getTemplateManager(WorldServer worldserver) {
        if (worldserver == null) {
            return null;
        }
        File directory = worldserver.func_72860_G().func_75765_b();
        String directoryPath = directory.getPath();
        if (!CapsulesManagers.containsKey(directoryPath)) {
            File capsuleDir = new File(directory, "structures/capsule");
            capsuleDir.mkdirs();
            CapsulesManagers.put(directoryPath, new CapsuleTemplateManager(capsuleDir.toString(), (DataFixer)FMLCommonHandler.instance().getDataFixer()));
        }
        return CapsulesManagers.get(directoryPath);
    }

    public static List<BlockPos> removeTransferedBlockFromWorld(List<BlockPos> transferedPositions, WorldServer world, EntityPlayer player) {
        ArrayList<BlockPos> couldNotBeRemoved = null;
        boolean flagdoTileDrops = world.func_82736_K().func_82766_b("doTileDrops");
        world.func_82736_K().func_82764_b("doTileDrops", "false");
        world.restoringBlockSnapshots = true;
        for (BlockPos pos : transferedPositions) {
            IBlockState b = world.func_180495_p(pos);
            try {
                if (StructureSaver.playerCanRemove(world, pos, player)) {
                    world.func_175698_g(pos);
                    continue;
                }
                if (couldNotBeRemoved == null) {
                    couldNotBeRemoved = new ArrayList<BlockPos>();
                }
                couldNotBeRemoved.add(pos);
            }
            catch (Exception e) {
                StructureSaver.printDeployError(player, e, "Block crashed during Capsule capture phase : couldn't be removed. Will be ignored.");
                try {
                    world.func_175656_a(pos, b);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (couldNotBeRemoved == null) {
                    couldNotBeRemoved = new ArrayList();
                }
                couldNotBeRemoved.add(pos);
            }
        }
        world.restoringBlockSnapshots = false;
        world.func_82736_K().func_82764_b("doTileDrops", String.valueOf(flagdoTileDrops));
        return couldNotBeRemoved;
    }

    public static boolean deploy(ItemStack capsule, WorldServer playerWorld, String thrower, BlockPos dest, List<Block> overridableBlocks, List<String> outEntityBlocking, PlacementSettings placementsettings) {
        Pair<CapsuleTemplateManager, CapsuleTemplate> templatepair = StructureSaver.getTemplate(capsule, playerWorld);
        CapsuleTemplate template = (CapsuleTemplate)templatepair.getRight();
        if (template == null) {
            return false;
        }
        EntityPlayer player = null;
        if (thrower != null) {
            player = playerWorld.func_72924_a(thrower);
        }
        HashMap<BlockPos, Block> outOccupiedSpawnPositions = new HashMap<BlockPos, Block>();
        int size = CapsuleItem.getSize(capsule);
        boolean destValid = StructureSaver.isDestinationValid(template, placementsettings, playerWorld, dest, size, overridableBlocks, outOccupiedSpawnPositions, outEntityBlocking);
        if (!destValid) {
            StructureSaver.printDeployFailure(outEntityBlocking, player);
            return false;
        }
        if (player != null && !StructureSaver.playerCanPlace(playerWorld, dest, template, player, placementsettings)) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("capsule.error.notAllowed", new Object[0]));
            return false;
        }
        HashMap<BlockPos, Block> occupiedPositions = outOccupiedSpawnPositions;
        ArrayList<BlockPos> spawnedBlocks = new ArrayList<BlockPos>();
        ArrayList<Entity> spawnedEntities = new ArrayList<Entity>();
        CapsuleTemplateManager templateManager = (CapsuleTemplateManager)templatepair.getLeft();
        String capsuleStructureId = CapsuleItem.getStructureName(capsule);
        template.saveOccupiedPositions(occupiedPositions);
        if (!templateManager.writeTemplate(playerWorld.func_73046_m(), new ResourceLocation(capsuleStructureId))) {
            StructureSaver.printWriteTemplateError(player, capsuleStructureId);
            return false;
        }
        try {
            template.spawnBlocksAndEntities((World)playerWorld, dest, placementsettings, occupiedPositions, overridableBlocks, spawnedBlocks, spawnedEntities);
            StructureSaver.placePlayerOnTop(playerWorld, dest, size);
            return true;
        }
        catch (Exception err) {
            StructureSaver.printDeployError(player, err, "Couldn't deploy the capsule");
            StructureSaver.removeTransferedBlockFromWorld(spawnedBlocks, playerWorld, player);
            template.removeOccupiedPositions();
            if (!templateManager.writeTemplate(playerWorld.func_73046_m(), new ResourceLocation(capsuleStructureId))) {
                StructureSaver.printWriteTemplateError(player, capsuleStructureId);
            }
            for (Entity e : spawnedEntities) {
                e.func_184174_b(false);
                e.func_70106_y();
            }
            return false;
        }
    }

    public static void placePlayerOnTop(WorldServer playerWorld, BlockPos dest, int size) {
        List players = playerWorld.func_175647_a(EntityLivingBase.class, new AxisAlignedBB((double)dest.func_177958_n(), (double)dest.func_177956_o(), (double)dest.func_177952_p(), (double)(dest.func_177958_n() + size), (double)(dest.func_177956_o() + size), (double)(dest.func_177952_p() + size)), entity -> entity instanceof EntityPlayer);
        for (EntityLivingBase p : players) {
            for (int y = 0; y < size; ++y) {
                if (!playerWorld.func_184143_b(p.func_174813_aQ())) continue;
                p.func_70634_a(p.field_70165_t, p.field_70163_u + 1.0, p.field_70161_v);
            }
        }
    }

    public static void printDeployFailure(List<String> outEntityBlocking, EntityPlayer player) {
        if (player != null) {
            if (outEntityBlocking.size() > 0) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("capsule.error.cantMergeWithDestinationEntity", new Object[]{org.apache.commons.lang3.StringUtils.join(outEntityBlocking, (String)", ")}));
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("capsule.error.cantMergeWithDestination", new Object[0]));
            }
        }
    }

    public static void printDeployError(EntityPlayer player, Exception err, String s) {
        LOGGER.error(s, (Throwable)err);
        if (player != null) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("capsule.error.technicalError", new Object[0]));
        }
    }

    public static void printWriteTemplateError(EntityPlayer player, String capsuleStructureId) {
        LOGGER.error("Couldn't write template " + capsuleStructureId);
        if (player != null) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("capsule.error.technicalError", new Object[0]));
        }
    }

    private static boolean playerCanPlace(WorldServer worldserver, BlockPos dest, CapsuleTemplate template, EntityPlayer player, PlacementSettings placementsettings) {
        if (player != null) {
            List<BlockPos> expectedOut = template.calculateDeployPositions((World)worldserver, dest, placementsettings);
            for (BlockPos blockPos : expectedOut) {
                if (blockPos.func_177956_o() < worldserver.func_72800_K() && StructureSaver.isPlaceEventAllowed(worldserver, blockPos, player)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean playerCanRemove(WorldServer worldserver, BlockPos blockPos, EntityPlayer player) {
        if (player != null) {
            return StructureSaver.isPlaceEventAllowed(worldserver, blockPos, player);
        }
        return true;
    }

    private static boolean isPlaceEventAllowed(WorldServer worldserver, BlockPos blockPos, EntityPlayer player) {
        BlockSnapshot blocksnapshot = new BlockSnapshot((World)worldserver, blockPos, Blocks.field_150350_a.func_176223_P());
        BlockEvent.PlaceEvent event = new BlockEvent.PlaceEvent(blocksnapshot, Blocks.field_150346_d.func_176223_P(), player, EnumHand.MAIN_HAND);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }

    public static Pair<CapsuleTemplateManager, CapsuleTemplate> getTemplate(ItemStack capsule, WorldServer playerWorld) {
        Pair<CapsuleTemplateManager, CapsuleTemplate> template = null;
        boolean isReward = CapsuleItem.isReward(capsule);
        String structureName = CapsuleItem.getStructureName(capsule);
        template = isReward || structureName.startsWith("config/") && CapsuleItem.isBlueprint(capsule) ? StructureSaver.getTemplateForReward(playerWorld.func_73046_m(), structureName) : StructureSaver.getTemplateForCapsule(playerWorld, structureName);
        return template;
    }

    public static Pair<CapsuleTemplateManager, CapsuleTemplate> getTemplateForCapsule(WorldServer playerWorld, String structureName) {
        CapsuleTemplateManager templatemanager = StructureSaver.getTemplateManager(playerWorld);
        if (templatemanager == null || StringUtils.func_151246_b((String)structureName)) {
            return Pair.of(null, null);
        }
        CapsuleTemplate template = templatemanager.getTemplate(playerWorld.func_73046_m(), new ResourceLocation(structureName));
        return Pair.of((Object)templatemanager, (Object)template);
    }

    public static Pair<CapsuleTemplateManager, CapsuleTemplate> getTemplateForReward(MinecraftServer server, String structurePath) {
        CapsuleTemplateManager templatemanager = StructureSaver.getRewardManager(server);
        if (templatemanager == null || StringUtils.func_151246_b((String)structurePath)) {
            return Pair.of(null, null);
        }
        CapsuleTemplate template = templatemanager.getTemplate(server, new ResourceLocation(structurePath));
        return Pair.of((Object)templatemanager, (Object)template);
    }

    public static boolean isDestinationValid(CapsuleTemplate template, PlacementSettings placementIn, WorldServer destWorld, BlockPos destOriginPos, int size, List<Block> overridable, Map<BlockPos, Block> outOccupiedPositions, List<String> outEntityBlocking) {
        IBlockState air = Blocks.field_150350_a.func_176223_P();
        List<Template.BlockInfo> srcblocks = template.blocks;
        HashMap<BlockPos, Template.BlockInfo> blockInfoByPosition = new HashMap<BlockPos, Template.BlockInfo>();
        for (Template.BlockInfo template$blockinfo : srcblocks) {
            BlockPos blockpos = CapsuleTemplate.transformedBlockPos(placementIn, template$blockinfo.field_186242_a).func_177971_a((Vec3i)destOriginPos).func_177971_a((Vec3i)CapsuleTemplate.recenterRotation((size - 1) / 2, placementIn));
            blockInfoByPosition.put(blockpos, template$blockinfo);
        }
        for (int y = size - 1; y >= 0; --y) {
            for (int x = 0; x < size; ++x) {
                for (int z = 0; z < size; ++z) {
                    boolean worldDestOccupied;
                    BlockPos destPos = destOriginPos.func_177982_a(x, y, z);
                    Template.BlockInfo srcInfo = (Template.BlockInfo)blockInfoByPosition.get(destPos);
                    IBlockState templateBlockState = air;
                    if (srcInfo != null) {
                        templateBlockState = srcInfo.field_186243_b;
                    }
                    if (!destWorld.func_175667_e(destPos)) {
                        return false;
                    }
                    IBlockState worldDestState = destWorld.func_180495_p(destPos);
                    boolean bl = worldDestOccupied = worldDestState != air && !overridable.contains(worldDestState.func_177230_c());
                    if (worldDestState != air && outOccupiedPositions != null) {
                        outOccupiedPositions.put(destPos, worldDestState.func_177230_c());
                    }
                    boolean srcOccupied = templateBlockState != air && !overridable.contains(templateBlockState.func_177230_c());
                    List entities = destWorld.func_175647_a(EntityLivingBase.class, new AxisAlignedBB((double)destPos.func_177958_n(), (double)destPos.func_177956_o(), (double)destPos.func_177952_p(), (double)(destPos.func_177958_n() + 1), (double)(destPos.func_177956_o() + 1), (double)(destPos.func_177952_p() + 1)), entity -> !(entity instanceof EntityPlayer));
                    if ((entities.size() <= 0 || !srcOccupied) && (!worldDestOccupied || overridable.contains(templateBlockState.func_177230_c()))) continue;
                    if (entities.size() > 0 && outEntityBlocking != null) {
                        for (Object e : entities) {
                            Entity entity2 = (Entity)e;
                            if (entity2 == null) continue;
                            outEntityBlocking.add(entity2.func_70005_c_());
                        }
                    }
                    return false;
                }
            }
        }
        return true;
    }

    public static String getUniqueName(WorldServer playerWorld, String player) {
        CapsuleSavedData csd = StructureSaver.getCapsuleSavedData(playerWorld);
        String capsuleID = "C-" + player + "-" + csd.getNextCount();
        CapsuleTemplateManager templatemanager = StructureSaver.getTemplateManager(playerWorld);
        if (templatemanager == null) {
            LOGGER.error("getTemplateManager returned null");
            return "CExcetion-" + player + "-" + csd.getNextCount();
        }
        while (templatemanager.get(playerWorld.func_73046_m(), new ResourceLocation(capsuleID)) != null) {
            capsuleID = "C-" + player + "-" + csd.getNextCount();
        }
        return capsuleID;
    }

    public static String getBlueprintUniqueName(WorldServer world) {
        CapsuleSavedData csd = StructureSaver.getCapsuleSavedData(world);
        String capsuleID = BLUEPRINT_PREFIX + csd.getNextCount();
        CapsuleTemplateManager templatemanager = StructureSaver.getTemplateManager(world);
        if (templatemanager == null) {
            LOGGER.error("getTemplateManager returned null");
            return "BException-" + csd.getNextCount();
        }
        while (templatemanager.get(world.func_73046_m(), new ResourceLocation(capsuleID)) != null) {
            capsuleID = BLUEPRINT_PREFIX + csd.getNextCount();
        }
        return capsuleID;
    }

    public static boolean copyFromCapsuleTemplate(ItemStack capsule, String destinationStructureName, CapsuleTemplateManager destManager, WorldServer worldServer, boolean onlyBlocks, List<String> outExcluded) {
        NBTTagCompound srcTemplateData = StructureSaver.getTemplateNBTData(capsule, worldServer);
        if (srcTemplateData == null) {
            return false;
        }
        return StructureSaver.duplicateTemplate(srcTemplateData, destinationStructureName, destManager, worldServer.func_73046_m(), onlyBlocks, outExcluded);
    }

    public static boolean duplicateTemplate(NBTTagCompound templateData, String destinationStructureName, CapsuleTemplateManager destManager, MinecraftServer server) {
        return StructureSaver.duplicateTemplate(templateData, destinationStructureName, destManager, server, false, null);
    }

    public static boolean duplicateTemplate(NBTTagCompound templateData, String destinationStructureName, CapsuleTemplateManager destManager, MinecraftServer server, boolean onlyWhitelisted, List<String> outExcluded) {
        ResourceLocation destinationLocation = new ResourceLocation(destinationStructureName);
        CapsuleTemplate destTemplate = destManager.getTemplate(server, destinationLocation);
        destTemplate.read(templateData);
        destTemplate.occupiedPositions = null;
        if (onlyWhitelisted) {
            List newBlockList = destTemplate.blocks.stream().filter(b -> {
                boolean included;
                ResourceLocation registryName = b.field_186243_b.func_177230_c().getRegistryName();
                boolean bl = included = b.field_186244_c == null || registryName != null && Config.blueprintWhitelist.keySet().contains(registryName.toString());
                if (!included && outExcluded != null) {
                    outExcluded.add(b.field_186243_b.toString());
                }
                return included;
            }).map(b -> {
                if (b.field_186244_c == null) {
                    return b;
                }
                NBTTagCompound nbt = null;
                JsonObject allowedNBT = Config.getBlueprintAllowedNBT(b.field_186243_b.func_177230_c());
                if (allowedNBT != null) {
                    nbt = b.field_186244_c.func_74737_b();
                    nbt.func_150296_c().removeIf(key -> !allowedNBT.has(key));
                } else {
                    nbt = new NBTTagCompound();
                }
                return new Template.BlockInfo(b.field_186242_a, b.field_186243_b, nbt);
            }).collect(Collectors.toList());
            destTemplate.blocks.clear();
            destTemplate.blocks.addAll(newBlockList);
            destTemplate.entities.clear();
        }
        return destManager.writeTemplate(server, destinationLocation);
    }

    public static NBTTagCompound getTemplateNBTData(ItemStack capsule, WorldServer worldServer) {
        return StructureSaver.getTemplateNBTData((CapsuleTemplate)StructureSaver.getTemplate(capsule, worldServer).getRight());
    }

    public static NBTTagCompound getTemplateNBTData(String path, WorldServer worldServer) {
        Pair<CapsuleTemplateManager, CapsuleTemplate> sourcetemplatepair = path.startsWith(Config.rewardTemplatesPath) || path.startsWith("config/") ? StructureSaver.getTemplateForReward(worldServer.func_73046_m(), path) : StructureSaver.getTemplateForCapsule(worldServer, path);
        return StructureSaver.getTemplateNBTData((CapsuleTemplate)sourcetemplatepair.getRight());
    }

    public static NBTTagCompound getTemplateNBTData(CapsuleTemplate template) {
        if (template == null) {
            return null;
        }
        NBTTagCompound data = new NBTTagCompound();
        template.writeToNBT(data);
        return data;
    }

    public static CapsuleSavedData getCapsuleSavedData(WorldServer capsuleWorld) {
        CapsuleSavedData capsuleSavedData = (CapsuleSavedData)capsuleWorld.func_72943_a(CapsuleSavedData.class, "capsuleData");
        if (capsuleSavedData == null) {
            capsuleSavedData = new CapsuleSavedData("capsuleData");
            capsuleWorld.func_72823_a("capsuleData", (WorldSavedData)capsuleSavedData);
            capsuleSavedData.func_76186_a(true);
        }
        return capsuleSavedData;
    }

    @Nullable
    public static String createBlueprintTemplate(String srcStructurePath, ItemStack destCapsule, WorldServer worldServer, EntityPlayer playerIn) {
        boolean created;
        if (worldServer == null) {
            LOGGER.error("worldServer is null");
            return null;
        }
        String destStructureName = StructureSaver.getBlueprintUniqueName(worldServer) + "-" + srcStructurePath.replace("/", "_");
        CapsuleTemplateManager templateManager = StructureSaver.getTemplateManager(worldServer);
        outExcluded.clear();
        boolean bl = created = templateManager != null && StructureSaver.duplicateTemplate(StructureSaver.getTemplateNBTData(srcStructurePath, worldServer), destStructureName, templateManager, worldServer.func_73046_m(), true, outExcluded);
        if (destCapsule.func_77978_p() != null && destCapsule.func_77978_p().func_74764_b("prevStructureName") && templateManager != null) {
            templateManager.deleteTemplate(worldServer.func_73046_m(), new ResourceLocation(destCapsule.func_77978_p().func_74779_i("prevStructureName")));
        }
        if (!created && playerIn != null) {
            playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("capsule.error.blueprintCreationError", new Object[0]));
        }
        if (outExcluded.size() > 0 && playerIn != null) {
            playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("capsule.error.blueprintExcluded", new Object[]{"\n* " + String.join((CharSequence)"\n* ", outExcluded)}));
        }
        return destStructureName;
    }

    public static class ItemStackKey
    implements Comparable<ItemStackKey> {
        public ItemStack itemStack;

        public ItemStackKey(ItemStack itemStack) {
            this.itemStack = itemStack;
        }

        public boolean equals(Object someOther) {
            if (!(someOther instanceof ItemStackKey)) {
                return false;
            }
            ItemStack otherStack = ((ItemStackKey)someOther).itemStack;
            return otherStack.func_77969_a(this.itemStack) && (!otherStack.func_77942_o() && !this.itemStack.func_77942_o() || otherStack.func_77978_p().equals((Object)this.itemStack.func_77978_p()));
        }

        public int hashCode() {
            int val = this.itemStack.func_77973_b().hashCode() * 29 + this.itemStack.func_77952_i();
            return val;
        }

        @Override
        public int compareTo(ItemStackKey o) {
            if (o == null || o.itemStack == null) {
                return 1;
            }
            return this.equals(o) ? 0 : ItemStackKey.serializeItemStack(this.itemStack).compareTo(ItemStackKey.serializeItemStack(o.itemStack));
        }

        public static String serializeItemStack(ItemStack itemstack) {
            return itemstack.func_77973_b().func_77658_a() + "@" + itemstack.func_77952_i();
        }
    }
}

