/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rareice.forge.blocks.entities;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import me.shedaniel.rareice.forge.ItemLocation;
import me.shedaniel.rareice.forge.loot.LootGenerator;
import me.shedaniel.rareice.forge.mixin.BlockAccessor;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class RareIceTileEntity
extends TileEntity
implements ITickable {
    private static final Random RANDOM = new Random();
    private static final ResourceLocation LOOT_TABLE = new ResourceLocation("rare-ice:chests/rare_ice");
    private final NonNullList<ItemStack> itemsContained = NonNullList.func_191196_a();
    private final List<ItemLocation> itemsLocations = new ArrayList<ItemLocation>();
    private boolean setup = false;
    private int delay = 0;

    public void clear() {
        this.itemsContained.clear();
        this.itemsLocations.clear();
    }

    public NonNullList<ItemStack> getItemsContained() {
        return this.itemsContained;
    }

    public List<ItemLocation> getItemsLocations() {
        return this.itemsLocations;
    }

    public void func_145839_a(NBTTagCompound tag) {
        this.loadInitialChunkData(tag);
        this.delay = tag.func_74762_e("RevertDelay");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        this.saveInitialChunkData(tag);
        tag.func_74768_a("RevertDelay", this.delay);
        return tag;
    }

    private NBTTagCompound saveInitialChunkData(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagList itemsTag = new NBTTagList();
        NBTTagList itemLocationsTag = new NBTTagList();
        for (int i = 0; i < this.itemsLocations.size(); ++i) {
            NBTTagCompound CompoundNBT;
            ItemLocation itemLocation = this.itemsLocations.get(i);
            ItemStack stack = (ItemStack)this.itemsContained.get(i);
            if (!stack.func_190926_b()) {
                CompoundNBT = new NBTTagCompound();
                stack.func_77955_b(CompoundNBT);
                itemsTag.func_74742_a((NBTBase)CompoundNBT);
            }
            if (stack.func_190926_b()) continue;
            CompoundNBT = new NBTTagCompound();
            itemLocation.toTag(CompoundNBT);
            itemLocationsTag.func_74742_a((NBTBase)CompoundNBT);
        }
        tag.func_74782_a("Items", (NBTBase)itemsTag);
        tag.func_74782_a("ItemLocations", (NBTBase)itemLocationsTag);
        return tag;
    }

    private void loadInitialChunkData(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.itemsContained.clear();
        this.itemsLocations.clear();
        NBTTagList itemsTag = tag.func_150295_c("Items", 10);
        for (int i = 0; i < itemsTag.func_74745_c(); ++i) {
            NBTTagCompound CompoundNBT = itemsTag.func_150305_b(i);
            this.itemsContained.add((Object)new ItemStack(CompoundNBT));
        }
        NBTTagList itemLocationsTag = tag.func_150295_c("ItemLocations", 10);
        for (int i = 0; i < itemLocationsTag.func_74745_c(); ++i) {
            NBTTagCompound CompoundNBT = itemLocationsTag.func_150305_b(i);
            this.itemsLocations.add(ItemLocation.fromTag(CompoundNBT));
        }
    }

    public void addLootTable(World world) {
        this.setup = true;
    }

    public void func_73660_a() {
        if (this.setup) {
            this.setup = false;
            this.delay = 0;
            ArrayList drops = Lists.newArrayList(LootGenerator.generate(this.field_145850_b.field_73012_v));
            int size = MathHelper.func_76125_a((int)(this.field_145850_b.field_73012_v.nextInt(5) - (this.field_145850_b.field_73012_v.nextInt(1) + 1)), (int)0, (int)drops.size());
            if (drops.size() >= 1) {
                for (int i = 0; i < size; ++i) {
                    int index = this.field_145850_b.field_73012_v.nextInt(drops.size());
                    this.addItem(this.field_145850_b, (ItemStack)drops.get(index), null);
                    drops.remove(index);
                }
            }
        } else if (this.itemsContained.isEmpty()) {
            ++this.delay;
            if (this.delay > 20) {
                this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150432_aD.func_176223_P());
                this.func_145843_s();
            }
        } else {
            this.delay = 0;
        }
    }

    public EnumActionResult addItem(World world, ItemStack itemStack, EntityPlayer nullablePlayer) {
        return this.addItem(world, itemStack, nullablePlayer, true);
    }

    public EnumActionResult addItem(World world, ItemStack itemStack, EntityPlayer nullablePlayer, boolean actuallyDoIt) {
        Material material;
        if (itemStack.func_77973_b() instanceof ItemBlock && ((material = ((BlockAccessor)((ItemBlock)itemStack.func_77973_b()).func_179223_d()).getBlockMaterial()) == Material.field_151588_w || material == Material.field_151598_x)) {
            return EnumActionResult.PASS;
        }
        if (this.getItemsContained().size() < 8 && itemStack.func_190916_E() >= 1) {
            if (actuallyDoIt) {
                this.getItemsContained().add((Object)itemStack.func_77979_a(1));
                Random random = world.field_73012_v;
                if (random == null) {
                    random = RANDOM;
                }
                this.getItemsLocations().add(new ItemLocation(random.nextDouble() * 0.95 + 0.1, random.nextDouble() * 0.7 + 0.1, random.nextDouble() * 0.95 + 0.1));
                this.updateListeners();
            }
            if (nullablePlayer != null && world.field_72995_K) {
                nullablePlayer.func_184185_a(SoundEvents.field_187546_ae, 1.0f, 1.0f);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.SUCCESS;
    }

    private void updateListeners() {
        this.func_70296_d();
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.saveInitialChunkData(new NBTTagCompound());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.loadInitialChunkData(tag);
    }

    public void onDataPacket(NetworkManager manager, SPacketUpdateTileEntity packet) {
        this.handleUpdateTag(packet.func_148857_g());
    }
}

