/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.btfixes.mixin;

import atomicstryker.battletowers.common.AS_BattleTowersCore;
import atomicstryker.battletowers.common.AS_EntityGolem;
import atomicstryker.battletowers.common.AS_WorldGenTower;
import atomicstryker.battletowers.common.TowerStageItemManager;
import atomicstryker.battletowers.common.WorldGenHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import mod.acgaming.btfixes.AS_WorldGenTowerNew;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={AS_WorldGenTower.class})
public abstract class AS_WorldGenTowerMixin {
    @Shadow
    private static int candidatecount;
    @Shadow
    private static int[][] candidates;
    @Shadow
    @Final
    private static int maxHoleDepthInBase;
    @Shadow
    public String failState;

    @Overwrite(remap=false)
    public int getChosenTowerOrdinal(World world, Random random, int ix, int jy, int kz) {
        int towerChosen;
        int countWater = 0;
        int countSand = 0;
        int countRedSand = 0;
        int countSnow = 0;
        int countFoliage = 0;
        int countElse = 0;
        for (int ccounter = 0; ccounter < candidatecount; ++ccounter) {
            int[] pair = candidates[ccounter];
            int checkBlockY = this.getSurfaceBlockHeight(world, ix + pair[0], kz + pair[1]);
            BlockPos blockPos = new BlockPos(ix + pair[0], checkBlockY, kz + pair[1]);
            Block ID = world.func_180495_p(blockPos).func_177230_c();
            Biome biome = world.func_180494_b(blockPos);
            Biome.TempCategory biomeTemp = biome.func_150561_m();
            if (world.func_180495_p(blockPos.func_177982_a(0, 1, 0)).func_177230_c() == Blocks.field_150433_aE || ID == Blocks.field_150432_aD || biome.func_150559_j()) {
                if (biomeTemp == Biome.TempCategory.COLD) {
                    ++countSnow;
                }
            } else if (ID == Blocks.field_150354_m || ID == Blocks.field_150322_A) {
                if (biomeTemp == Biome.TempCategory.WARM) {
                    ++countSand;
                }
            } else if (ID == Blocks.field_150354_m.func_176203_a(1).func_177230_c() || ID == Blocks.field_150405_ch || ID == Blocks.field_180395_cM) {
                if (biomeTemp == Biome.TempCategory.WARM) {
                    ++countRedSand;
                }
            } else if (ID == Blocks.field_150355_j) {
                if (biomeTemp == Biome.TempCategory.OCEAN) {
                    ++countWater;
                }
            } else if (ID == Blocks.field_150362_t || ID == Blocks.field_150392_bi || ID == Blocks.field_150364_r || ID == Blocks.field_150363_s) {
                ++countFoliage;
            } else {
                ++countElse;
            }
            if (Math.abs(checkBlockY - jy) > maxHoleDepthInBase) {
                this.failState = "Uneven Surface, diff value: " + Math.abs(checkBlockY - jy);
                return -1;
            }
            for (int ycounter2 = 1; ycounter2 <= 3; ++ycounter2) {
                ID = world.func_180495_p(new BlockPos(ix + pair[0], checkBlockY + ycounter2, kz + pair[1])).func_177230_c();
                if (!this.isBannedBlockID(ID)) continue;
                this.failState = "Surface banned Block of ID: " + ID + " at height: " + ycounter2;
                return -1;
            }
            for (int ycounter = 1; ycounter <= 5; ++ycounter) {
                ID = world.func_180495_p(new BlockPos(ix + pair[0], checkBlockY - ycounter, kz + pair[1])).func_177230_c();
                if (ID != Blocks.field_150350_a && !this.isBannedBlockID(ID)) continue;
                this.failState = "Depth check - Banned Block or hole, Depth: " + ycounter + " ID: " + ID;
                return -1;
            }
        }
        int[] nums = new int[]{countWater, countSnow, countSand, countRedSand, countFoliage, countElse};
        Arrays.sort(nums);
        int result = nums[nums.length - 1];
        if (AS_WorldGenTowerNew.themeList.contains("sand") && countSand == result) {
            towerChosen = AS_WorldGenTowerNew.getRandomTowerOrdinal("sand", random);
        } else if (AS_WorldGenTowerNew.themeList.contains("red_sand") && countRedSand == result) {
            towerChosen = AS_WorldGenTowerNew.getRandomTowerOrdinal("red_sand", random);
        } else if (AS_WorldGenTowerNew.themeList.contains("snow") && countSnow == result) {
            towerChosen = AS_WorldGenTowerNew.getRandomTowerOrdinal("snow", random);
        } else if (AS_WorldGenTowerNew.themeList.contains("water") && countWater == result) {
            towerChosen = AS_WorldGenTowerNew.getRandomTowerOrdinal("water", random);
        } else if (AS_WorldGenTowerNew.themeList.contains("foliage") && countFoliage == result) {
            towerChosen = AS_WorldGenTowerNew.getRandomTowerOrdinal("foliage", random);
        } else if (AS_WorldGenTowerNew.themeList.contains("rare") && random.nextInt(10) == 0) {
            towerChosen = AS_WorldGenTowerNew.getRandomTowerOrdinal("rare", random);
        } else if (AS_WorldGenTowerNew.themeList.contains("default")) {
            towerChosen = AS_WorldGenTowerNew.getRandomTowerOrdinal("default", random);
        } else {
            throw new IllegalArgumentException("[Battle Towers Fixes] No valid battle tower variants detected, check your configs!");
        }
        return towerChosen;
    }

    @Overwrite(remap=false)
    public void generate(World world, Random random, int ix, int jy, int kz, int towerchoice, boolean underground) {
        Block towerWallBlockID = AS_WorldGenTowerNew.wallBlockID.get(towerchoice);
        int towerWallMeta = AS_WorldGenTowerNew.wallBlockMetaData.get(towerchoice);
        Block towerLightBlockID = AS_WorldGenTowerNew.lightBlockID.get(towerchoice);
        int towerLightMeta = AS_WorldGenTowerNew.lightBlockMetaData.get(towerchoice);
        Block towerFloorBlockID = AS_WorldGenTowerNew.floorBlockID.get(towerchoice);
        int towerFloorMeta = AS_WorldGenTowerNew.floorBlockMetaData.get(towerchoice);
        Block towerStairBlockID = AS_WorldGenTowerNew.stairBlockID.get(towerchoice);
        int towerStairMeta = AS_WorldGenTowerNew.stairBlockMetaData.get(towerchoice);
        int startingHeight = underground ? Math.max(jy - 70, 15) : jy - 6;
        int maximumHeight = underground ? jy + 7 : 120;
        int floor = 1;
        boolean topFloor = false;
        for (int builderHeight = startingHeight; builderHeight < maximumHeight; builderHeight += 7) {
            if (builderHeight + 7 >= maximumHeight) {
                topFloor = true;
            }
            for (int floorIterator = 0; floorIterator < 7; ++floorIterator) {
                if (floor == 1 && floorIterator < 4) {
                    floorIterator = 4;
                }
                for (int xIterator = -7; xIterator < 7; ++xIterator) {
                    for (int zIterator = -7; zIterator < 7; ++zIterator) {
                        int iCurrent = xIterator + ix;
                        int jCurrent = floorIterator + builderHeight;
                        int zCurrent = zIterator + kz;
                        if (zIterator == -7) {
                            if (xIterator <= -5 || xIterator >= 4) continue;
                            this.buildWallPieceNew(world, iCurrent, jCurrent, zCurrent, towerWallBlockID, towerWallMeta, floor, floorIterator);
                            continue;
                        }
                        if (zIterator == -6 || zIterator == -5) {
                            if (xIterator == -5 || xIterator == 4) {
                                this.buildWallPieceNew(world, iCurrent, jCurrent, zCurrent, towerWallBlockID, towerWallMeta, floor, floorIterator);
                                continue;
                            }
                            if (zIterator == -6) {
                                if (xIterator == (floorIterator + 1) % 7 - 3) {
                                    if (!underground || floor != 1) {
                                        world.func_175656_a(new BlockPos(iCurrent, jCurrent, zCurrent), towerStairBlockID.func_176203_a(towerStairMeta));
                                    }
                                    if (floorIterator == 5) {
                                        world.func_175656_a(new BlockPos(iCurrent - 7, jCurrent, zCurrent), towerFloorBlockID.func_176203_a(towerFloorMeta));
                                    }
                                    if (floorIterator != 6 || !topFloor) continue;
                                    this.buildWallPieceNew(world, iCurrent, jCurrent, zCurrent, towerWallBlockID, towerWallMeta, floor, floorIterator);
                                    continue;
                                }
                                if (xIterator >= 4 || xIterator <= -5) continue;
                                world.func_175656_a(new BlockPos(iCurrent, jCurrent, zCurrent), Blocks.field_150350_a.func_176223_P());
                                continue;
                            }
                            if (xIterator <= -5 || xIterator >= 5) continue;
                            if (floorIterator != 0 && floorIterator != 6 || xIterator != -4 && xIterator != 3) {
                                if (floorIterator == 5 && (xIterator == 3 || xIterator == -4)) {
                                    this.buildFloorPiece(world, iCurrent, jCurrent, zCurrent, towerFloorBlockID, towerFloorMeta);
                                    continue;
                                }
                                this.buildWallPieceNew(world, iCurrent, jCurrent, zCurrent, towerWallBlockID, towerWallMeta, floor, floorIterator);
                                continue;
                            }
                            world.func_175656_a(new BlockPos(iCurrent, jCurrent, zCurrent), Blocks.field_150350_a.func_176223_P());
                            continue;
                        }
                        if (zIterator == -4 || zIterator == -3 || zIterator == 2 || zIterator == 3) {
                            if (xIterator == -6 || xIterator == 5) {
                                this.buildWallPieceNew(world, iCurrent, jCurrent, zCurrent, towerWallBlockID, towerWallMeta, floor, floorIterator);
                                continue;
                            }
                            if (xIterator <= -6 || xIterator >= 5) continue;
                            if (floorIterator == 5) {
                                this.buildFloorPiece(world, iCurrent, jCurrent, zCurrent, towerFloorBlockID, towerFloorMeta);
                                continue;
                            }
                            if (world.func_180495_p(new BlockPos(iCurrent, jCurrent, zCurrent)).func_177230_c() == Blocks.field_150486_ae) continue;
                            world.func_175656_a(new BlockPos(iCurrent, jCurrent, zCurrent), Blocks.field_150350_a.func_176223_P());
                            continue;
                        }
                        if (zIterator < 2) {
                            if (xIterator == -7 || xIterator == 6) {
                                if (floorIterator < 0 || floorIterator > 3 || underground || zIterator != -1 && zIterator != 0) {
                                    this.buildWallPieceNew(world, iCurrent, jCurrent, zCurrent, towerWallBlockID, towerWallMeta, floor, floorIterator);
                                    continue;
                                }
                                world.func_175656_a(new BlockPos(iCurrent, jCurrent, zCurrent), Blocks.field_150350_a.func_176223_P());
                                continue;
                            }
                            if (floorIterator == 5) {
                                this.buildFloorPiece(world, iCurrent, jCurrent, zCurrent, towerFloorBlockID, towerFloorMeta);
                                continue;
                            }
                            world.func_175656_a(new BlockPos(iCurrent, jCurrent, zCurrent), Blocks.field_150350_a.func_176223_P());
                            continue;
                        }
                        if (zIterator == 4) {
                            if (xIterator == -5 || xIterator == 4) {
                                this.buildWallPieceNew(world, iCurrent, jCurrent, zCurrent, towerWallBlockID, towerWallMeta, floor, floorIterator);
                                continue;
                            }
                            if (xIterator <= -5 || xIterator >= 4) continue;
                            if (floorIterator == 5) {
                                this.buildFloorPiece(world, iCurrent, jCurrent, zCurrent, towerFloorBlockID, towerFloorMeta);
                                continue;
                            }
                            world.func_175656_a(new BlockPos(iCurrent, jCurrent, zCurrent), Blocks.field_150350_a.func_176223_P());
                            continue;
                        }
                        if (zIterator == 5) {
                            if (xIterator == -4 || xIterator == -3 || xIterator == 2 || xIterator == 3) {
                                this.buildWallPieceNew(world, iCurrent, jCurrent, zCurrent, towerWallBlockID, towerWallMeta, floor, floorIterator);
                                continue;
                            }
                            if (xIterator <= -3 || xIterator >= 2) continue;
                            if (floorIterator == 5) {
                                this.buildFloorPiece(world, iCurrent, jCurrent, zCurrent, towerFloorBlockID, towerFloorMeta);
                                continue;
                            }
                            this.buildWallPieceNew(world, iCurrent, jCurrent, zCurrent, towerWallBlockID, towerWallMeta, floor, floorIterator);
                            continue;
                        }
                        if (xIterator <= -3 || xIterator >= 2) continue;
                        if (floorIterator < 0 || floorIterator > 3 || xIterator != -1 && xIterator != 0) {
                            this.buildWallPieceNew(world, iCurrent, jCurrent, zCurrent, towerWallBlockID, towerWallMeta, floor, floorIterator);
                            continue;
                        }
                        this.buildWallPieceNew(world, iCurrent, jCurrent, zCurrent, towerWallBlockID, towerWallMeta, floor, floorIterator);
                    }
                }
            }
            if (floor == 2) {
                world.func_175656_a(new BlockPos(ix + 3, builderHeight, kz - 5), towerWallBlockID.func_176203_a(towerWallMeta));
                world.func_175656_a(new BlockPos(ix + 3, builderHeight - 1, kz - 5), towerWallBlockID.func_176203_a(towerWallMeta));
            }
            if (!underground && topFloor || underground && floor == 1) {
                AS_EntityGolem entitygolem = new AS_EntityGolem(world, towerchoice);
                entitygolem.func_70012_b((double)ix + 0.5, (double)(builderHeight + 6), (double)kz + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entitygolem);
            } else {
                world.func_175656_a(new BlockPos(ix + 2, builderHeight + 6, kz + 2), Blocks.field_150474_ac.func_176223_P());
                TileEntityMobSpawner tileentitymobspawner = (TileEntityMobSpawner)world.func_175625_s(new BlockPos(ix + 2, builderHeight + 6, kz + 2));
                if (tileentitymobspawner != null) {
                    tileentitymobspawner.func_145881_a().func_190894_a(this.getMobType(world.field_73012_v));
                }
                world.func_175656_a(new BlockPos(ix - 3, builderHeight + 6, kz + 2), Blocks.field_150474_ac.func_176223_P());
                tileentitymobspawner = (TileEntityMobSpawner)world.func_175625_s(new BlockPos(ix - 3, builderHeight + 6, kz + 2));
                if (tileentitymobspawner != null) {
                    tileentitymobspawner.func_145881_a().func_190894_a(this.getMobType(world.field_73012_v));
                }
            }
            world.func_175656_a(new BlockPos(ix, builderHeight + 6, kz + 3), towerFloorBlockID.func_176203_a(towerFloorMeta));
            world.func_175656_a(new BlockPos(ix - 1, builderHeight + 6, kz + 3), towerFloorBlockID.func_176203_a(towerFloorMeta));
            if (builderHeight + 56 >= 120 && floor == 1) {
                floor = 2;
            }
            TowerStageItemManager floorChestManager = !underground ? (topFloor ? WorldGenHandler.getTowerStageManagerForFloor((int)10) : WorldGenHandler.getTowerStageManagerForFloor((int)floor)) : (floor == 1 ? WorldGenHandler.getTowerStageManagerForFloor((int)10) : WorldGenHandler.getTowerStageManagerForFloor((int)Math.abs(11 - floor)));
            for (int chestlength = 0; chestlength < 2; ++chestlength) {
                world.func_175656_a(new BlockPos(ix - chestlength, builderHeight + 7, kz + 3), Blocks.field_150486_ae.func_176203_a(2));
                TileEntityChest tileentitychest = (TileEntityChest)world.func_175625_s(new BlockPos(ix - chestlength, builderHeight + 7, kz + 3));
                if (tileentitychest == null) continue;
                int count = underground ? AS_BattleTowersCore.instance.itemGenerateAttemptsPerFloor * 2 : AS_BattleTowersCore.instance.itemGenerateAttemptsPerFloor;
                List generatedStacks = floorChestManager.getStageItemStacks(world, world.field_73012_v, tileentitychest, count);
                ArrayList<Integer> freeSlots = new ArrayList<Integer>(tileentitychest.func_70302_i_());
                for (int i = 0; i < tileentitychest.func_70302_i_(); ++i) {
                    freeSlots.add(i);
                }
                Iterator iterator = generatedStacks.iterator();
                while (iterator.hasNext() && !freeSlots.isEmpty()) {
                    Integer slot = (Integer)freeSlots.get(world.field_73012_v.nextInt(freeSlots.size()));
                    freeSlots.remove(slot);
                    tileentitychest.func_70299_a(slot.intValue(), (ItemStack)iterator.next());
                }
            }
            if (towerLightBlockID == Blocks.field_150478_aa) {
                world.func_180501_a(new BlockPos(ix + 3, builderHeight + 2, kz - 6), towerLightBlockID.func_176203_a(0).func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.SOUTH), 2);
                world.func_180501_a(new BlockPos(ix - 4, builderHeight + 2, kz - 6), towerLightBlockID.func_176203_a(0).func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.SOUTH), 2);
                world.func_180501_a(new BlockPos(ix + 1, builderHeight + 2, kz - 4), towerLightBlockID.func_176203_a(0).func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.SOUTH), 2);
                world.func_180501_a(new BlockPos(ix - 2, builderHeight + 2, kz - 4), towerLightBlockID.func_176203_a(0).func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.SOUTH), 2);
            } else {
                world.func_175656_a(new BlockPos(ix + 3, builderHeight + 2, kz - 6), towerLightBlockID.func_176203_a(towerLightMeta));
                world.func_175656_a(new BlockPos(ix - 4, builderHeight + 2, kz - 6), towerLightBlockID.func_176203_a(towerLightMeta));
                world.func_175656_a(new BlockPos(ix + 1, builderHeight + 2, kz - 4), towerLightBlockID.func_176203_a(towerLightMeta));
                world.func_175656_a(new BlockPos(ix - 2, builderHeight + 2, kz - 4), towerLightBlockID.func_176203_a(towerLightMeta));
            }
            for (int l3 = 0; l3 < floor * 4 + towerchoice - 8 && !topFloor; ++l3) {
                int k4 = 5 - world.field_73012_v.nextInt(12);
                int k5 = builderHeight + 5;
                int j6 = 5 - world.field_73012_v.nextInt(10);
                if (j6 < -2 && k4 < 4 && k4 > -5 && k4 != 1 && k4 != -2 || world.func_180495_p(new BlockPos(k4 += ix, k5, j6 += kz)).func_177230_c() != towerFloorBlockID || world.func_180495_p(new BlockPos(k4, k5 + 1, j6)).func_177230_c() == Blocks.field_150474_ac) continue;
                world.func_175656_a(new BlockPos(k4, k5, j6), Blocks.field_150350_a.func_176223_P());
            }
            ++floor;
        }
        System.out.println("Dimension " + world.field_73011_w.getDimension() + " Battle Tower spawned at [ " + ix + " | " + kz + " ], underground: " + underground);
    }

    @Shadow
    protected abstract boolean isBuildableBlockID(Block var1);

    @Unique
    protected void fillTowerBaseToGroundNew(World world, int i, int j, int k, Block blockID, int blockMeta) {
        for (int y = j - 1; y > 0 && !this.isBuildableBlockID(world.func_180495_p(new BlockPos(i, y, k)).func_177230_c()); --y) {
            world.func_175656_a(new BlockPos(i, y, k), blockID.func_176203_a(blockMeta));
        }
    }

    @Shadow
    protected abstract void buildFloorPiece(World var1, int var2, int var3, int var4, Block var5, int var6);

    @Shadow
    protected abstract ResourceLocation getMobType(Random var1);

    @Unique
    protected void buildWallPieceNew(World world, int i, int j, int k, Block towerWallBlockID, int towerWallMeta, int floor, int floorIterator) {
        world.func_175656_a(new BlockPos(i, j, k), towerWallBlockID.func_176203_a(towerWallMeta));
        if (floor == 1 && floorIterator == 4) {
            this.fillTowerBaseToGroundNew(world, i, j, k, towerWallBlockID, towerWallMeta);
        }
    }

    @Shadow
    protected abstract int getSurfaceBlockHeight(World var1, int var2, int var3);

    @Shadow
    protected abstract boolean isBannedBlockID(Block var1);
}

