/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.btfixes;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mod.acgaming.btfixes.BTFixes;
import mod.acgaming.btfixes.config.BTFixesConfig;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class AS_WorldGenTowerNew {
    public static List<String> themeList = new ArrayList<String>();
    public static List<Block> wallBlockID = new ArrayList<Block>();
    public static List<Integer> wallBlockMetaData = new ArrayList<Integer>();
    public static List<Block> lightBlockID = new ArrayList<Block>();
    public static List<Integer> lightBlockMetaData = new ArrayList<Integer>();
    public static List<Block> floorBlockID = new ArrayList<Block>();
    public static List<Integer> floorBlockMetaData = new ArrayList<Integer>();
    public static List<Block> stairBlockID = new ArrayList<Block>();
    public static List<Integer> stairBlockMetaData = new ArrayList<Integer>();

    public static void initTowerVariants() {
        themeList.clear();
        wallBlockID.clear();
        wallBlockMetaData.clear();
        lightBlockID.clear();
        lightBlockMetaData.clear();
        floorBlockID.clear();
        floorBlockMetaData.clear();
        stairBlockID.clear();
        stairBlockMetaData.clear();
        BTFixes.LOGGER.info("*** REGISTERING BATTLE TOWER VARIANTS ***");
        for (String variant : BTFixesConfig.towerVariants) {
            String[] variantsSplit = variant.split(";");
            if (!variantsSplit[0].matches("default|sand|red_sand|snow|water|foliage|rare")) {
                throw new IllegalArgumentException("[Battle Towers Fixes] Invalid theme name '" + variantsSplit[1] + "' detected, check your configs!");
            }
            BTFixes.LOGGER.info("Theme: " + variantsSplit[0]);
            themeList.add(variantsSplit[0]);
            BTFixes.LOGGER.info("Wall Block: " + AS_WorldGenTowerNew.getBlock(variantsSplit[1]));
            wallBlockID.add(AS_WorldGenTowerNew.getBlock(variantsSplit[1]));
            wallBlockMetaData.add(Integer.parseInt(variantsSplit[2]));
            BTFixes.LOGGER.info("Light Block: " + AS_WorldGenTowerNew.getBlock(variantsSplit[3]));
            lightBlockID.add(AS_WorldGenTowerNew.getBlock(variantsSplit[3]));
            lightBlockMetaData.add(Integer.parseInt(variantsSplit[4]));
            BTFixes.LOGGER.info("Floor Block: " + AS_WorldGenTowerNew.getBlock(variantsSplit[5]));
            floorBlockID.add(AS_WorldGenTowerNew.getBlock(variantsSplit[5]));
            floorBlockMetaData.add(Integer.parseInt(variantsSplit[6]));
            BTFixes.LOGGER.info("Stair Block: " + AS_WorldGenTowerNew.getBlock(variantsSplit[7]));
            stairBlockID.add(AS_WorldGenTowerNew.getBlock(variantsSplit[7]));
            stairBlockMetaData.add(Integer.parseInt(variantsSplit[8]));
            BTFixes.LOGGER.info("*****************************************");
        }
    }

    public static Block getBlock(String blockName) {
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName));
    }

    public static int getRandomTowerOrdinal(String theme, Random random) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < themeList.size(); ++i) {
            if (!themeList.get(i).equals(theme)) continue;
            indices.add(i);
        }
        int randomIndex = indices.size() > 1 ? ((Integer)indices.get(random.nextInt(indices.size()))).intValue() : ((Integer)indices.get(0)).intValue();
        return randomIndex;
    }
}

