/*
 * Decompiled with CFR 0.152.
 */
package sct.hexxitgear.core.ability;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sct.hexxitgear.core.ability.Ability;

public class AbilityLift
extends Ability {
    public static final double FRAC = Math.PI / 180;

    public AbilityLift() {
        super("Arcane Rising", "ability.hexxitgear.lift", 600, 2, 6);
    }

    @Override
    public void start(EntityPlayer player) {
        for (EntityLivingBase e : this.getHitEntities(player)) {
            if (e == player) continue;
            e.func_70024_g(0.0, 2.0, 0.0);
        }
    }

    protected List<EntityLivingBase> getHitEntities(EntityPlayer player) {
        ArrayList<EntityLivingBase> hits = new ArrayList<EntityLivingBase>();
        for (EntityLivingBase e : player.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(player.func_180425_c(), player.func_180425_c().func_177981_b(2)).func_72314_b(3.5, 1.0, 3.5))) {
            if (e == player || !this.isEntityInFront(e, player)) continue;
            hits.add(e);
        }
        return hits;
    }

    protected boolean isEntityInFront(EntityLivingBase entity, EntityPlayer player) {
        float precalc = player.field_70177_z % 360.0f;
        float a = 360.0f + (90.0f + (precalc < 0.0f ? precalc + 360.0f : precalc)) % 360.0f * -1.0f;
        double x = entity.field_70165_t - player.field_70165_t;
        double z = entity.field_70161_v - player.field_70161_v;
        x *= AbilityLift.getXMult(a, x, z);
        a = 0.0f;
        double angX = Math.acos(x / 3.5) / (Math.PI / 180);
        double angZ = Math.asin(z / 3.5) / (Math.PI / 180);
        boolean b1 = angX + 360.0 > (double)(a + 270.0f);
        boolean b2 = angX < (double)(a + 90.0f);
        boolean b3 = angZ + 360.0 > (double)(a + 270.0f);
        boolean b4 = angZ < (double)(a + 90.0f);
        return b1 && b2 && b3 && b4;
    }

    static double getXMult(double a, double x, double z) {
        if (a <= 90.0 || a >= 270.0) {
            return 1.0;
        }
        if (z < 0.0 && x > 0.0 && a >= 90.0 && a <= 135.0) {
            return 1.0;
        }
        return -1.0;
    }

    @Override
    public void end(EntityPlayer player) {
    }

    @Override
    public void tick(EntityPlayer player, int duration) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderFirst(EntityPlayer player) {
        player.field_70170_p.func_184134_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_191244_bn, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
        for (EntityLivingBase e : this.getHitEntities(player)) {
            for (int i = 0; i < 10; ++i) {
                player.field_70170_p.func_175688_a(EnumParticleTypes.DRAGON_BREATH, e.field_70165_t, e.field_70163_u, e.field_70161_v, 0.0, (double)(i + 1) * 0.1, 0.0, new int[0]);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderAt(EntityPlayer player, int duration) {
    }
}

