/*
 * Decompiled with CFR 0.152.
 */
package sct.hexxitgear.core;

import java.util.function.Supplier;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.StringUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IBuffEffect {
    public static final int REFRESH_QUERY_INTERVAL = 10;

    public void apply(EntityLivingBase var1);

    public void purge(EntityLivingBase var1);

    @SideOnly(value=Side.CLIENT)
    public String getDescription();

    public static class Absorption
    implements IBuffEffect {
        private final int amplifier;
        private final int refreshInterval;

        public Absorption(int amplifier, int refreshInterval) {
            this.amplifier = amplifier;
            this.refreshInterval = refreshInterval;
        }

        @Override
        public void apply(EntityLivingBase target) {
            PotionEffect activeEffect = target.func_70660_b(MobEffects.field_76444_x);
            if (activeEffect != null) {
                int activeAmplifier = activeEffect.func_76458_c();
                if (activeAmplifier > this.amplifier) {
                    if (target.func_110139_bj() > 4.0f * (float)(this.amplifier + 1)) {
                        return;
                    }
                    target.func_184589_d(MobEffects.field_76444_x);
                } else if (activeAmplifier == this.amplifier) {
                    return;
                }
            }
            target.func_70690_d(new PotionEffect(MobEffects.field_76444_x, this.refreshInterval, this.amplifier, false, false));
        }

        @Override
        public void purge(EntityLivingBase target) {
            PotionEffect activeEffect = target.func_70660_b(MobEffects.field_76444_x);
            if (activeEffect != null && activeEffect.func_76458_c() == this.amplifier && activeEffect.func_76459_b() <= this.refreshInterval) {
                target.func_184589_d(MobEffects.field_76444_x);
            }
        }

        @Override
        public String getDescription() {
            return String.format("%s %d (%s)", I18n.func_135052_a((String)MobEffects.field_76444_x.func_76393_a(), (Object[])new Object[0]), this.amplifier + 1, StringUtils.func_76337_a((int)this.refreshInterval));
        }
    }

    public static class Simple
    implements IBuffEffect {
        private static final int MAX_DURATION = 300;
        private static final int REFRESH_INTERVAL = 50;
        private final Supplier<Potion> potionTypeProvider;
        private final int amplifier;

        public Simple(Supplier<Potion> potionTypeProvider, int amplifier) {
            this.potionTypeProvider = potionTypeProvider;
            this.amplifier = amplifier;
        }

        @Override
        public void apply(EntityLivingBase target) {
            int activeAmplifier;
            Potion potionType = this.potionTypeProvider.get();
            PotionEffect activeEffect = target.func_70660_b(potionType);
            if (activeEffect != null && ((activeAmplifier = activeEffect.func_76458_c()) > this.amplifier || activeAmplifier == this.amplifier && 300 - activeEffect.func_76459_b() < 50)) {
                return;
            }
            target.func_70690_d(new PotionEffect(potionType, 300, this.amplifier, false, false));
        }

        @Override
        public void purge(EntityLivingBase target) {
            Potion potionType = this.potionTypeProvider.get();
            PotionEffect activeEffect = target.func_70660_b(potionType);
            if (activeEffect != null && activeEffect.func_76458_c() == this.amplifier && activeEffect.func_76459_b() <= 300) {
                target.func_184589_d(potionType);
            }
        }

        @Override
        public String getDescription() {
            return String.format("%s %d", I18n.func_135052_a((String)this.potionTypeProvider.get().func_76393_a(), (Object[])new Object[0]), this.amplifier + 1);
        }
    }
}

