/*
 * Decompiled with CFR 0.152.
 */
package sct.hexxitgear.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import sct.hexxitgear.HexIntegration;
import sct.hexxitgear.core.AbilityHandler;
import sct.hexxitgear.core.IBuffEffect;
import sct.hexxitgear.core.ability.Ability;
import sct.hexxitgear.core.ability.AbilityLift;
import sct.hexxitgear.core.ability.AbilityRampage;
import sct.hexxitgear.core.ability.AbilityShield;
import sct.hexxitgear.core.ability.AbilityStealth;
import sct.hexxitgear.item.ItemHexxitArmor;

public class ArmorSet {
    public static final Map<UUID, ArmorSet> CACHED_SETS = new HashMap<UUID, ArmorSet>();
    public static final List<ArmorSet> SETS = new ArrayList<ArmorSet>();
    public static final ArmorSet TRIBAL = new ArmorSet("tribal", ItemArmor.ArmorMaterial.DIAMOND, new IBuffEffect[]{new IBuffEffect.Simple(() -> MobEffects.field_76420_g, 0), new IBuffEffect.Simple(() -> MobEffects.field_76422_e, 1), new IBuffEffect.Simple(() -> MobEffects.field_76430_j, 2), new IBuffEffect.Simple(() -> MobEffects.field_76439_r, 0)}, new AbilityRampage());
    public static final ArmorSet THIEF = new ArmorSet("thief", ItemArmor.ArmorMaterial.DIAMOND, new IBuffEffect[]{new IBuffEffect.Simple(() -> MobEffects.field_76424_c, 2), new IBuffEffect.Simple(() -> HexIntegration.ELENAI_DODGE_NIMBLE, 0), new IBuffEffect.Simple(() -> MobEffects.field_188425_z, 1), new IBuffEffect.Simple(() -> MobEffects.field_76439_r, 0)}, new AbilityStealth());
    public static final ArmorSet SCALE = new ArmorSet("scale", ItemArmor.ArmorMaterial.DIAMOND, new IBuffEffect[]{new IBuffEffect.Absorption(1, 400), new IBuffEffect.Simple(() -> MobEffects.field_76420_g, 1), new IBuffEffect.Simple(() -> MobEffects.field_76429_m, 0)}, new AbilityShield());
    public static final ArmorSet SAGE = new ArmorSet("sage", ItemArmor.ArmorMaterial.DIAMOND, new IBuffEffect[]{new IBuffEffect.Absorption(2, 500), new IBuffEffect.Simple(() -> MobEffects.field_76426_n, 0), new IBuffEffect.Simple(() -> MobEffects.field_76427_o, 0), new IBuffEffect.Simple(() -> MobEffects.field_76439_r, 0)}, new AbilityLift());
    private final String name;
    private final ItemArmor.ArmorMaterial material;
    private final IBuffEffect[] buffs;
    private final Ability ability;

    public ArmorSet(String name, ItemArmor.ArmorMaterial material, IBuffEffect[] buffs, Ability ability) {
        this.name = name;
        this.material = material;
        this.buffs = buffs;
        this.ability = ability;
        SETS.add(this);
    }

    public String getName() {
        return this.name;
    }

    public ItemArmor.ArmorMaterial getMaterial() {
        return this.material;
    }

    public Ability getAbility() {
        return this.ability;
    }

    public void applyBuffs(EntityPlayer player) {
        if (player.field_70170_p.func_82737_E() % 10L != 0L) {
            return;
        }
        for (IBuffEffect buff : this.buffs) {
            buff.apply((EntityLivingBase)player);
        }
    }

    public void removeBuffs(EntityPlayer player) {
        for (IBuffEffect buff : this.buffs) {
            buff.purge((EntityLivingBase)player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addTooltip(List<String> tooltip) {
        tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)("gui.hexxitgear.set." + this.name), (Object[])new Object[0]));
        tooltip.add("");
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(TextFormatting.GRAY + TextFormatting.ITALIC.toString() + I18n.func_135052_a((String)"gui.hexxitgear.set.more_info", (Object[])new Object[0]));
            return;
        }
        tooltip.add(TextFormatting.AQUA + I18n.func_135052_a((String)"gui.hexxitgear.set.set_bonus", (Object[])new Object[0]));
        for (IBuffEffect buff : this.buffs) {
            tooltip.add(String.format(TextFormatting.GRAY + "+ " + TextFormatting.WHITE + "%s", buff.getDescription()));
        }
        tooltip.add("");
        StringBuilder abilityName = new StringBuilder().append(TextFormatting.AQUA).append(I18n.func_135052_a((String)"gui.hexxitgear.set.set_ability", (Object[])new Object[0])).append(": ").append(TextFormatting.WHITE).append(I18n.func_135052_a((String)this.ability.getUnlocalizedName(), (Object[])new Object[0]));
        if (this.ability.getHungerCost() > 0) {
            if (this.ability.getXpCost() > 0) {
                abilityName.append(TextFormatting.GRAY).append(" (").append(TextFormatting.YELLOW).append(this.ability.getHungerCost()).append(TextFormatting.GRAY).append('+').append(TextFormatting.GREEN).append(this.ability.getXpCost()).append(TextFormatting.GRAY).append(')');
            } else {
                abilityName.append(TextFormatting.GRAY).append(" (").append(TextFormatting.YELLOW).append(this.ability.getHungerCost()).append(TextFormatting.GRAY).append(')');
            }
        } else if (this.ability.getXpCost() > 0) {
            abilityName.append(TextFormatting.GRAY).append(" (").append(TextFormatting.GREEN).append(this.ability.getXpCost()).append(TextFormatting.GRAY).append(')');
        }
        tooltip.add(abilityName.toString());
        for (String line : I18n.func_135052_a((String)(this.ability.getUnlocalizedName() + ".desc"), (Object[])new Object[0]).split(Pattern.quote("\\n"))) {
            tooltip.add("  " + TextFormatting.GRAY + line);
        }
        if (this.ability.getDuration() > 1) {
            tooltip.add(String.format(TextFormatting.GREEN + "%s: " + TextFormatting.WHITE + "%s", I18n.func_135052_a((String)"gui.hexxitgear.set.set_ability_duration", (Object[])new Object[0]), StringUtils.func_76337_a((int)this.ability.getDuration())));
        }
        tooltip.add(String.format(TextFormatting.GREEN + "%s: " + TextFormatting.WHITE + "%s", I18n.func_135052_a((String)"gui.hexxitgear.set.set_ability_cooldown", (Object[])new Object[0]), StringUtils.func_76337_a((int)this.ability.getCooldown())));
    }

    @Nullable
    public static ArmorSet getCurrentArmorSet(EntityPlayer player) {
        ItemStack stack = player.func_184582_a(EntityEquipmentSlot.HEAD);
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemHexxitArmor)) {
            return null;
        }
        ArmorSet set = ((ItemHexxitArmor)stack.func_77973_b()).getSet();
        if (ArmorSet.isArmorSlotWrong(player, EntityEquipmentSlot.CHEST, set) || ArmorSet.isArmorSlotWrong(player, EntityEquipmentSlot.LEGS, set) || ArmorSet.isArmorSlotWrong(player, EntityEquipmentSlot.FEET, set)) {
            return null;
        }
        return set;
    }

    private static boolean isArmorSlotWrong(EntityPlayer player, EntityEquipmentSlot slot, ArmorSet set) {
        ItemStack stack = player.func_184582_a(slot);
        return stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemHexxitArmor) || ((ItemHexxitArmor)stack.func_77973_b()).getSet() != set;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent e) {
        if (e.phase != TickEvent.Phase.END || e.player.field_70170_p.field_72995_K) {
            return;
        }
        AbilityHandler abilityHandler = AbilityHandler.getActiveAbility(e.player);
        ArmorSet s = CACHED_SETS.get(e.player.func_110124_au());
        if (s == null) {
            if (abilityHandler != null) {
                abilityHandler.setEnded(e.player);
            }
        } else if (ArmorSet.getCurrentArmorSet(e.player) != s) {
            s.removeBuffs(e.player);
            CACHED_SETS.put(e.player.func_110124_au(), null);
            if (abilityHandler != null) {
                abilityHandler.setEnded(e.player);
            }
        } else if (abilityHandler != null) {
            abilityHandler.onTick(e.player);
        }
    }

    public static void classloadForConfigs() {
    }
}

