/*
 * Decompiled with CFR 0.152.
 */
package sct.hexxitgear.core;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sct.hexxitgear.core.ArmorSet;
import sct.hexxitgear.core.ability.Ability;
import sct.hexxitgear.net.AbilityRenderMessage;
import sct.hexxitgear.net.ActionTextMessage;
import sct.hexxitgear.net.HexNetwork;

public class AbilityHandler {
    private int activeTime;
    private int cooldownTime;
    private Ability ability;
    private boolean ended = false;
    private boolean started = false;
    public static final Map<UUID, AbilityHandler> ACTIVE_HANDLERS = new HashMap<UUID, AbilityHandler>();

    private AbilityHandler(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            throw new IllegalArgumentException("Ability handler has been constructed on a client world, please report this!");
        }
        this.ability = ArmorSet.getCurrentArmorSet(player).getAbility();
        this.activeTime = this.ability.getDuration();
        this.cooldownTime = this.ability.getCooldown();
    }

    public static AbilityHandler getActiveAbility(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return null;
        }
        return ACTIVE_HANDLERS.get(player.func_110124_au());
    }

    public static void activateAbility(EntityPlayer player) {
        AbilityHandler handler = ACTIVE_HANDLERS.get(player.func_110124_au());
        if (handler != null) {
            HexNetwork.INSTANCE.sendTo((IMessage)new ActionTextMessage(0, handler.ability.getId(), handler.cooldownTime), (EntityPlayerMP)player);
            return;
        }
        handler = new AbilityHandler(player);
        if (!player.field_71075_bZ.field_75098_d && player.field_71068_ca < handler.ability.getXpCost()) {
            HexNetwork.INSTANCE.sendTo((IMessage)new ActionTextMessage(4, handler.ability.getId(), handler.ability.getXpCost() - player.field_71068_ca), (EntityPlayerMP)player);
            return;
        }
        int food = player.func_71024_bL().func_75116_a();
        if (!player.field_71075_bZ.field_75098_d && food < handler.ability.getHungerCost()) {
            HexNetwork.INSTANCE.sendTo((IMessage)new ActionTextMessage(5, handler.ability.getId(), handler.ability.getHungerCost() - food), (EntityPlayerMP)player);
            return;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            player.func_82242_a(-handler.ability.getXpCost());
            player.func_71024_bL().func_75114_a(food - handler.ability.getHungerCost());
        }
        ACTIVE_HANDLERS.put(player.func_110124_au(), handler);
    }

    public void onTick(EntityPlayer player) {
        if (this.activeTime > 0) {
            if (this.ability != null) {
                if (this.ability.getDuration() == this.activeTime || this.ability.isInstant()) {
                    HexNetwork.INSTANCE.sendTo((IMessage)new ActionTextMessage(1, this.ability.getId()), (EntityPlayerMP)player);
                }
                if (!this.started) {
                    this.ability.start(player);
                    HexNetwork.INSTANCE.sendToAllAround((IMessage)new AbilityRenderMessage(0, this.ability.getId(), player, 0), new NetworkRegistry.TargetPoint(player.field_70170_p.field_73011_w.getDimension(), player.field_70165_t, player.field_70163_u, player.field_70161_v, 50.0));
                    this.started = true;
                } else {
                    this.ability.tick(player, this.activeTime);
                    HexNetwork.INSTANCE.sendToAllAround((IMessage)new AbilityRenderMessage(1, this.ability.getId(), player, this.activeTime), new NetworkRegistry.TargetPoint(player.field_70170_p.field_73011_w.getDimension(), player.field_70165_t, player.field_70163_u, player.field_70161_v, 50.0));
                }
                if (this.ability.isInstant()) {
                    this.activeTime = 0;
                }
            }
            --this.activeTime;
        } else if (this.cooldownTime > 0) {
            if (this.ability != null && !this.ended) {
                this.setEnded(player);
            }
            --this.cooldownTime;
        } else {
            HexNetwork.INSTANCE.sendTo((IMessage)new ActionTextMessage(3, this.ability.getId()), (EntityPlayerMP)player);
            this.ability = null;
            ACTIVE_HANDLERS.remove(player.func_110124_au());
        }
    }

    public void setEnded(EntityPlayer player) {
        this.ability.end(player);
        this.ended = true;
        this.activeTime = 0;
        if (this.ability.getDuration() >= 100) {
            HexNetwork.INSTANCE.sendTo((IMessage)new ActionTextMessage(2, this.ability.getId()), (EntityPlayerMP)player);
        }
    }

    public void clearCooldown() {
        this.cooldownTime = 0;
    }
}

