/*
 * Decompiled with CFR 0.152.
 */
package yalter.mousetweaks;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import moze_intel.projecte.gameObjs.gui.GUICondenser;
import moze_intel.projecte.gameObjs.gui.GUICondenserMK2;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import yalter.mousetweaks.Main;
import yalter.mousetweaks.util.MTLog;

@Mod(modid="mousetweaks", version="3.1.2", useMetadata=true, clientSideOnly=true, acceptedMinecraftVersions="[1.12.2]")
public class MouseTweaks {
    @Mod.Instance
    public static MouseTweaks instance;
    private final Set<Class<? extends GuiScreen>> mouseTweaksBlacklist = new ObjectOpenHashSet();
    private final Set<Class<? extends GuiScreen>> wheelTweaksBlacklist = new ObjectOpenHashSet();

    public void addMouseTweakBlacklist(Class<? extends GuiScreen> clazz) {
        this.mouseTweaksBlacklist.add(clazz);
    }

    public void addWheelTweaksBlacklist(Class<? extends GuiScreen> clazz) {
        this.wheelTweaksBlacklist.add(clazz);
    }

    public boolean isMouseTweakDisabled(Class<? extends GuiScreen> clazz) {
        return this.mouseTweaksBlacklist.contains(clazz);
    }

    public boolean isWheelTweakDisabled(Class<? extends GuiScreen> clazz) {
        return this.wheelTweaksBlacklist.contains(clazz);
    }

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        MTLog.init(event.getModLog());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (event.getSide() != Side.CLIENT) {
            MTLog.logger.info("MouseTweaks disabled because we are not running on the client");
            return;
        }
        if (Loader.isModLoaded((String)"projecte")) {
            this.mouseTweaksBlacklist.add(GUICondenser.class);
            this.wheelTweaksBlacklist.add(GUICondenser.class);
            this.mouseTweaksBlacklist.add(GUICondenserMK2.class);
            this.wheelTweaksBlacklist.add(GUICondenserMK2.class);
        }
        Main.initialize();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Main.onUpdateInGame();
        }
    }

    @SubscribeEvent
    public void onGuiMouseInput(GuiScreenEvent.MouseInputEvent.Post event) {
        if (event.getGui() instanceof GuiContainer) {
            Main.onMouseInput();
        }
    }
}

