/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.common.tiles;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumSkyBlock;
import net.xalcon.torchmaster.common.ModBlocks;
import net.xalcon.torchmaster.common.TorchmasterConfig;

public class TileEntityFeralFlareLantern
extends TileEntity
implements ITickable {
    private int ticks;
    private boolean useLineOfSight;
    private List<BlockPos> childLights = new ArrayList<BlockPos>();

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, this.func_189515_b(new NBTTagCompound()));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(super.func_189517_E_());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        ArrayList<Integer> childLightsEncoded = new ArrayList<Integer>(this.childLights.size());
        for (BlockPos child : this.childLights) {
            childLightsEncoded.add(TileEntityFeralFlareLantern.encodePosition(this.field_174879_c, child));
        }
        nbt.func_74782_a("lights", (NBTBase)new NBTTagIntArray(childLightsEncoded));
        nbt.func_74768_a("ticks", this.ticks);
        nbt.func_74757_a("useLoS", this.useLineOfSight);
        return super.func_189515_b(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        this.childLights.clear();
        if (nbt.func_150299_b("lights") == 11) {
            int[] lightsEncoded;
            BlockPos origin = new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
            for (int encodedLight : lightsEncoded = ((NBTTagIntArray)nbt.func_74781_a("lights")).func_150302_c()) {
                this.childLights.add(TileEntityFeralFlareLantern.decodePosition(origin, encodedLight));
            }
        }
        this.ticks = nbt.func_74762_e("ticks");
        this.useLineOfSight = nbt.func_74767_n("useLoS");
        super.func_145839_a(nbt);
    }

    public void func_73660_a() {
        BlockPos targetPos;
        if (this.field_145850_b.field_72995_K || ++this.ticks % TorchmasterConfig.feralFlareTickRate != 0) {
            return;
        }
        if (this.ticks > 1000000) {
            this.ticks = 0;
        }
        if (this.childLights.size() > TorchmasterConfig.FeralFlareLanternLightCountHardcap) {
            return;
        }
        int radius = TorchmasterConfig.feralFlareRadius;
        int diameter = radius * 2;
        int x = radius - this.field_145850_b.field_73012_v.nextInt(diameter) + this.field_174879_c.func_177958_n();
        int y = radius - this.field_145850_b.field_73012_v.nextInt(diameter) + this.field_174879_c.func_177956_o();
        int z = radius - this.field_145850_b.field_73012_v.nextInt(diameter) + this.field_174879_c.func_177952_p();
        if (y < 3) {
            y = 3;
        }
        if (!this.field_145850_b.func_175667_e(targetPos = new BlockPos(x, y, z))) {
            return;
        }
        BlockPos precipitationHeight = this.field_145850_b.func_175725_q(targetPos);
        if (targetPos.func_177956_o() > precipitationHeight.func_177956_o() + 4) {
            targetPos = precipitationHeight.func_177981_b(4);
        }
        int worldHeightCap = this.field_145850_b.func_72800_K();
        if (targetPos.func_177956_o() > worldHeightCap) {
            targetPos = new BlockPos(targetPos.func_177958_n(), worldHeightCap - 1, targetPos.func_177952_p());
        }
        if (this.field_145850_b.func_175623_d(targetPos) && this.field_145850_b.func_175642_b(EnumSkyBlock.BLOCK, targetPos) < TorchmasterConfig.feralFlareMinLightLevel) {
            Vec3d end;
            Vec3d start;
            RayTraceResult rtResult;
            if (this.useLineOfSight && (rtResult = this.field_145850_b.func_147447_a(start = new Vec3d((Vec3i)targetPos).func_72441_c(0.5, 0.5, 0.5), end = new Vec3d((Vec3i)this.field_174879_c).func_72441_c(0.5, 0.5, 0.5), true, true, false)) != null) {
                BlockPos hitPos = rtResult.func_178782_a();
                if (rtResult.field_72313_a == RayTraceResult.Type.BLOCK && (hitPos.func_177958_n() != this.field_174879_c.func_177958_n() || hitPos.func_177956_o() != this.field_174879_c.func_177956_o() || hitPos.func_177952_p() != this.field_174879_c.func_177952_p())) {
                    return;
                }
            }
            if (this.field_145850_b.func_180501_a(targetPos, ModBlocks.getInvisibleLight().func_176223_P(), 3)) {
                this.childLights.add(targetPos);
                this.func_70296_d();
            }
        }
    }

    public void removeChildLights() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (BlockPos pos : this.childLights) {
            if (this.field_145850_b.func_180495_p(pos).func_177230_c() != ModBlocks.getInvisibleLight()) continue;
            if (TorchmasterConfig.feralFlareLightDecayInstantly) {
                this.field_145850_b.func_175698_g(pos);
                continue;
            }
            this.field_145850_b.func_180501_a(pos, ModBlocks.getInvisibleLight().getDecayState(), 2);
        }
        this.childLights.clear();
    }

    private static int encodePosition(BlockPos origin, BlockPos target) {
        int x = target.func_177958_n() - origin.func_177958_n();
        int y = target.func_177956_o() - origin.func_177956_o();
        int z = target.func_177952_p() - origin.func_177952_p();
        return ((x & 0xFF) << 16) + ((y & 0xFF) << 8) + (z & 0xFF);
    }

    private static BlockPos decodePosition(BlockPos origin, int pos) {
        byte x = (byte)(pos >> 16 & 0xFF);
        byte y = (byte)(pos >> 8 & 0xFF);
        byte z = (byte)(pos & 0xFF);
        return origin.func_177982_a((int)x, (int)y, (int)z);
    }

    public void setUseLineOfSight(boolean state) {
        this.useLineOfSight = state;
        this.func_70296_d();
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, blockState, blockState, 0);
    }

    public boolean shouldUseLineOfSight() {
        return this.useLineOfSight;
    }
}

