/*
 * Decompiled with CFR 0.152.
 */
package jackyy.exchangers.handler;

import jackyy.exchangers.client.gui.ExchangersGuiScreen;
import jackyy.exchangers.client.keybind.Keys;
import jackyy.exchangers.handler.ExchangerHandler;
import jackyy.exchangers.handler.network.NetworkHandler;
import jackyy.exchangers.handler.network.packet.PacketSwitchMode;
import jackyy.exchangers.handler.network.packet.PacketSwitchRange;
import jackyy.exchangers.handler.network.packet.PacketToggleDirectionalPlacement;
import jackyy.exchangers.handler.network.packet.PacketToggleForceDropItems;
import jackyy.exchangers.handler.network.packet.PacketToggleFuzzyPlacement;
import jackyy.exchangers.item.ItemExchangerBase;
import jackyy.exchangers.item.special.ItemCreativeExchanger;
import jackyy.gunpowderlib.helper.NBTHelper;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientEventsHandler {
    private static Minecraft mc = Minecraft.func_71410_x();

    @SubscribeEvent
    public void onGameOverlayRender(RenderGameOverlayEvent event) {
        if (event.isCancelable() || event.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE || !(mc.func_175606_aa() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)mc.func_175606_aa();
        if (player == null || !ClientEventsHandler.mc.field_71415_G || !Minecraft.func_71382_s() || player.func_184614_ca().func_190926_b() || !(player.func_184614_ca().func_77973_b() instanceof ItemExchangerBase)) {
            return;
        }
        ItemStack stack = player.func_184614_ca();
        if (NBTHelper.hasTag((ItemStack)stack)) {
            ScaledResolution scaledresolution = new ScaledResolution(mc);
            int w = scaledresolution.func_78326_a();
            int h = scaledresolution.func_78328_b();
            GlStateManager.func_179094_E();
            GlStateManager.func_179097_i();
            GlStateManager.func_179101_C();
            String exchangeRange = ExchangerHandler.rangeList[NBTHelper.getTag((ItemStack)stack).func_74762_e("range")];
            double scale = exchangeRange.length() > 2 ? 1.0 : 1.0;
            double swidth = (double)ClientEventsHandler.mc.field_71466_p.func_78256_a(exchangeRange) * scale;
            GlStateManager.func_179137_b((double)((double)(w / 2 - 2) - swidth), (double)(h / 2 - 4), (double)0.0);
            GlStateManager.func_179139_a((double)scale, (double)scale, (double)1.0);
            ClientEventsHandler.mc.field_71466_p.func_175063_a(exchangeRange, 0.0f, 0.0f, 0xFFFFFF);
            GlStateManager.func_179091_B();
            GlStateManager.func_179121_F();
            GlStateManager.func_179126_j();
        }
    }

    @SubscribeEvent
    public void renderWorldLastEvent(RenderWorldLastEvent event) {
        IBlockState state;
        Block block;
        RayTraceResult mouseOver = ClientEventsHandler.mc.field_71476_x;
        EntityPlayerSP player = ClientEventsHandler.mc.field_71439_g;
        World world = player.func_130014_f_();
        if (mouseOver != null && mouseOver.field_178784_b != null && !(block = (state = world.func_180495_p(mouseOver.func_178782_a())).func_177230_c()).isAir(state, (IBlockAccess)world, mouseOver.func_178782_a())) {
            ItemStack stack = player.func_184614_ca();
            float partialTicks = event.getPartialTicks();
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemExchangerBase && stack.func_77978_p() != null && mouseOver.field_178784_b != null) {
                Set<BlockPos> coordinates = ExchangerHandler.findSuitableBlocks(stack, player.func_130014_f_(), (EntityPlayer)player, mouseOver.field_178784_b, mouseOver.func_178782_a(), state);
                double offsetX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
                double offsetY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks;
                double offsetZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder buffer = tessellator.func_178180_c();
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_187441_d((float)4.0f);
                GlStateManager.func_179090_x();
                GlStateManager.func_179097_i();
                for (BlockPos coordinate : coordinates) {
                    IBlockState exState = NBTUtil.func_190008_d((NBTTagCompound)NBTHelper.getTag((ItemStack)stack).func_74775_l("blockstate"));
                    float blockHardness = block.func_176195_g(state, world, coordinate);
                    if (world.func_175623_d(coordinate) || exState == state) continue;
                    double renderX = (double)coordinate.func_177958_n() - offsetX;
                    double renderY = (double)coordinate.func_177956_o() - offsetY;
                    double renderZ = (double)coordinate.func_177952_p() - offsetZ;
                    AxisAlignedBB boundingBox = new AxisAlignedBB(renderX, renderY, renderZ, renderX + 1.0, renderY + 1.0, renderZ + 1.0).func_72321_a(0.001, 0.001, 0.001);
                    float r = 1.0f;
                    float g = 1.0f;
                    float b = 1.0f;
                    float a = 1.0f;
                    if (player.func_70093_af() && (world.func_175625_s(coordinate) != null && !ExchangerHandler.isWhitelisted(world, coordinate) || ExchangerHandler.isBlacklisted(world, coordinate) || !(stack.func_77973_b() instanceof ItemCreativeExchanger) && blockHardness < -0.1f)) {
                        r = 1.0f;
                        g = 0.1f;
                        b = 0.1f;
                        a = 1.0f;
                    } else if (player.func_70093_af()) {
                        r = 0.1f;
                        g = 1.0f;
                        b = 0.1f;
                        a = 1.0f;
                    }
                    buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
                    buffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181666_a(r, g, b, a).func_181675_d();
                    buffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181666_a(r, g, b, a).func_181675_d();
                    buffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181666_a(r, g, b, a).func_181675_d();
                    buffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181666_a(r, g, b, a).func_181675_d();
                    buffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181666_a(r, g, b, a).func_181675_d();
                    tessellator.func_78381_a();
                    buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
                    buffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181666_a(r, g, b, a).func_181675_d();
                    buffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181666_a(r, g, b, a).func_181675_d();
                    buffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181666_a(r, g, b, a).func_181675_d();
                    buffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181666_a(r, g, b, a).func_181675_d();
                    buffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181666_a(r, g, b, a).func_181675_d();
                    tessellator.func_78381_a();
                    buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
                    buffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181666_a(r, g, b, a).func_181675_d();
                    buffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181666_a(r, g, b, a).func_181675_d();
                    buffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181666_a(r, g, b, a).func_181675_d();
                    buffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181666_a(r, g, b, a).func_181675_d();
                    buffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181666_a(r, g, b, a).func_181675_d();
                    buffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181666_a(r, g, b, a).func_181675_d();
                    buffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181666_a(r, g, b, a).func_181675_d();
                    buffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181666_a(r, g, b, a).func_181675_d();
                    tessellator.func_78381_a();
                }
                GlStateManager.func_179084_k();
                GlStateManager.func_179098_w();
                GlStateManager.func_179126_j();
            }
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        EntityPlayerSP player = FMLClientHandler.instance().getClient().field_71439_g;
        ItemStack heldItem = player.func_184614_ca();
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ItemExchangerBase) {
            if (Keys.OPEN_GUI_KEY.func_151468_f()) {
                mc.func_147108_a((GuiScreen)new ExchangersGuiScreen());
            } else if (Keys.RANGE_SWITCH_KEY.func_151468_f()) {
                NetworkHandler.INSTANCE.sendToServer((IMessage)new PacketSwitchRange());
            } else if (Keys.MODE_SWITCH_KEY.func_151468_f()) {
                NetworkHandler.INSTANCE.sendToServer((IMessage)new PacketSwitchMode());
            } else if (Keys.FORCE_DROP_ITEMS_KEY.func_151468_f()) {
                NetworkHandler.INSTANCE.sendToServer((IMessage)new PacketToggleForceDropItems());
            } else if (Keys.DIRECTIONAL_PLACEMENT_KEY.func_151468_f()) {
                NetworkHandler.INSTANCE.sendToServer((IMessage)new PacketToggleDirectionalPlacement());
            } else if (Keys.FUZZY_PLACEMENT_KEY.func_151468_f()) {
                NetworkHandler.INSTANCE.sendToServer((IMessage)new PacketToggleFuzzyPlacement());
            }
        }
    }
}

