/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.elenaidodge.network.message;

import com.elenai.elenaidodge.ElenaiDodge;
import com.elenai.elenaidodge.util.handler.ModParticleHandler;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class ParticleMessage
implements IMessage {
    private int patronLevel;
    private int posX;
    private int posY;
    private int posZ;
    private boolean enableParticles;
    private boolean messageValid;

    public ParticleMessage() {
        this.messageValid = false;
    }

    public ParticleMessage(int patronLevel, int posX, int posY, int posZ, boolean enableParticles) {
        this.patronLevel = patronLevel;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.enableParticles = enableParticles;
        this.messageValid = true;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.patronLevel = buf.readInt();
            this.posX = buf.readInt();
            this.posY = buf.readInt();
            this.posZ = buf.readInt();
            this.enableParticles = buf.readBoolean();
        }
        catch (IndexOutOfBoundsException ioe) {
            ElenaiDodge.LOG.error("Error occured whilst networking!", (Throwable)ioe);
            return;
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeInt(this.patronLevel);
        buf.writeInt(this.posX);
        buf.writeInt(this.posY);
        buf.writeInt(this.posZ);
        buf.writeBoolean(this.enableParticles);
    }

    public static class Handler
    implements IMessageHandler<ParticleMessage, IMessage> {
        public IMessage onMessage(ParticleMessage message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.CLIENT) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.processMessage(message, ctx));
            return null;
        }

        void processMessage(ParticleMessage message, MessageContext ctx) {
            ModParticleHandler particleHandler = new ModParticleHandler(message.patronLevel, message.posX, message.posY, message.posZ, message.enableParticles);
            particleHandler.generateParticles();
        }
    }
}

