/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.elenaidodge.network.message;

import com.elenai.elenaidodge.ElenaiDodge;
import com.elenai.elenaidodge.logic.DodgeLogic;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class HandleClientHudMessage
implements IMessage {
    private boolean messageValid;
    private boolean isCreative;
    private boolean isSpectator;
    private boolean enableCooldown;
    private int cooldownLength;

    public HandleClientHudMessage() {
        this.messageValid = false;
    }

    public HandleClientHudMessage(boolean isCreative, boolean isSpectator, boolean enableCooldown, int cooldownLength) {
        this.isCreative = isCreative;
        this.isSpectator = isSpectator;
        this.enableCooldown = enableCooldown;
        this.cooldownLength = cooldownLength;
        this.messageValid = true;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.isCreative = buf.readBoolean();
            this.isSpectator = buf.readBoolean();
            this.enableCooldown = buf.readBoolean();
            this.cooldownLength = buf.readInt();
        }
        catch (IndexOutOfBoundsException ioe) {
            ElenaiDodge.LOG.error("Error occured whilst networking!", (Throwable)ioe);
            return;
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeBoolean(this.isCreative);
        buf.writeBoolean(this.isSpectator);
        buf.writeBoolean(this.enableCooldown);
        buf.writeInt(this.cooldownLength);
    }

    public static class Handler
    implements IMessageHandler<HandleClientHudMessage, IMessage> {
        public IMessage onMessage(HandleClientHudMessage message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.CLIENT) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.processMessage(message, ctx));
            return null;
        }

        void processMessage(HandleClientHudMessage message, MessageContext ctx) {
            DodgeLogic dodgeLogic = new DodgeLogic();
            dodgeLogic.dashEffectsClient(message.isCreative, message.isSpectator, message.enableCooldown, message.cooldownLength);
        }
    }
}

