/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.elenaidodge.logic;

import com.elenai.elenaidodge.ModConfig;
import com.elenai.elenaidodge.client.gui.DodgeGui;
import com.elenai.elenaidodge.event.TickEvents;
import com.elenai.elenaidodge.modpacks.capability.airborne.AirborneProvider;
import com.elenai.elenaidodge.modpacks.capability.airborne.IAirborne;
import com.elenai.elenaidodge.modpacks.capability.cooldown.CooldownProvider;
import com.elenai.elenaidodge.modpacks.capability.cooldown.ICooldown;
import com.elenai.elenaidodge.modpacks.capability.invincibility.IInvincibility;
import com.elenai.elenaidodge.modpacks.capability.invincibility.InvincibilityProvider;
import com.elenai.elenaidodge.modpacks.capability.power.IPower;
import com.elenai.elenaidodge.modpacks.capability.power.PowerProvider;
import com.elenai.elenaidodge.modpacks.capability.toggle.IPlayerCanDodge;
import com.elenai.elenaidodge.modpacks.capability.toggle.PlayerCanDodgeProvider;
import com.elenai.elenaidodge.modpacks.potions.PotionInit;
import com.elenai.elenaidodge.network.PacketHandler;
import com.elenai.elenaidodge.network.message.HandleClientHudMessage;
import com.elenai.elenaidodge.network.message.ParticleMessage;
import com.elenai.elenaidodge.network.message.SetVelocityMessage;
import com.elenai.elenaidodge.util.handler.CheckGameStageHandler;
import com.elenai.elenaidodge.util.handler.PatronRewardHandler;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class DodgeLogic {
    EntityPlayerMP player;
    World world;
    String direction;
    double playerWeight = 0.0;
    boolean doneTiers = false;
    int tierCounter = 0;
    double tierPower = 0.0;
    int tierCooldown = 0;
    boolean overencumbered = false;

    public DodgeLogic(EntityPlayerMP player, boolean unlockHud, boolean enableSound, String direction) {
        this.player = player;
        this.direction = direction;
    }

    public DodgeLogic() {
    }

    public void handleDodgeLogic() {
        IPower powerCapability = (IPower)this.player.getCapability(PowerProvider.POWER_CAP, null);
        if (this.playerAirborneChecks() && this.playerFoodChecks() && this.playerConditionChecks() && this.playerCapabilityChecks() && this.sneakChecks() && this.weightChecks() && !this.player.func_184218_aH() && !this.player.func_70644_a(PotionInit.CANNOT_DODGE) && this.potionBlacklist()) {
            float yaw = this.player.field_70177_z;
            float pitch = 1.0f;
            double f = 0.0;
            f = !ModConfig.armorWeights.enabled ? ModConfig.common.balance.dodgePower + powerCapability.getPower() : this.tierPower + powerCapability.getPower();
            if (f < 0.0) {
                f = 0.0;
            }
            this.world = this.player.func_130014_f_();
            if (this.direction.contains("left")) {
                double motionX = (double)(MathHelper.func_76134_b((float)(yaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(pitch / 180.0f * (float)Math.PI))) * f;
                double motionZ = (double)(-MathHelper.func_76126_a((float)(yaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(pitch / 180.0f * (float)Math.PI))) * f;
                PacketHandler.instance.sendTo((IMessage)new SetVelocityMessage(motionX, ModConfig.common.balance.verticallity, -motionZ, ModConfig.common.balance.keepVelocity), this.player);
                this.dashEffectsServer();
            } else if (this.direction.contains("right")) {
                double motionX = (double)(MathHelper.func_76134_b((float)(yaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(pitch / 180.0f * (float)Math.PI))) * f;
                double motionZ = (double)(-MathHelper.func_76126_a((float)(yaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(pitch / 180.0f * (float)Math.PI))) * f;
                PacketHandler.instance.sendTo((IMessage)new SetVelocityMessage(-motionX, ModConfig.common.balance.verticallity, motionZ, ModConfig.common.balance.keepVelocity), this.player);
                this.dashEffectsServer();
            } else if (this.direction.contains("forward")) {
                double motionX = (double)(-MathHelper.func_76126_a((float)(yaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(pitch / 180.0f * (float)Math.PI))) * f;
                double motionZ = (double)(MathHelper.func_76134_b((float)(yaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(pitch / 180.0f * (float)Math.PI))) * f;
                PacketHandler.instance.sendTo((IMessage)new SetVelocityMessage(motionX, ModConfig.common.balance.verticallity, motionZ, ModConfig.common.balance.keepVelocity), this.player);
                this.dashEffectsServer();
            } else if (this.direction.contains("back")) {
                double motionX = (double)(-MathHelper.func_76126_a((float)(yaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(pitch / 180.0f * (float)Math.PI))) * f;
                double motionZ = (double)(MathHelper.func_76134_b((float)(yaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(pitch / 180.0f * (float)Math.PI))) * f;
                PacketHandler.instance.sendTo((IMessage)new SetVelocityMessage(-motionX, ModConfig.common.balance.verticallity, -motionZ, ModConfig.common.balance.keepVelocity), this.player);
                this.dashEffectsServer();
            }
        }
    }

    public void dashEffectsServer() {
        IInvincibility invincibilityCapability = (IInvincibility)this.player.getCapability(InvincibilityProvider.INVINCIBILITY_CAP, null);
        invincibilityCapability.set(ModConfig.common.balance.invincibilityTicks);
        ICooldown cooldownCapability = (ICooldown)this.player.getCapability(CooldownProvider.COOLDOWN_CAP, null);
        if (!ModConfig.armorWeights.enabled) {
            PacketHandler.instance.sendTo((IMessage)new HandleClientHudMessage(this.player.func_184812_l_(), this.player.func_175149_v(), ModConfig.common.cooldown.enableCooldown, ModConfig.common.cooldown.cooldownLength + cooldownCapability.getCooldown()), this.player);
        } else {
            PacketHandler.instance.sendTo((IMessage)new HandleClientHudMessage(this.player.func_184812_l_(), this.player.func_175149_v(), ModConfig.common.cooldown.enableCooldown, this.tierCooldown + cooldownCapability.getCooldown()), this.player);
        }
        int patronLevel = PatronRewardHandler.getTier((EntityPlayer)this.player);
        PacketHandler.instance.sendToAllTracking((IMessage)new ParticleMessage(patronLevel, this.player.func_180425_c().func_177958_n(), this.player.func_180425_c().func_177956_o(), this.player.func_180425_c().func_177952_p(), ModConfig.common.particles.displayParticles), (Entity)this.player);
        PacketHandler.instance.sendTo((IMessage)new ParticleMessage(patronLevel, this.player.func_180425_c().func_177958_n(), this.player.func_180425_c().func_177956_o(), this.player.func_180425_c().func_177952_p(), ModConfig.common.particles.displayParticles), this.player);
        this.world.func_184133_a((EntityPlayer)this.player, this.player.func_180425_c(), SoundEvents.field_187557_bK, SoundCategory.PLAYERS, 0.6f, 8.0f);
        if (!this.player.func_184812_l_() && !this.player.func_175149_v()) {
            this.player.func_71024_bL().func_75113_a((float)ModConfig.common.balance.exhaustion);
        }
    }

    public void dashEffectsClient(boolean isCreative, boolean isSpectator, boolean enableCooldown, int cooldownLength) {
        TickEvents.spamPreventer = 0;
        TickEvents.flag = false;
        TickEvents.enableCooldown = enableCooldown;
        TickEvents.cooldownLength = cooldownLength;
        Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundEvents.field_187557_bK, 0.6f, 8.0f);
        ModelPlayer mplayer = new ModelPlayer(1.0f, true);
        mplayer.field_78117_n = true;
        mplayer.field_78116_c.field_82906_o = 18.0f;
        if (!isCreative && !isSpectator && enableCooldown) {
            DodgeGui.len = 182;
            if (ModConfig.client.hud.unlockHUD) {
                DodgeGui.bg = 182;
            }
        }
    }

    private boolean weightChecks() {
        ArrayList weights = new ArrayList();
        Collections.addAll(weights, ModConfig.armorWeights.weights.split(","));
        weights.forEach(w -> {
            String[] itemValue = w.split("=");
            if (this.player.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == Item.func_111206_d((String)itemValue[0]) || this.player.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() == Item.func_111206_d((String)itemValue[0]) || this.player.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b() == Item.func_111206_d((String)itemValue[0]) || this.player.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() == Item.func_111206_d((String)itemValue[0]) || this.player.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() == Item.func_111206_d((String)itemValue[0]) || this.player.func_184582_a(EntityEquipmentSlot.OFFHAND).func_77973_b() == Item.func_111206_d((String)itemValue[0])) {
                this.playerWeight += Double.valueOf(itemValue[1]).doubleValue();
            }
        });
        ArrayList tiers = new ArrayList();
        Collections.addAll(tiers, ModConfig.armorWeights.tiers.split(","));
        String[] firstTierValue = ((String)tiers.get(0)).split("=");
        if (this.playerWeight < 0.0 && !this.doneTiers) {
            this.doneTiers = true;
            String[] values = firstTierValue[1].split("/");
            this.tierCooldown = Integer.valueOf(values[1]);
            this.tierPower = Double.parseDouble(values[0]);
        }
        Collections.reverse(tiers);
        tiers.forEach(t -> {
            String[] tierValue = t.split("=");
            if (this.playerWeight >= Double.valueOf(tierValue[0]) && !this.doneTiers && this.playerWeight >= 0.0) {
                this.doneTiers = true;
                String[] values = tierValue[1].split("/");
                this.tierCooldown = Integer.valueOf(values[1]);
                this.tierPower = Double.parseDouble(values[0]);
                if (this.tierCounter == 0) {
                    this.overencumbered = true;
                }
            }
            ++this.tierCounter;
        });
        if (ModConfig.armorWeights.enabled) {
            return !this.overencumbered;
        }
        return true;
    }

    private boolean sneakChecks() {
        if (!ModConfig.common.balance.disableWhilstSneaking) {
            return true;
        }
        return !this.player.func_70093_af() && !this.player.func_184585_cz();
    }

    private boolean playerFoodChecks() {
        return this.player.func_71024_bL().func_75116_a() > ModConfig.common.balance.hungerRequirement;
    }

    private boolean playerConditionChecks() {
        return this.hasGamestage() || this.hasPotion();
    }

    private boolean playerAirborneChecks() {
        return this.player.func_184812_l_() || this.player.func_175149_v() || this.player.field_70122_E || ModConfig.common.balance.allowDodgeWhileAirborne || this.hasAirborneGamestage() || this.hasAirborneCapability() || this.player.func_70644_a(PotionInit.CAN_DODGE_AIRBORNE);
    }

    private boolean playerCapabilityChecks() {
        IPlayerCanDodge canDodgeCapability;
        boolean gamestage = false;
        if (Loader.isModLoaded((String)"gamestages")) {
            gamestage = CheckGameStageHandler.checkDodgeEnabled((EntityPlayer)this.player);
        }
        return (canDodgeCapability = (IPlayerCanDodge)this.player.getCapability(PlayerCanDodgeProvider.PLAYER_CAN_DODGE_CAP, null)).getPlayerCanDodge() || this.player.func_70644_a(PotionInit.CAN_DODGE) || gamestage;
    }

    public boolean hasGamestage() {
        if (Loader.isModLoaded((String)"gamestages") && ModConfig.modpacks.dodgingRequiresGamestage) {
            return CheckGameStageHandler.checkDodgeEnabled((EntityPlayer)this.player);
        }
        return this.hasPotion();
    }

    public boolean hasAirborneGamestage() {
        if (Loader.isModLoaded((String)"gamestages") && ModConfig.modpacks.airborneRequiresGamestage) {
            return CheckGameStageHandler.checkAirborneEnabled((EntityPlayer)this.player);
        }
        return false;
    }

    public boolean hasAirborneCapability() {
        IAirborne airborneCapability = (IAirborne)this.player.getCapability(AirborneProvider.AIRBORNE_CAP, null);
        return airborneCapability.getAirborne();
    }

    public boolean potionBlacklist() {
        for (String i : ModConfig.modpacks.potions) {
            for (PotionEffect effect : this.player.func_70651_bq()) {
                if (!effect.func_188419_a().getRegistryName().equals((Object)new ResourceLocation(i))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean hasPotion() {
        if (ModConfig.modpacks.dodgingRequiresGamestage) {
            return this.player.func_70644_a(PotionInit.CAN_DODGE) || this.player.func_70644_a(PotionInit.CAN_DODGE_AIRBORNE);
        }
        return true;
    }
}

