/*
 * Decompiled with CFR 0.152.
 */
package com.elenai.elenaidodge;

import com.elenai.elenaidodge.ModConfig;
import com.elenai.elenaidodge.modpacks.capability.airborne.AirborneProvider;
import com.elenai.elenaidodge.modpacks.capability.airborne.IAirborne;
import com.elenai.elenaidodge.modpacks.capability.cooldown.CooldownProvider;
import com.elenai.elenaidodge.modpacks.capability.cooldown.ICooldown;
import com.elenai.elenaidodge.modpacks.capability.power.IPower;
import com.elenai.elenaidodge.modpacks.capability.power.PowerProvider;
import com.elenai.elenaidodge.modpacks.capability.toggle.IPlayerCanDodge;
import com.elenai.elenaidodge.modpacks.capability.toggle.PlayerCanDodgeProvider;
import com.elenai.elenaidodge.modpacks.potions.PotionInit;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;

public class ElenaiDodgeHelper {
    public static double getGlobalDodgePower() {
        return ModConfig.common.balance.dodgePower;
    }

    public static int getGlobalCooldown() {
        return ModConfig.common.cooldown.cooldownLength * 20;
    }

    public static Potion getDodgePotionEffect() {
        return PotionInit.CAN_DODGE;
    }

    public static double getPlayerDodgePower(EntityPlayer player) {
        IPower powerCapability = (IPower)player.getCapability(PowerProvider.POWER_CAP, null);
        return powerCapability.getPower() + ElenaiDodgeHelper.getGlobalDodgePower();
    }

    public static int getPlayerCooldownLength(EntityPlayer player) {
        ICooldown cooldownCapability = (ICooldown)player.getCapability(CooldownProvider.COOLDOWN_CAP, null);
        return cooldownCapability.getCooldown() + ElenaiDodgeHelper.getGlobalCooldown();
    }

    public static void increasePlayerDodgePower(EntityPlayer player, double power) {
        IPower powerCapability = (IPower)player.getCapability(PowerProvider.POWER_CAP, null);
        powerCapability.increase(power);
    }

    public static void increasePlayerCooldownLength(EntityPlayer player, int cooldown) {
        ICooldown cooldownCapability = (ICooldown)player.getCapability(CooldownProvider.COOLDOWN_CAP, null);
        cooldownCapability.increase(cooldown);
    }

    public static void decreasePlayerDodgePower(EntityPlayer player, double power) {
        IPower powerCapability = (IPower)player.getCapability(PowerProvider.POWER_CAP, null);
        powerCapability.decrease(power);
    }

    public static void decreasePlayerCooldownLength(EntityPlayer player, int cooldown) {
        ICooldown cooldownCapability = (ICooldown)player.getCapability(CooldownProvider.COOLDOWN_CAP, null);
        cooldownCapability.decrease(cooldown);
    }

    public static void setPlayerDodgePower(EntityPlayer player, double power) {
        IPower powerCapability = (IPower)player.getCapability(PowerProvider.POWER_CAP, null);
        powerCapability.set(power);
    }

    public static void setPlayerCooldownLength(EntityPlayer player, int cooldown) {
        ICooldown cooldownCapability = (ICooldown)player.getCapability(CooldownProvider.COOLDOWN_CAP, null);
        cooldownCapability.set(cooldown);
    }

    public static void enablePlayerDodge(EntityPlayer player) {
        IPlayerCanDodge canDodgeCapability = (IPlayerCanDodge)player.getCapability(PlayerCanDodgeProvider.PLAYER_CAN_DODGE_CAP, null);
        canDodgeCapability.set(true);
    }

    public static void enablePlayerDodgeAirborne(EntityPlayer player) {
        IAirborne airborneCapability = (IAirborne)player.getCapability(AirborneProvider.AIRBORNE_CAP, null);
        airborneCapability.set(true);
    }

    public static void disablePlayerDodge(EntityPlayer player) {
        IPlayerCanDodge canDodgeCapability = (IPlayerCanDodge)player.getCapability(PlayerCanDodgeProvider.PLAYER_CAN_DODGE_CAP, null);
        canDodgeCapability.set(false);
    }

    public static void disablePlayerDodgeAirborne(EntityPlayer player) {
        IAirborne airborneCapability = (IAirborne)player.getCapability(AirborneProvider.AIRBORNE_CAP, null);
        airborneCapability.set(false);
    }

    public static void togglePlayerDodge(EntityPlayer player) {
        IPlayerCanDodge canDodgeCapability = (IPlayerCanDodge)player.getCapability(PlayerCanDodgeProvider.PLAYER_CAN_DODGE_CAP, null);
        canDodgeCapability.toggle();
    }

    public static void togglePlayerDodgeAirborne(EntityPlayer player) {
        IAirborne airborneCapability = (IAirborne)player.getCapability(AirborneProvider.AIRBORNE_CAP, null);
        airborneCapability.toggle();
    }

    public static boolean getCanPlayerDodge(EntityPlayer player) {
        IPlayerCanDodge canDodgeCapability = (IPlayerCanDodge)player.getCapability(PlayerCanDodgeProvider.PLAYER_CAN_DODGE_CAP, null);
        return canDodgeCapability.getPlayerCanDodge();
    }

    public static boolean getCanPlayerDodgeAirborne(EntityPlayer player, boolean enabled) {
        IAirborne airborneCapability = (IAirborne)player.getCapability(AirborneProvider.AIRBORNE_CAP, null);
        return airborneCapability.getAirborne();
    }
}

