/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.authentication.flows.impl;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import technicianlp.reauth.authentication.MsAuthAPI;
import technicianlp.reauth.authentication.SessionData;
import technicianlp.reauth.authentication.dto.microsoft.MicrosoftAuthResponse;
import technicianlp.reauth.authentication.dto.xbox.XboxAuthResponse;
import technicianlp.reauth.authentication.flows.AuthorizationCodeFlow;
import technicianlp.reauth.authentication.flows.FlowCallback;
import technicianlp.reauth.authentication.flows.FlowStage;
import technicianlp.reauth.authentication.flows.Tokens;
import technicianlp.reauth.authentication.flows.impl.FlowBase;
import technicianlp.reauth.authentication.flows.impl.XboxAuthenticationFlow;
import technicianlp.reauth.authentication.http.server.AuthenticationCodeServer;
import technicianlp.reauth.configuration.Profile;
import technicianlp.reauth.configuration.ProfileBuilder;
import technicianlp.reauth.crypto.Crypto;
import technicianlp.reauth.crypto.PkceChallenge;
import technicianlp.reauth.crypto.ProfileEncryption;

public final class MicrosoftCodeFlow
extends FlowBase
implements AuthorizationCodeFlow {
    private final String loginUrl;
    private final CompletableFuture<SessionData> session;
    private final CompletableFuture<Profile> profile;
    private AuthenticationCodeServer codeServer;

    public MicrosoftCodeFlow(boolean persist, FlowCallback callback) {
        super(callback);
        PkceChallenge pkceChallenge = Crypto.createPkceChallenge();
        this.loginUrl = MsAuthAPI.getLoginUrl(persist, pkceChallenge.getChallenge());
        CompletableFuture codeStage = new CompletableFuture();
        CompletableFuture<String> pkceVerifier = CompletableFuture.completedFuture(pkceChallenge.getVerifier());
        CompletionStage ms = codeStage.thenCombineAsync(pkceVerifier, this.wrapStep(FlowStage.MS_REDEEM_AUTH_CODE, MsAuthAPI::redeemAuthorizationCode), this.executor);
        CompletionStage xasu = ((CompletableFuture)((CompletableFuture)ms).thenApply(MicrosoftAuthResponse::getAccessToken)).thenApplyAsync(this.wrapStep(FlowStage.MS_AUTH_XASU, MsAuthAPI::authenticateXASU), this.executor);
        XboxAuthenticationFlow flow = new XboxAuthenticationFlow((CompletableFuture<String>)((CompletableFuture)xasu).thenApply(XboxAuthResponse::getToken), callback);
        this.session = flow.getSession();
        this.session.whenComplete(this::onSessionComplete);
        this.registerDependantStages(new CompletableFuture[]{codeStage, ms, xasu, this.session});
        this.registerDependantFlow(flow);
        if (persist) {
            CompletionStage tokens = ((CompletableFuture)ms).thenCombine(xasu, Tokens::new);
            CompletableFuture<ProfileEncryption> encryption = CompletableFuture.supplyAsync(Crypto::newEncryption, this.executor);
            CompletionStage builder = this.session.thenCombine(encryption, ProfileBuilder::new);
            this.profile = ((CompletableFuture)builder).thenCombine(tokens, ProfileBuilder::buildMicrosoft);
            this.profile.whenComplete(this::onProfileComplete);
        } else {
            this.profile = null;
        }
        this.executor.execute(() -> {
            try {
                this.codeServer = new AuthenticationCodeServer(52371, this.loginUrl, codeStage, this.executor);
                this.step(FlowStage.MS_AWAIT_AUTH_CODE);
            }
            catch (IOException | NoClassDefFoundError exception) {
                codeStage.completeExceptionally(exception);
            }
        });
    }

    @Override
    public final CompletableFuture<SessionData> getSession() {
        return this.session;
    }

    @Override
    public boolean hasProfile() {
        return this.profile != null;
    }

    @Override
    public final CompletableFuture<Profile> getProfile() {
        if (this.profile != null) {
            return this.profile;
        }
        throw new IllegalStateException("Persistence not requested");
    }

    @Override
    public final String getLoginUrl() {
        return this.loginUrl;
    }

    @Override
    public final void cancel() {
        super.cancel();
        this.executor.execute(() -> this.codeServer.stop(true));
    }
}

