/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.thewall.wallparts;

import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.world.structure.generation.generation.GeneratableDungeon;
import team.cqr.cqrepoured.world.structure.generation.generation.part.BlockDungeonPart;
import team.cqr.cqrepoured.world.structure.generation.generation.part.IDungeonPartBuilder;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparableBlockInfo;
import team.cqr.cqrepoured.world.structure.generation.thewall.wallparts.IWallPart;

public class WallPartTower
implements IWallPart {
    @Override
    public int getTopY() {
        return CQRConfig.wall.topY;
    }

    @Override
    public void generateWall(int chunkX, int chunkZ, World world, Chunk chunk, GeneratableDungeon.Builder dungeonBuilder) {
        int startX = chunkX * 16 + 8;
        int startZ = chunkZ * 16;
        int startY = this.getBottomY(world, startX, startZ);
        if (this.getTopY() > startY) {
            BlockDungeonPart.Builder partBuilder = new BlockDungeonPart.Builder();
            IBlockState stateBrick = Blocks.field_150417_aV.func_176223_P();
            IBlockState stateObsidian = CQRConfig.wall.obsidianCore ? Blocks.field_150343_Z.func_176223_P() : stateBrick;
            IBlockState stateAndesite = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE_SMOOTH);
            int height = this.getTopY() - startY;
            for (BlockPos pos : BlockPos.func_191532_a((int)0, (int)0, (int)0, (int)15, (int)height, (int)15)) {
                int x = pos.func_177958_n();
                int y = pos.func_177956_o();
                int z = pos.func_177952_p();
                if (z >= 4 && z < 12 && (x <= 4 || x >= 12) && y <= height - 7) {
                    if (z >= 6 && z <= 9 && y < height - 7) {
                        partBuilder.add(new PreparableBlockInfo(pos, stateObsidian, null));
                    } else {
                        partBuilder.add(new PreparableBlockInfo(pos, stateBrick, null));
                    }
                }
                if (z >= 6 && z <= 9 && y <= height - 8 || x >= 6 && x <= 9 && z >= 2 && z <= 13 && y < height - 7) {
                    partBuilder.add(new PreparableBlockInfo(pos, stateObsidian, null));
                    continue;
                }
                if (x < 4 || x > 11) continue;
                partBuilder.add(new PreparableBlockInfo(pos, stateAndesite, null));
            }
            dungeonBuilder.add((IDungeonPartBuilder)partBuilder, dungeonBuilder.getPlacement(new BlockPos(startX, startY, startZ)));
        }
    }
}

