/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generators.volcano;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.util.CQRWeightedRandom;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.util.GearedMobFactory;
import team.cqr.cqrepoured.world.structure.generation.dungeons.DungeonVolcano;
import team.cqr.cqrepoured.world.structure.generation.generation.part.BlockDungeonPart;
import team.cqr.cqrepoured.world.structure.generation.generation.part.CoverDungeonPart;
import team.cqr.cqrepoured.world.structure.generation.generation.part.IDungeonPartBuilder;
import team.cqr.cqrepoured.world.structure.generation.generation.part.PlateauDungeonPart;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparableBlockInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparableLootChestInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparableSpawnerInfo;
import team.cqr.cqrepoured.world.structure.generation.generators.AbstractDungeonGenerator;
import team.cqr.cqrepoured.world.structure.generation.generators.stronghold.spiral.EntranceBuilderHelper;
import team.cqr.cqrepoured.world.structure.generation.generators.stronghold.spiral.StrongholdBuilder;
import team.cqr.cqrepoured.world.structure.generation.generators.volcano.StairCaseHelper;

public class GeneratorVolcano
extends AbstractDungeonGenerator<DungeonVolcano> {
    private final int volcanoHeight;
    private final double steepness;
    private final int minRadius;
    private final int caveHeight;
    private final int caveDepth;
    private final StairCaseHelper.EStairSection startStairSection = StairCaseHelper.getRandomStartSection();
    private final CQRWeightedRandom<IBlockState> volcanoBlocks;
    private final CQRWeightedRandom<IBlockState> volcanoBlocksWithLava;

    public GeneratorVolcano(World world, BlockPos pos, DungeonVolcano dungeon, Random rand) {
        super(world, pos, dungeon, rand);
        this.volcanoHeight = DungeonGenUtils.randomBetween(dungeon.getMinHeight(), dungeon.getMaxHeight(), this.random);
        this.steepness = dungeon.getSteepness();
        this.minRadius = dungeon.getInnerRadius();
        this.caveHeight = (int)((double)this.volcanoHeight * 0.6);
        this.caveDepth = 30;
        this.volcanoBlocks = ((DungeonVolcano)this.dungeon).getVolcanoBlocks().copy();
        this.volcanoBlocksWithLava = ((DungeonVolcano)this.dungeon).getVolcanoBlocks().copy();
        this.volcanoBlocksWithLava.add(new CQRWeightedRandom.WeightedObject<IBlockState>(((DungeonVolcano)this.dungeon).getLavaBlock(), ((DungeonVolcano)this.dungeon).getLavaWeight()));
    }

    @Override
    public void preProcess() {
    }

    @Override
    public void buildStructure() {
        int iZ;
        int iX;
        int outerRadius;
        int iY;
        int[] outerRadiusArray = new int[this.volcanoHeight + this.caveDepth];
        int[] innerRadiusArray = new int[this.volcanoHeight + this.caveDepth];
        double d = Math.cbrt(((double)this.volcanoHeight + 80.0) / this.steepness);
        int baseRadius = this.minRadius * 2 + (int)(d - Math.cbrt(60.0 / this.steepness));
        for (int iY2 = -this.caveDepth; iY2 < this.volcanoHeight; ++iY2) {
            outerRadiusArray[iY2 + this.caveDepth] = iY2 > -20 ? this.minRadius * 2 + (int)(d - Math.cbrt(((double)iY2 + 80.0) / this.steepness)) : baseRadius + (-20 - iY2) / 5;
            innerRadiusArray[iY2 + this.caveDepth] = this.minRadius + (int)Math.sqrt(((double)this.caveHeight - (double)iY2) / (3000.0 * this.steepness));
        }
        int r = outerRadiusArray[0];
        BlockPos referenceLoc = this.pos.func_177982_a(-r, -this.caveDepth, -r);
        IBlockState[][][] blocks = new IBlockState[r * 2 + 1][this.volcanoHeight + this.caveDepth + 2][r * 2 + 1];
        ArrayList<BlockPos> spawnerAndChestList = new ArrayList<BlockPos>();
        if (((DungeonVolcano)this.dungeon).doBuildSupportPlatform()) {
            PlateauDungeonPart.Builder partBuilder = new PlateauDungeonPart.Builder(this.pos.func_177958_n() - r, this.pos.func_177952_p() - r, this.pos.func_177958_n() + r, this.pos.func_177956_o() - this.caveDepth, this.pos.func_177952_p() + r, CQRConfig.general.supportHillWallSize);
            partBuilder.setSupportHillBlock(((DungeonVolcano)this.dungeon).getSupportBlock());
            partBuilder.setSupportHillTopBlock(((DungeonVolcano)this.dungeon).getSupportTopBlock());
            this.dungeonBuilder.add(partBuilder);
        }
        for (iY = 0; iY < this.volcanoHeight + this.caveDepth; ++iY) {
            outerRadius = outerRadiusArray[iY];
            int innerRadius = innerRadiusArray[iY];
            for (int iX2 = -outerRadius; iX2 <= outerRadius; ++iX2) {
                for (int iZ2 = -outerRadius; iZ2 <= outerRadius; ++iZ2) {
                    if (DungeonGenUtils.isInsideCircle(iX2, iZ2, innerRadius)) {
                        blocks[iX2 + r][iY][iZ2 + r] = Blocks.field_150350_a.func_176223_P();
                        continue;
                    }
                    if (!DungeonGenUtils.isInsideCircle(iX2, iZ2, outerRadius)) continue;
                    blocks[iX2 + r][iY][iZ2 + r] = !DungeonGenUtils.isInsideCircle(iX2, iZ2, innerRadius + 2) ? this.getRandomVolcanoBlockWithLava() : this.getRandomVolcanoBlock();
                }
            }
        }
        for (iY = 0; iY < this.volcanoHeight + this.caveDepth; ++iY) {
            outerRadius = outerRadiusArray[iY];
            for (iX = -outerRadius; iX <= outerRadius; ++iX) {
                for (iZ = -outerRadius; iZ <= outerRadius; ++iZ) {
                    if (!DungeonGenUtils.isInsideCircle(iX, iZ, outerRadius) || DungeonGenUtils.isInsideCircle(iX, iZ, outerRadius - 2) && (iY != this.volcanoHeight + this.caveDepth - 1 || DungeonGenUtils.isInsideCircle(iX, iZ, innerRadiusArray[iY])) || !DungeonGenUtils.percentageRandom(0.05, this.random)) continue;
                    GeneratorVolcano.forEachSpherePosition(new BlockPos(iX, iY, iZ), 2 + this.random.nextInt(3), p -> {
                        if (this.isIndexValid(p.func_177958_n() + r, p.func_177956_o(), p.func_177952_p() + r, blocks) && blocks[p.func_177958_n() + r][p.func_177956_o()][p.func_177952_p() + r] == null) {
                            blocks[p.func_177958_n() + r][p.func_177956_o()][p.func_177952_p() + r] = this.getRandomVolcanoBlockWithLava();
                        }
                    });
                }
            }
        }
        this.generateHoles(blocks);
        for (iY = 0; iY < this.volcanoHeight + this.caveDepth; ++iY) {
            int innerRadius = innerRadiusArray[iY];
            for (iX = -innerRadius; iX <= innerRadius; ++iX) {
                for (iZ = -innerRadius; iZ <= innerRadius; ++iZ) {
                    if (iY < 2 && DungeonGenUtils.isInsideCircle(iX, iZ, innerRadius)) {
                        blocks[iX + r][iY][iZ + r] = ((DungeonVolcano)this.dungeon).getLavaBlock();
                    }
                    if (!DungeonGenUtils.isInsideCircle(iX, iZ, innerRadius + 2) || DungeonGenUtils.isInsideCircle(iX, iZ, innerRadius) || !DungeonGenUtils.percentageRandom(0.05, this.random)) continue;
                    GeneratorVolcano.forEachSpherePosition(new BlockPos(iX, iY, iZ), 1 + this.random.nextInt(3), p -> {
                        if (this.isIndexValid(p.func_177958_n() + r, p.func_177956_o(), p.func_177952_p() + r, blocks) && blocks[p.func_177958_n() + r][p.func_177956_o()][p.func_177952_p() + r] == Blocks.field_150350_a.func_176223_P()) {
                            blocks[p.func_177958_n() + r][p.func_177956_o()][p.func_177952_p() + r] = this.getRandomVolcanoBlock();
                        }
                    });
                }
            }
        }
        BlockDungeonPart.Builder entranceTunnelBlocks = new BlockDungeonPart.Builder();
        if (((DungeonVolcano)this.dungeon).doBuildStairs()) {
            StairCaseHelper.EStairSection stairSectionPrev;
            StairCaseHelper.EStairSection stairSection = this.startStairSection;
            int sectionMinX = 0;
            int sectionMaxX = 0;
            int sectionMinZ = 0;
            int sectionMaxZ = 0;
            int highestPlatformY = (int)((double)(this.caveHeight + this.caveDepth) * 0.9 - 1.0);
            for (int iY3 = -1; iY3 <= highestPlatformY; ++iY3) {
                int y = Math.max(iY3, 1);
                int outerStairRadius = innerRadiusArray[y];
                int innerStairRadius = outerStairRadius / 2;
                sectionMinX = 0;
                sectionMaxX = 0;
                sectionMinZ = 0;
                sectionMaxZ = 0;
                for (int iX3 = -outerStairRadius; iX3 <= outerStairRadius; ++iX3) {
                    for (int iZ3 = -outerStairRadius; iZ3 <= outerStairRadius; ++iZ3) {
                        if (!DungeonGenUtils.isInsideCircle(iX3, iZ3, outerStairRadius) || DungeonGenUtils.isInsideCircle(iX3, iZ3, innerStairRadius) || !StairCaseHelper.isLocationFine(stairSection, iX3, iZ3, outerStairRadius)) continue;
                        blocks[iX3 + r][y][iZ3 + r] = ((DungeonVolcano)this.dungeon).getRampBlock();
                        if (iX3 < sectionMinX) {
                            sectionMinX = iX3;
                        }
                        if (iX3 > sectionMaxX) {
                            sectionMaxX = iX3;
                        }
                        if (iZ3 < sectionMinZ) {
                            sectionMinZ = iZ3;
                        }
                        if (iZ3 > sectionMaxZ) {
                            sectionMaxZ = iZ3;
                        }
                        if (!DungeonGenUtils.isInsideCircle(iX3, iZ3, outerStairRadius - 2) || DungeonGenUtils.isInsideCircle(iX3, iZ3, innerStairRadius + 2) || !DungeonGenUtils.percentageRandom(((DungeonVolcano)this.dungeon).getChestChance(), this.random)) continue;
                        spawnerAndChestList.add(new BlockPos(iX3, y - this.caveDepth + 1, iZ3));
                    }
                }
                stairSection = stairSection.getSuccessor();
            }
            this.generatePillars(new BlockPos(r + innerRadiusArray[0] / 2, 0, r), 2, (int)((double)(this.caveHeight + this.caveDepth) * 0.95), blocks, ((DungeonVolcano)this.dungeon).getPillarBlock());
            this.generatePillars(new BlockPos(r - innerRadiusArray[0] / 2, 0, r), 2, (int)((double)(this.caveHeight + this.caveDepth) * 0.95), blocks, ((DungeonVolcano)this.dungeon).getPillarBlock());
            this.generatePillars(new BlockPos(r, 0, r + innerRadiusArray[0] / 2), 2, (int)((double)(this.caveHeight + this.caveDepth) * 0.95), blocks, ((DungeonVolcano)this.dungeon).getPillarBlock());
            this.generatePillars(new BlockPos(r, 0, r - innerRadiusArray[0] / 2), 2, (int)((double)(this.caveHeight + this.caveDepth) * 0.95), blocks, ((DungeonVolcano)this.dungeon).getPillarBlock());
            if (((DungeonVolcano)this.dungeon).constructEntranceTunnel() && (stairSectionPrev = stairSection.getPredeccessor()) != null) {
                EnumFacing direction = stairSectionPrev.getAsSkyDirection();
                int segmentCenterX = (sectionMaxX - sectionMinX) / 2 + sectionMinX;
                int segmentCenterZ = (sectionMaxZ - sectionMinZ) / 2 + sectionMinZ;
                switch (direction) {
                    case EAST: {
                        segmentCenterX += 6;
                        break;
                    }
                    case NORTH: {
                        segmentCenterZ -= 6;
                        break;
                    }
                    case SOUTH: {
                        segmentCenterZ += 6;
                        break;
                    }
                    case WEST: {
                        segmentCenterX -= 6;
                        break;
                    }
                }
                int endX = segmentCenterX;
                int endZ = segmentCenterZ;
                int tunnelLength = outerRadiusArray[highestPlatformY] - innerRadiusArray[highestPlatformY];
                tunnelLength = (int)((double)tunnelLength * 1.5);
                switch (direction) {
                    case EAST: {
                        endX += tunnelLength;
                        break;
                    }
                    case NORTH: {
                        endZ -= tunnelLength;
                        break;
                    }
                    case SOUTH: {
                        endZ += tunnelLength;
                        break;
                    }
                    case WEST: {
                        endX -= tunnelLength;
                        break;
                    }
                }
                GeneratorVolcano.forEachSpherePosition(new BlockPos(endX, highestPlatformY + 3, endZ), 4 + this.random.nextInt(2), p -> {
                    if (this.isIndexValid(p.func_177958_n() + r, p.func_177956_o(), p.func_177952_p() + r, blocks) && blocks[p.func_177958_n() + r][p.func_177956_o()][p.func_177952_p() + r] != Blocks.field_150350_a.func_176223_P()) {
                        blocks[p.func_177958_n() + r][p.func_177956_o()][p.func_177952_p() + r] = Blocks.field_150350_a.func_176223_P();
                    }
                });
                int segmentCount = tunnelLength / 3;
                BlockPos segmentPos = new BlockPos(segmentCenterX + r, highestPlatformY, segmentCenterZ + r);
                for (int i = 0; i < segmentCount; ++i) {
                    EntranceBuilderHelper.buildEntranceSegment(segmentPos, entranceTunnelBlocks, direction);
                    segmentPos = segmentPos.func_177967_a(direction, 3);
                }
            }
        }
        BlockDungeonPart.Builder partBuilder = new BlockDungeonPart.Builder();
        for (int i = 0; i < blocks.length; ++i) {
            for (int j = 0; j < blocks[i].length; ++j) {
                for (int k = 0; k < blocks[i][j].length; ++k) {
                    if (blocks[i][j][k] == null) continue;
                    partBuilder.add(new PreparableBlockInfo(i, j, k, blocks[i][j][k], null));
                }
            }
        }
        this.dungeonBuilder.add((IDungeonPartBuilder)partBuilder, referenceLoc);
        this.dungeonBuilder.add((IDungeonPartBuilder)entranceTunnelBlocks, referenceLoc);
        this.generateSpawnersAndChests(spawnerAndChestList);
        this.generateStronghold(innerRadiusArray[0]);
        if (((DungeonVolcano)this.dungeon).isCoverBlockEnabled()) {
            this.dungeonBuilder.add(new CoverDungeonPart.Builder(this.pos.func_177958_n() - r, this.pos.func_177952_p() - r, this.pos.func_177958_n() + r, this.pos.func_177952_p() + r, ((DungeonVolcano)this.dungeon).getCoverBlock()));
        }
    }

    @Override
    public void postProcess() {
    }

    private void generateHoles(IBlockState[][][] blocks) {
        if (((DungeonVolcano)this.dungeon).isVolcanoDamaged()) {
            ArrayList<BlockPos> list = new ArrayList<BlockPos>((int)((double)this.volcanoHeight * 1.6));
            int i = 0;
            while ((double)i < (double)this.volcanoHeight * 1.6) {
                for (int j = 0; j < 100; ++j) {
                    int z;
                    int y;
                    int x = this.random.nextInt(blocks.length);
                    if (blocks[x][y = this.random.nextInt(blocks[x].length)][z = this.random.nextInt(blocks[x][y].length)] == null || blocks[x][y][z] == Blocks.field_150350_a.func_176223_P()) continue;
                    list.add(new BlockPos(x, y, z));
                    break;
                }
                ++i;
            }
            for (BlockPos pos : list) {
                GeneratorVolcano.forEachSpherePosition(pos, DungeonGenUtils.randomBetween(2, ((DungeonVolcano)this.dungeon).getMaxHoleSize(), this.random), p -> {
                    if (this.isIndexValid(p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), blocks) && blocks[p.func_177958_n()][p.func_177956_o()][p.func_177952_p()] != null && blocks[p.func_177958_n()][p.func_177956_o()][p.func_177952_p()] != Blocks.field_150350_a.func_176223_P()) {
                        blocks[p.func_177958_n()][p.func_177956_o()][p.func_177952_p()] = Blocks.field_150350_a.func_176223_P();
                    }
                });
            }
        }
    }

    private void generatePillars(BlockPos pos, int radius, int height, IBlockState[][][] blocks, IBlockState pillarBlock) {
        for (int iY = 0; iY < height; ++iY) {
            for (int iX = -radius; iX <= radius; ++iX) {
                for (int iZ = -radius; iZ <= radius; ++iZ) {
                    try {
                        blocks[iX + pos.func_177958_n()][iY + pos.func_177956_o()][iZ + pos.func_177952_p()] = pillarBlock;
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void generateSpawnersAndChests(List<BlockPos> spawnerAndChestList) {
        if (!spawnerAndChestList.isEmpty()) {
            ResourceLocation[] lootTables = ((DungeonVolcano)this.dungeon).getChestIDs();
            GearedMobFactory mobFactory = new GearedMobFactory(spawnerAndChestList.size(), ((DungeonVolcano)this.dungeon).getRampMob(), this.random);
            int floor = spawnerAndChestList.size();
            BlockDungeonPart.Builder partBuilder = new BlockDungeonPart.Builder();
            for (BlockPos pos : spawnerAndChestList) {
                if (this.random.nextBoolean()) {
                    partBuilder.add(new PreparableLootChestInfo(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), lootTables[this.random.nextInt(lootTables.length)], EnumFacing.NORTH));
                }
                int entityCount = 2 + this.random.nextInt(3);
                ArrayList<Entity> entityList = new ArrayList<Entity>(entityCount);
                for (int i = 0; i < entityCount; ++i) {
                    entityList.add(mobFactory.getGearedEntityByFloor(floor, this.world));
                }
                partBuilder.add(new PreparableSpawnerInfo(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p(), entityList));
                --floor;
            }
            this.dungeonBuilder.add(partBuilder);
        }
    }

    private void generateStronghold(int radius) {
        if (((DungeonVolcano)this.dungeon).doBuildStronghold()) {
            BlockPos entranceStartPos;
            StairCaseHelper.EStairSection entranceDirection = this.startStairSection.getSuccessor();
            int entranceDistToWall = radius / 3;
            int wideness = radius - entranceDistToWall;
            switch (entranceDirection) {
                case EAST: 
                case EAST_SEC: {
                    entranceStartPos = this.pos.func_177982_a(wideness, 1 - this.caveDepth, 0);
                    break;
                }
                case NORTH: 
                case NORTH_SEC: {
                    entranceStartPos = this.pos.func_177982_a(0, 1 - this.caveDepth, -wideness);
                    break;
                }
                case SOUTH: 
                case SOUTH_SEC: {
                    entranceStartPos = this.pos.func_177982_a(0, 1 - this.caveDepth, wideness);
                    break;
                }
                default: {
                    entranceStartPos = this.pos.func_177982_a(-wideness, 1 - this.caveDepth, 0);
                }
            }
            StrongholdBuilder entranceBuilder = new StrongholdBuilder(this, this.dungeonBuilder, entranceStartPos, entranceDistToWall, (DungeonVolcano)this.dungeon, entranceDirection.getAsSkyDirection(), this.world, this.random);
            entranceBuilder.generate(this.pos.func_177958_n(), this.pos.func_177952_p());
        }
    }

    public static void forEachSpherePosition(BlockPos center, int radius, Consumer<BlockPos.MutableBlockPos> action) {
        for (BlockPos.MutableBlockPos p : BlockPos.func_191531_b((int)(center.func_177958_n() - radius), (int)(center.func_177956_o() - radius), (int)(center.func_177952_p() - radius), (int)(center.func_177958_n() + radius), (int)(center.func_177956_o() + radius), (int)(center.func_177952_p() + radius))) {
            if (!DungeonGenUtils.isInsideSphere(p.func_177958_n() - center.func_177958_n(), p.func_177956_o() - center.func_177956_o(), p.func_177952_p() - center.func_177952_p(), radius)) continue;
            action.accept(p);
        }
    }

    private boolean isIndexValid(int x, int y, int z, Object[][][] array) {
        return x >= 0 && x < array.length && y >= 0 && y < array[x].length && z >= 0 && z < array[x][y].length;
    }

    private IBlockState getRandomVolcanoBlock() {
        IBlockState state = this.volcanoBlocks.next(this.random);
        return state != null ? state : Blocks.field_150348_b.func_176223_P();
    }

    private IBlockState getRandomVolcanoBlockWithLava() {
        IBlockState state = this.volcanoBlocksWithLava.next(this.random);
        return state != null ? state : Blocks.field_150348_b.func_176223_P();
    }
}

