/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generators.stronghold;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.util.ESkyDirection;
import team.cqr.cqrepoured.world.structure.generation.dungeons.DungeonStrongholdLinear;
import team.cqr.cqrepoured.world.structure.generation.generation.part.PlateauDungeonPart;
import team.cqr.cqrepoured.world.structure.generation.generators.AbstractDungeonGenerator;
import team.cqr.cqrepoured.world.structure.generation.generators.stronghold.linear.StrongholdFloor;
import team.cqr.cqrepoured.world.structure.generation.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.world.structure.generation.inhabitants.DungeonInhabitantManager;
import team.cqr.cqrepoured.world.structure.generation.structurefile.CQStructure;
import team.cqr.cqrepoured.world.structure.generation.structurefile.Offset;

public class GeneratorStronghold
extends AbstractDungeonGenerator<DungeonStrongholdLinear> {
    private int dunX;
    private int dunZ;
    private StrongholdFloor[] floors;

    public GeneratorStronghold(World world, BlockPos pos, DungeonStrongholdLinear dungeon, Random rand) {
        super(world, pos, dungeon, rand);
    }

    @Override
    public void preProcess() {
        int count = DungeonGenUtils.randomBetween(((DungeonStrongholdLinear)this.dungeon).getMinFloors(), ((DungeonStrongholdLinear)this.dungeon).getMaxFloors(), this.random);
        int floorSize = ((DungeonStrongholdLinear)this.dungeon).getFloorSize(this.random);
        this.floors = new StrongholdFloor[count];
        this.dunX = this.pos.func_177958_n();
        this.dunZ = this.pos.func_177952_p();
        int sX = 0;
        int sZ = 0;
        ESkyDirection exitDir = ESkyDirection.values()[this.random.nextInt(ESkyDirection.values().length)];
        for (int i = 0; i < this.floors.length; ++i) {
            StrongholdFloor floor = new StrongholdFloor(floorSize, this, i == this.floors.length - 1, this.random);
            floor.generateRoomPattern(sX, sZ, exitDir);
            this.floors[i] = floor;
            exitDir = floor.getExitDirection();
            sX = (Integer)floor.getLastRoomGridPos().func_76341_a();
            sZ = (Integer)floor.getLastRoomGridPos().func_76340_b();
        }
    }

    @Override
    public void buildStructure() {
        int y = this.pos.func_177956_o();
        DungeonInhabitant mobType = DungeonInhabitantManager.instance().getInhabitantByDistanceIfDefault(((DungeonStrongholdLinear)this.dungeon).getDungeonMob(), this.world, this.pos.func_177958_n(), this.pos.func_177952_p());
        PlacementSettings settings = new PlacementSettings();
        CQStructure structureStair = this.loadStructureFromFile(((DungeonStrongholdLinear)this.dungeon).getEntranceStairRoom(this.random));
        CQStructure structureEntrance = this.loadStructureFromFile(((DungeonStrongholdLinear)this.dungeon).getEntranceBuilding(this.random));
        int segCount = 0;
        CQStructure stairSeg = null;
        if (((DungeonStrongholdLinear)this.dungeon).useStairSegments()) {
            int ySurface = y;
            int yTmp = 3;
            yTmp += (this.floors.length - 1) * ((DungeonStrongholdLinear)this.dungeon).getRoomSizeY();
            if ((yTmp += structureStair.getSize().func_177956_o()) < ySurface) {
                stairSeg = this.loadStructureFromFile(((DungeonStrongholdLinear)this.dungeon).getEntranceStairSegment(this.random));
                for (y = yTmp; y < ySurface; y += stairSeg.getSize().func_177956_o()) {
                    ++segCount;
                }
            }
        }
        if (((DungeonStrongholdLinear)this.dungeon).doBuildSupportPlatform()) {
            PlateauDungeonPart.Builder partBuilder = new PlateauDungeonPart.Builder(this.pos.func_177958_n() + 4 + structureEntrance.getSize().func_177958_n() / 2, this.pos.func_177952_p() + 4 + structureEntrance.getSize().func_177952_p() / 2, this.pos.func_177958_n() - 4 - structureEntrance.getSize().func_177958_n() / 2, y + ((DungeonStrongholdLinear)this.dungeon).getUnderGroundOffset() - 1, this.pos.func_177952_p() - 4 - structureEntrance.getSize().func_177952_p() / 2, CQRConfig.general.supportHillWallSize);
            partBuilder.setSupportHillBlock(((DungeonStrongholdLinear)this.dungeon).getSupportBlock());
            partBuilder.setSupportHillTopBlock(((DungeonStrongholdLinear)this.dungeon).getSupportTopBlock());
            this.dungeonBuilder.add(partBuilder);
        }
        structureEntrance.addAll(this.dungeonBuilder, new BlockPos(this.pos.func_177958_n(), y, this.pos.func_177952_p()), Offset.CENTER);
        if (segCount > 0) {
            while (segCount > 0) {
                --segCount;
                stairSeg.addAll(this.dungeonBuilder, new BlockPos(this.pos.func_177958_n(), y -= stairSeg.getSize().func_177956_o(), this.pos.func_177952_p()), Offset.CENTER);
            }
        }
        int yFloor = y;
        structureStair.addAll(this.dungeonBuilder, new BlockPos(this.pos.func_177958_n(), yFloor -= structureStair.getSize().func_177956_o(), this.pos.func_177952_p()), Offset.CENTER);
        for (int i = 0; i < this.floors.length; ++i) {
            StrongholdFloor floor = this.floors[i];
            floor.generateRooms(this.pos.func_177958_n(), this.pos.func_177952_p(), yFloor, settings, this.dungeonBuilder, this.world, mobType);
            yFloor -= ((DungeonStrongholdLinear)this.dungeon).getRoomSizeY();
        }
    }

    @Override
    public void postProcess() {
    }

    public int getDunX() {
        return this.dunX;
    }

    public int getDunZ() {
        return this.dunZ;
    }

    @Override
    public DungeonStrongholdLinear getDungeon() {
        return (DungeonStrongholdLinear)this.dungeon;
    }
}

