/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generators.hangingcity;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.world.structure.generation.PlateauBuilder;
import team.cqr.cqrepoured.world.structure.generation.WorldDungeonGenerator;
import team.cqr.cqrepoured.world.structure.generation.dungeons.DungeonHangingCity;
import team.cqr.cqrepoured.world.structure.generation.generation.GeneratableDungeon;
import team.cqr.cqrepoured.world.structure.generation.generation.part.BlockDungeonPart;
import team.cqr.cqrepoured.world.structure.generation.generation.part.IDungeonPartBuilder;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparableBlockInfo;
import team.cqr.cqrepoured.world.structure.generation.generators.AbstractDungeonGenerationComponent;
import team.cqr.cqrepoured.world.structure.generation.generators.SuspensionBridgeHelper;
import team.cqr.cqrepoured.world.structure.generation.generators.hangingcity.GeneratorHangingCity;
import team.cqr.cqrepoured.world.structure.generation.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.world.structure.generation.structurefile.CQStructure;
import team.cqr.cqrepoured.world.structure.generation.structurefile.Offset;

public class HangingCityBuilding
extends AbstractDungeonGenerationComponent<GeneratorHangingCity> {
    private final int gridPosX;
    private final int gridPosY;
    private int islandRadius;
    private final BlockPos worldPosition;
    private Set<HangingCityBuilding> connectedIslands = new HashSet<HangingCityBuilding>();
    private final CQStructure structure;
    private Set<SuspensionBridgeHelper> bridges = new HashSet<SuspensionBridgeHelper>();

    public HangingCityBuilding(GeneratorHangingCity generator, int posX, int posY, CQStructure structure) {
        super(generator);
        this.gridPosX = posX;
        this.gridPosY = posY;
        this.structure = structure;
        this.islandRadius = this.structure.getSize().func_177958_n() > this.structure.getSize().func_177952_p() ? this.structure.getSize().func_177958_n() : this.structure.getSize().func_177952_p();
        this.worldPosition = ((GeneratorHangingCity)this.generator).getCenterPosForIsland(this);
    }

    public HangingCityBuilding[] getNeighbours() {
        HangingCityBuilding[] neighbours = new HangingCityBuilding[8];
        int i = 0;
        for (int ix = this.gridPosX - 1; ix <= this.gridPosX + 1; ++ix) {
            for (int iy = this.gridPosY - 1; iy <= this.gridPosY + 1; ++iy) {
                if (ix == this.gridPosX && iy == this.gridPosY) continue;
                neighbours[i] = ((GeneratorHangingCity)this.generator).getBuildingFromGridPos(ix, iy);
                ++i;
            }
        }
        return neighbours;
    }

    public boolean hasFreeNeighbourSpots() {
        return !this.getFreeNeighbourSpots().isEmpty();
    }

    public boolean isConnectedToAnyBuilding() {
        return !this.connectedIslands.isEmpty();
    }

    public boolean isConnectedTo(HangingCityBuilding building) {
        return this.connectedIslands.contains(building);
    }

    public void connectTo(HangingCityBuilding building) {
        BlockPos bridgePosOne = this.getConnectorPointForBridgeTo(building);
        BlockPos bridgePosTwo = building.getConnectorPointForBridgeTo(this);
        this.bridges.add(new SuspensionBridgeHelper((SuspensionBridgeHelper.IBridgeDataSupplier)((GeneratorHangingCity)this.generator).getDungeon(), bridgePosOne, bridgePosTwo));
        this.connectedIslands.add(building);
        building.markAsConnected(this);
    }

    public Set<Tuple<Integer, Integer>> getFreeNeighbourSpots() {
        HashSet<Tuple<Integer, Integer>> result = new HashSet<Tuple<Integer, Integer>>();
        for (int ix = this.gridPosX - 1; ix <= this.gridPosX + 1; ++ix) {
            for (int iy = this.gridPosY - 1; iy <= this.gridPosY + 1; ++iy) {
                if (ix == this.gridPosX && iy == this.gridPosY || ((GeneratorHangingCity)this.generator).getBuildingFromGridPos(ix, iy) != null) continue;
                result.add((Tuple<Integer, Integer>)new Tuple((Object)ix, (Object)iy));
            }
        }
        return result;
    }

    public void markAsConnected(HangingCityBuilding connectionInitializer) {
        this.connectedIslands.add(connectionInitializer);
    }

    @Override
    public void preProcess(World world, GeneratableDungeon.Builder dungeonBuilder, DungeonInhabitant mobType) {
        int rad = 2 * this.getRadius();
        int height = ((DungeonHangingCity)((GeneratorHangingCity)this.generator).getDungeon()).getYFactorHeight() > this.structure.getSize().func_177956_o() ? ((DungeonHangingCity)((GeneratorHangingCity)this.generator).getDungeon()).getYFactorHeight() : this.structure.getSize().func_177956_o();
        BlockPos start = this.worldPosition.func_177982_a(-rad, -((DungeonHangingCity)((GeneratorHangingCity)this.generator).getDungeon()).getYFactorHeight(), -rad);
        BlockPos end = this.worldPosition.func_177982_a(rad, height, rad);
        int wall = CQRConfig.general.supportHillWallSize;
        dungeonBuilder.add((IDungeonPartBuilder)PlateauBuilder.makeRandomBlob2(Blocks.field_150350_a, start, end, wall, WorldDungeonGenerator.getSeed(world, ((GeneratorHangingCity)this.generator).getPos().func_177958_n() >> 4, ((GeneratorHangingCity)this.generator).getPos().func_177952_p() >> 4)), start.func_177982_a(-wall, -wall, -wall));
    }

    @Override
    public void generate(World world, GeneratableDungeon.Builder dungeonBuilder, DungeonInhabitant mobType) {
        this.buildPlatform(world, this.worldPosition, this.islandRadius, mobType, dungeonBuilder);
        if (this.structure != null) {
            this.structure.addAll(dungeonBuilder, this.worldPosition.func_177984_a(), Offset.CENTER);
        }
    }

    private void buildPlatform(World world, BlockPos center, int radius, DungeonInhabitant mobType, GeneratableDungeon.Builder dungeonBuilder) {
        HashMap<BlockPos, IBlockState> stateMap = new HashMap<BlockPos, IBlockState>();
        int rad = (int)(1.05 * (double)radius);
        rad += 2;
        for (int decrementor = 0; decrementor < rad / 2; ++decrementor) {
            for (int iX = -(rad -= decrementor); iX <= rad; ++iX) {
                for (int iZ = -rad; iZ <= rad; ++iZ) {
                    if (!DungeonGenUtils.isInsideCircle(iX, iZ, rad)) continue;
                    stateMap.put(center.func_177982_a(iX, -decrementor, iZ), ((DungeonHangingCity)((GeneratorHangingCity)this.generator).getDungeon()).getIslandBlock());
                }
            }
        }
        if (((DungeonHangingCity)((GeneratorHangingCity)this.generator).getDungeon()).doBuildChains()) {
            this.buildChain(world, center.func_177963_a((double)radius * 0.75, -2.0, (double)radius * 0.75), 0, stateMap);
            this.buildChain(world, center.func_177963_a((double)(-radius) * 0.75, -2.0, (double)(-radius) * 0.75), 0, stateMap);
            this.buildChain(world, center.func_177963_a((double)(-radius) * 0.75, -2.0, (double)radius * 0.75), 1, stateMap);
            this.buildChain(world, center.func_177963_a((double)radius * 0.75, -2.0, (double)(-radius) * 0.75), 1, stateMap);
        }
        BlockDungeonPart.Builder partBuilder = new BlockDungeonPart.Builder();
        for (Map.Entry entry : stateMap.entrySet()) {
            partBuilder.add(new PreparableBlockInfo(((BlockPos)entry.getKey()).func_177973_b((Vec3i)center), (IBlockState)entry.getValue(), null));
        }
        dungeonBuilder.add((IDungeonPartBuilder)partBuilder, center);
    }

    private void buildChain(World world, BlockPos pos, int iOffset, Map<BlockPos, IBlockState> stateMap) {
        int deltaYPerChainSegment = 5;
        int maxY = world.func_72800_K();
        int chainCount = (maxY - pos.func_177956_o()) / deltaYPerChainSegment;
        for (int i = 0; i < chainCount; ++i) {
            int yOffset = i * deltaYPerChainSegment;
            BlockPos startPos = pos.func_177982_a(0, yOffset, 0);
            if ((i + iOffset) % 2 > 0) {
                this.buildChainSegment(startPos, startPos.func_177978_c(), startPos.func_177968_d(), startPos.func_177964_d(2).func_177984_a(), startPos.func_177970_e(2).func_177984_a(), stateMap);
                continue;
            }
            this.buildChainSegment(startPos, startPos.func_177974_f(), startPos.func_177976_e(), startPos.func_177965_g(2).func_177984_a(), startPos.func_177985_f(2).func_177984_a(), stateMap);
        }
    }

    private void buildChainSegment(BlockPos lowerCenter, BlockPos lowerLeft, BlockPos lowerRight, BlockPos lowerBoundL, BlockPos lowerBoundR, Map<BlockPos, IBlockState> stateMap) {
        stateMap.put(lowerCenter, ((DungeonHangingCity)((GeneratorHangingCity)this.generator).getDungeon()).getChainBlock());
        stateMap.put(lowerCenter.func_177982_a(0, 6, 0), ((DungeonHangingCity)((GeneratorHangingCity)this.generator).getDungeon()).getChainBlock());
        stateMap.put(lowerLeft, ((DungeonHangingCity)((GeneratorHangingCity)this.generator).getDungeon()).getChainBlock());
        stateMap.put(lowerLeft.func_177982_a(0, 6, 0), ((DungeonHangingCity)((GeneratorHangingCity)this.generator).getDungeon()).getChainBlock());
        stateMap.put(lowerRight, ((DungeonHangingCity)((GeneratorHangingCity)this.generator).getDungeon()).getChainBlock());
        stateMap.put(lowerRight.func_177982_a(0, 6, 0), ((DungeonHangingCity)((GeneratorHangingCity)this.generator).getDungeon()).getChainBlock());
        for (int i = 0; i < 5; ++i) {
            stateMap.put(lowerBoundL.func_177982_a(0, i, 0), ((DungeonHangingCity)((GeneratorHangingCity)this.generator).getDungeon()).getChainBlock());
            stateMap.put(lowerBoundR.func_177982_a(0, i, 0), ((DungeonHangingCity)((GeneratorHangingCity)this.generator).getDungeon()).getChainBlock());
        }
    }

    @Override
    public void generatePost(World world, GeneratableDungeon.Builder dungeonBuilder, DungeonInhabitant mobType) {
        if (((DungeonHangingCity)((GeneratorHangingCity)this.generator).getDungeon()).isConstructBridges()) {
            for (SuspensionBridgeHelper bridge : this.bridges) {
                HashMap<BlockPos, IBlockState> stateMap = new HashMap<BlockPos, IBlockState>();
                bridge.generate(stateMap);
                BlockDungeonPart.Builder partBuilder = new BlockDungeonPart.Builder();
                for (Map.Entry entry : stateMap.entrySet()) {
                    partBuilder.add(new PreparableBlockInfo(((BlockPos)entry.getKey()).func_177973_b((Vec3i)((GeneratorHangingCity)this.generator).getPos()), (IBlockState)entry.getValue(), null));
                }
                dungeonBuilder.add((IDungeonPartBuilder)partBuilder, ((GeneratorHangingCity)this.generator).getPos());
            }
        }
    }

    BlockPos getConnectorPointForBridgeTo(HangingCityBuilding bridgeTarget) {
        Vec3d bridgeVector = new Vec3d((Vec3i)bridgeTarget.getWorldPosition().func_177973_b((Vec3i)this.getWorldPosition()));
        Vec3d horizontalVector = new Vec3d(bridgeVector.field_72450_a, 0.0, bridgeVector.field_72449_c);
        horizontalVector = horizontalVector.func_72432_b();
        horizontalVector = horizontalVector.func_186678_a(1.05 * (double)this.islandRadius - 2.0);
        BlockPos result = this.getWorldPosition().func_177963_a(horizontalVector.field_72450_a, 1.0, horizontalVector.field_72449_c);
        return result;
    }

    int getGridPosX() {
        return this.gridPosX;
    }

    int getGridPosY() {
        return this.gridPosY;
    }

    BlockPos getWorldPosition() {
        return this.worldPosition;
    }

    int getRadius() {
        return this.islandRadius;
    }
}

