/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generators.castleparts.rooms;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import team.cqr.cqrepoured.util.BlockStateGenArray;
import team.cqr.cqrepoured.util.SpiralStaircaseBuilder;
import team.cqr.cqrepoured.world.structure.generation.dungeons.DungeonRandomizedCastle;
import team.cqr.cqrepoured.world.structure.generation.generators.castleparts.rooms.CastleRoomDecoratedBase;
import team.cqr.cqrepoured.world.structure.generation.generators.castleparts.rooms.EnumRoomType;

public class CastleRoomStaircaseSpiral
extends CastleRoomDecoratedBase {
    private EnumFacing firstStairSide;
    private Vec3i pillarOffset;

    public CastleRoomStaircaseSpiral(int sideLength, int height, int floor, Random rand) {
        super(sideLength, height, floor, rand);
        this.roomType = EnumRoomType.STAIRCASE_SPIRAL;
        this.defaultCeiling = false;
        this.defaultFloor = false;
        this.firstStairSide = EnumFacing.NORTH;
        this.recalcPillarOffset();
    }

    @Override
    public void generateRoom(BlockPos castleOrigin, BlockStateGenArray genArray, DungeonRandomizedCastle dungeon) {
        this.recalcPillarOffset();
        BlockPos stairCenter = this.roomOrigin.func_177971_a(this.pillarOffset);
        SpiralStaircaseBuilder stairs = new SpiralStaircaseBuilder(stairCenter, this.firstStairSide, dungeon.getMainBlockState(), dungeon.getStairBlockState());
        for (int x = 0; x < this.getDecorationLengthX(); ++x) {
            for (int z = 0; z < this.getDecorationLengthZ(); ++z) {
                for (int y = 0; y < this.height; ++y) {
                    IBlockState blockToBuild = Blocks.field_150350_a.func_176223_P();
                    BlockPos pos = this.getInteriorBuildStart().func_177982_a(x, y, z);
                    if (y == 0) {
                        blockToBuild = dungeon.getFloorBlockState();
                    } else if (stairs.isPartOfStairs(pos)) {
                        blockToBuild = stairs.getBlock(pos);
                        this.usedDecoPositions.add(pos);
                    } else if (y == this.height - 1) {
                        blockToBuild = dungeon.getMainBlockState();
                    }
                    genArray.addBlockState(pos, blockToBuild, BlockStateGenArray.GenerationPhase.MAIN, BlockStateGenArray.EnumPriority.MEDIUM);
                }
            }
        }
    }

    @Override
    boolean shouldBuildEdgeDecoration() {
        return false;
    }

    @Override
    boolean shouldBuildWallDecoration() {
        return true;
    }

    @Override
    boolean shouldBuildMidDecoration() {
        return false;
    }

    @Override
    boolean shouldAddSpawners() {
        return true;
    }

    @Override
    boolean shouldAddChests() {
        return false;
    }

    public EnumFacing getLastStairSide() {
        EnumFacing result = EnumFacing.NORTH;
        for (int i = 0; i < this.height - 1; ++i) {
            result = result.func_176746_e();
        }
        return result;
    }

    public int getStairCenterOffsetX() {
        return this.pillarOffset.func_177958_n();
    }

    public int getStairCenterOffsetZ() {
        return this.pillarOffset.func_177952_p();
    }

    private void recalcPillarOffset() {
        int centerX = (this.roomLengthX - 1) / 2;
        int centerZ = (this.roomLengthZ - 1) / 2;
        this.pillarOffset = new Vec3i(centerX, 0, centerZ);
    }
}

