/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generators.castleparts.rooms;

import java.util.Random;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import team.cqr.cqrepoured.util.BlockStateGenArray;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.world.structure.generation.dungeons.DungeonRandomizedCastle;
import team.cqr.cqrepoured.world.structure.generation.generators.castleparts.rooms.CastleRoomBase;
import team.cqr.cqrepoured.world.structure.generation.generators.castleparts.rooms.EnumRoomType;

public class CastleRoomStaircaseDirected
extends CastleRoomBase {
    private static final int PLATFORM_LENGTH = 2;
    private EnumFacing doorSide;
    private int numRotations;
    private int upperStairWidth;
    private int upperStairLength;
    private int centerStairWidth;
    private int centerStairLength;

    public CastleRoomStaircaseDirected(int sideLength, int height, EnumFacing doorSide, int floor, Random rand) {
        super(sideLength, height, floor, rand);
        this.roomType = EnumRoomType.STAIRCASE_DIRECTED;
        this.doorSide = doorSide;
        this.numRotations = DungeonGenUtils.getCWRotationsBetween(EnumFacing.SOUTH, this.doorSide);
        this.defaultCeiling = false;
        this.upperStairWidth = 0;
        do {
            ++this.upperStairWidth;
            this.centerStairWidth = sideLength - 1 - this.upperStairWidth * 2;
        } while (this.centerStairWidth - 2 >= this.upperStairWidth + 1);
        this.upperStairLength = height / 2;
        this.centerStairLength = height + 1 - this.upperStairLength;
    }

    @Override
    public void generateRoom(BlockPos castleOrigin, BlockStateGenArray genArray, DungeonRandomizedCastle dungeon) {
        int lenX = this.doorSide.func_176740_k() == EnumFacing.Axis.Z ? this.roomLengthX : this.roomLengthZ;
        int lenZ = this.doorSide.func_176740_k() == EnumFacing.Axis.Z ? this.roomLengthZ : this.roomLengthX;
        for (int x = 0; x < lenX - 1; ++x) {
            for (int z = 0; z < lenZ - 1; ++z) {
                this.buildFloorBlock(x, z, genArray, dungeon);
                if (z < 2) {
                    this.buildPlatform(x, z, genArray, dungeon);
                    continue;
                }
                if ((x < this.upperStairWidth || x >= this.centerStairWidth + this.upperStairWidth) && z < this.upperStairLength + 2) {
                    this.buildUpperStair(x, z, genArray, dungeon);
                    continue;
                }
                if (x < this.upperStairWidth && x >= this.centerStairWidth + this.upperStairWidth || z > this.centerStairLength + 2) continue;
                this.buildLowerStair(x, z, genArray, dungeon);
            }
        }
    }

    public void setDoorSide(EnumFacing side) {
        this.doorSide = side;
    }

    public int getUpperStairEndZ() {
        return this.upperStairLength;
    }

    public int getUpperStairWidth() {
        return this.upperStairWidth;
    }

    public int getCenterStairWidth() {
        return this.centerStairWidth;
    }

    public EnumFacing getDoorSide() {
        return this.doorSide;
    }

    private void buildFloorBlock(int x, int z, BlockStateGenArray genArray, DungeonRandomizedCastle dungeon) {
        IBlockState blockToBuild = dungeon.getFloorBlockState();
        genArray.addBlockState(this.roomOrigin.func_177982_a(x, 0, z), blockToBuild, BlockStateGenArray.GenerationPhase.MAIN, BlockStateGenArray.EnumPriority.MEDIUM);
    }

    private void buildUpperStair(int x, int z, BlockStateGenArray genArray, DungeonRandomizedCastle dungeon) {
        int stairHeight = this.centerStairLength + (z - 2);
        EnumFacing stairFacing = DungeonGenUtils.rotateFacingNTimesAboutY(EnumFacing.SOUTH, this.numRotations);
        for (int y = 1; y < this.height; ++y) {
            IBlockState blockToBuild = y < stairHeight ? dungeon.getMainBlockState() : (y == stairHeight ? dungeon.getStairBlockState().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)stairFacing) : Blocks.field_150350_a.func_176223_P());
            genArray.addBlockState(this.getRotatedPlacement(x, y, z, this.doorSide), blockToBuild, BlockStateGenArray.GenerationPhase.MAIN, BlockStateGenArray.EnumPriority.MEDIUM);
        }
    }

    private void buildLowerStair(int x, int z, BlockStateGenArray genArray, DungeonRandomizedCastle dungeon) {
        int stairHeight = this.centerStairLength - (z - 2 + 1);
        EnumFacing stairFacing = DungeonGenUtils.rotateFacingNTimesAboutY(EnumFacing.NORTH, this.numRotations);
        for (int y = 1; y < this.height; ++y) {
            IBlockState blockToBuild = y < stairHeight ? dungeon.getMainBlockState() : (y == stairHeight ? dungeon.getStairBlockState().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)stairFacing) : Blocks.field_150350_a.func_176223_P());
            genArray.addBlockState(this.getRotatedPlacement(x, y, z, this.doorSide), blockToBuild, BlockStateGenArray.GenerationPhase.MAIN, BlockStateGenArray.EnumPriority.MEDIUM);
        }
    }

    private void buildPlatform(int x, int z, BlockStateGenArray genArray, DungeonRandomizedCastle dungeon) {
        int platformHeight = this.centerStairLength;
        for (int y = 1; y < this.height; ++y) {
            IBlockState blockToBuild = y < platformHeight ? dungeon.getFloorBlockState() : Blocks.field_150350_a.func_176223_P();
            genArray.addBlockState(this.getRotatedPlacement(x, y, z, this.doorSide), blockToBuild, BlockStateGenArray.GenerationPhase.MAIN, BlockStateGenArray.EnumPriority.MEDIUM);
        }
    }

    @Override
    public boolean canBuildDoorOnSide(EnumFacing side) {
        return side == this.doorSide;
    }

    @Override
    public boolean reachableFromSide(EnumFacing side) {
        return side == this.doorSide;
    }
}

