/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generators.castleparts.rooms;

import java.util.Random;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import team.cqr.cqrepoured.util.BlockStateGenArray;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.world.structure.generation.dungeons.DungeonRandomizedCastle;
import team.cqr.cqrepoured.world.structure.generation.generators.castleparts.rooms.CastleRoomDecoratedBase;
import team.cqr.cqrepoured.world.structure.generation.generators.castleparts.rooms.EnumRoomType;

public class CastleRoomBossStairMain
extends CastleRoomDecoratedBase {
    private EnumFacing doorSide;
    private int numRotations;
    private static final int ROOMS_LONG = 2;
    private static final int ROOMS_SHORT = 1;
    private static final int TOP_LANDING_BUFFER_Z = 3;
    private static final int MAIN_LANDING_Z = 2;
    private static final int MAIN_LANDING_X = 7;
    private static final int UPPER_STAIR_X = 3;
    private static final int LOWER_LANDING_Z = 2;
    private static final int LOWER_STAIRS_Z = 2;
    private static final int LOWER_STAIRS_LEN = 2;
    private static final int FLOOR_HEIGHT = 1;
    private static final int MID_STAIR_LENGTH = 2;
    private int endX;
    private int lenX;
    private int endZ;
    private int lenZ;
    private int maxHeightIdx;
    private int topStairLength;
    private int mainLandingXStartIdx;
    private int mainLandingXEndIdx;
    private int mainLandingZStartIdx;
    private int upperStairXStartIdx;
    private int upperStairXEndIdx;
    private int lowerStair1XStartIdx;
    private int lowerStair1XEndIdx;
    private int lowerStair2XStartIdx;
    private int lowerStair2XEndIdx;
    private int lowerLanding1XStartIdx;
    private int lowerLanding1XEndIdx;
    private int lowerLanding2XStartIdx;
    private int lowerLanding2XEndIdx;
    private int lowerLandingZStartIdx;
    private int midStairsZStartIdx;
    private int mainLandingMaxHeightIdx;
    private int lowerLandingMaxHeightIdx;

    public CastleRoomBossStairMain(int sideLength, int height, EnumFacing doorSide, int floor, Random rand) {
        super(sideLength, height, floor, rand);
        this.roomType = EnumRoomType.STAIRCASE_BOSS;
        this.doorSide = doorSide;
        this.numRotations = DungeonGenUtils.getCWRotationsBetween(EnumFacing.NORTH, this.doorSide);
        this.endX = 2 * sideLength;
        this.lenX = this.endX + 1;
        this.endZ = 1 * sideLength - 1;
        this.lenZ = this.endZ + 1;
        this.maxHeightIdx = height - 1;
        this.topStairLength = this.lenZ - 3 - 2;
        int lowerStairLength = height - 1 - 2 - this.topStairLength;
        this.mainLandingXStartIdx = sideLength - 4;
        this.mainLandingXEndIdx = this.mainLandingXStartIdx + 7 - 1;
        this.mainLandingZStartIdx = this.endZ - 2 + 1;
        this.upperStairXStartIdx = sideLength - 2;
        this.upperStairXEndIdx = this.upperStairXStartIdx + 3 - 1;
        this.lowerLanding1XStartIdx = this.upperStairXStartIdx - 2;
        this.lowerLanding1XEndIdx = this.lowerLanding1XStartIdx + 1;
        this.lowerLanding2XStartIdx = this.upperStairXEndIdx + 1;
        this.lowerLanding2XEndIdx = this.lowerLanding2XStartIdx + 1;
        this.lowerStair1XStartIdx = this.lowerLanding1XStartIdx - lowerStairLength;
        this.lowerStair1XEndIdx = this.lowerStair1XStartIdx + lowerStairLength - 1;
        this.lowerStair2XStartIdx = this.lowerLanding2XEndIdx + 1;
        this.lowerStair2XEndIdx = this.lowerStair2XStartIdx + lowerStairLength - 1;
        this.midStairsZStartIdx = this.mainLandingZStartIdx - 2;
        this.lowerLandingZStartIdx = this.midStairsZStartIdx - 2;
        this.mainLandingMaxHeightIdx = height - this.topStairLength - 1;
        this.lowerLandingMaxHeightIdx = this.mainLandingMaxHeightIdx - 2;
    }

    @Override
    public void generateRoom(BlockPos castleOrigin, BlockStateGenArray genArray, DungeonRandomizedCastle dungeon) {
        for (int x = 0; x <= this.endX; ++x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z <= this.endZ; ++z) {
                    IBlockState blockToBuild = this.getBlockToBuild(dungeon, x, y, z);
                    Vec3i offset = DungeonGenUtils.rotateMatrixOffsetCW(new Vec3i(x, y, z), this.lenX, this.lenZ, this.numRotations);
                    genArray.addBlockState(this.roomOrigin.func_177971_a(offset), blockToBuild, BlockStateGenArray.GenerationPhase.MAIN, BlockStateGenArray.EnumPriority.MEDIUM);
                    if (blockToBuild.func_177230_c() == Blocks.field_150350_a) continue;
                    this.usedDecoPositions.add(this.roomOrigin.func_177971_a(offset));
                }
            }
        }
    }

    private IBlockState getBlockToBuild(DungeonRandomizedCastle dungeon, int x, int y, int z) {
        IBlockState blockToBuild = Blocks.field_150350_a.func_176223_P();
        if (y == 0) {
            blockToBuild = this.getFloorBlock(dungeon);
        } else if (y == this.maxHeightIdx) {
            if (x >= this.upperStairXStartIdx && x <= this.upperStairXEndIdx) {
                if (z == 3) {
                    EnumFacing stairFacing = DungeonGenUtils.rotateFacingNTimesAboutY(EnumFacing.NORTH, this.numRotations);
                    return dungeon.getStairBlockState().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)stairFacing);
                }
                if (z < 3) {
                    return dungeon.getMainBlockState();
                }
            } else {
                blockToBuild = dungeon.getMainBlockState();
            }
        } else if (x >= this.mainLandingXStartIdx && x <= this.mainLandingXEndIdx && z >= this.mainLandingZStartIdx) {
            blockToBuild = this.getMainLandingBlock(x, y, z);
        } else if (x >= this.upperStairXStartIdx && x <= this.upperStairXEndIdx && z >= 3 && z <= 3 + this.topStairLength - 1) {
            blockToBuild = this.getUpperStairBlock(x, y, z);
        } else if (x >= this.lowerLanding1XStartIdx && x <= this.lowerLanding1XEndIdx || x >= this.lowerLanding2XStartIdx && x <= this.lowerLanding2XEndIdx) {
            if (z == this.midStairsZStartIdx || z == this.midStairsZStartIdx + 1) {
                blockToBuild = this.getMidStairBlock(x, y, z);
            } else if (z == this.lowerLandingZStartIdx || z == this.lowerLandingZStartIdx + 1) {
                blockToBuild = this.getLowerLandingBlock(x, y, z);
            }
        } else if (x >= this.lowerStair1XStartIdx && x <= this.lowerStair1XEndIdx && (z == this.lowerLandingZStartIdx || z == this.lowerLandingZStartIdx + 1)) {
            blockToBuild = this.getLowerStair1Block(x, y, z);
        } else if (x >= this.lowerStair2XStartIdx && x <= this.lowerStair2XEndIdx && (z == this.lowerLandingZStartIdx || z == this.lowerLandingZStartIdx + 1)) {
            blockToBuild = this.getLowerStair2Block(x, y, z);
        }
        return blockToBuild;
    }

    private IBlockState getLowerStair1Block(int x, int y, int z) {
        if (y == this.lowerLandingMaxHeightIdx - (this.lowerStair1XEndIdx - x)) {
            EnumFacing stairFacing = DungeonGenUtils.rotateFacingNTimesAboutY(EnumFacing.EAST, this.numRotations);
            return Blocks.field_150390_bg.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)stairFacing);
        }
        if (y <= this.lowerLandingMaxHeightIdx - (this.lowerLanding1XEndIdx - x)) {
            return Blocks.field_150417_aV.func_176223_P();
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    private IBlockState getLowerStair2Block(int x, int y, int z) {
        if (y == this.lowerLandingMaxHeightIdx - (x - this.lowerStair2XStartIdx)) {
            EnumFacing stairFacing = DungeonGenUtils.rotateFacingNTimesAboutY(EnumFacing.WEST, this.numRotations);
            return Blocks.field_150390_bg.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)stairFacing);
        }
        if (y <= this.lowerLandingMaxHeightIdx - (x - this.lowerStair2XStartIdx)) {
            return Blocks.field_150417_aV.func_176223_P();
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    private IBlockState getLowerLandingBlock(int x, int y, int z) {
        if (y >= 1 && y <= this.lowerLandingMaxHeightIdx) {
            return Blocks.field_150417_aV.func_176223_P();
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    private IBlockState getMidStairBlock(int x, int y, int z) {
        if (y == this.mainLandingMaxHeightIdx - (this.endZ - z - 2)) {
            EnumFacing stairFacing = DungeonGenUtils.rotateFacingNTimesAboutY(EnumFacing.SOUTH, this.numRotations);
            return Blocks.field_150390_bg.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)stairFacing);
        }
        if (y < this.mainLandingMaxHeightIdx - (this.endZ - z - 2)) {
            return Blocks.field_150417_aV.func_176223_P();
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    private IBlockState getUpperStairBlock(int x, int y, int z) {
        if (y == this.maxHeightIdx - (z - 3)) {
            EnumFacing stairFacing = DungeonGenUtils.rotateFacingNTimesAboutY(EnumFacing.NORTH, this.numRotations);
            return Blocks.field_150390_bg.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)stairFacing);
        }
        if (y < this.maxHeightIdx - (z - 3)) {
            return Blocks.field_150417_aV.func_176223_P();
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public IBlockState getMainLandingBlock(int x, int y, int z) {
        if (y >= 1 && y <= this.mainLandingMaxHeightIdx) {
            return Blocks.field_150417_aV.func_176223_P();
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    @Override
    boolean shouldBuildEdgeDecoration() {
        return false;
    }

    @Override
    boolean shouldBuildWallDecoration() {
        return true;
    }

    @Override
    boolean shouldBuildMidDecoration() {
        return false;
    }

    @Override
    boolean shouldAddSpawners() {
        return true;
    }

    @Override
    boolean shouldAddChests() {
        return false;
    }

    @Override
    public boolean canBuildDoorOnSide(EnumFacing side) {
        return true;
    }

    @Override
    public boolean reachableFromSide(EnumFacing side) {
        return true;
    }
}

