/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generators.castleparts.rooms;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import team.cqr.cqrepoured.util.BlockStateGenArray;
import team.cqr.cqrepoured.util.GearedMobFactory;
import team.cqr.cqrepoured.world.structure.generation.dungeons.DungeonRandomizedCastle;
import team.cqr.cqrepoured.world.structure.generation.generators.castleparts.rooms.EnumRoomType;
import team.cqr.cqrepoured.world.structure.generation.generators.castleparts.rooms.segments.CastleMainStructWall;

public abstract class CastleRoomBase {
    protected BlockPos roomOrigin;
    protected BlockPos buildStartPos;
    protected int height;
    protected int sideLength;
    protected int roomLengthX;
    protected int roomLengthZ;
    protected int offsetX;
    protected int offsetZ;
    protected int floor;
    protected int maxSlotsUsed = 1;
    protected boolean isRootRoomInBlock = false;
    protected List<CastleRoomBase> roomsInBlock = new ArrayList<CastleRoomBase>();
    protected boolean isTower = false;
    protected boolean pathable = true;
    protected EnumRoomType roomType = EnumRoomType.NONE;
    protected boolean defaultCeiling = false;
    protected boolean defaultFloor = false;
    protected Random random;
    protected Set<BlockPos> possibleDecoPositions;
    protected Set<BlockPos> usedDecoPositions;
    protected Map<EnumFacing, CastleMainStructWall> walls = new EnumMap<EnumFacing, CastleMainStructWall>(EnumFacing.class);

    public CastleRoomBase(int sideLength, int height, int floor, Random rand) {
        this.sideLength = sideLength;
        this.offsetX = 0;
        this.offsetZ = 0;
        this.roomLengthX = this.sideLength;
        this.roomLengthZ = this.sideLength;
        this.height = height;
        this.floor = floor;
        this.random = rand;
        this.usedDecoPositions = new HashSet<BlockPos>();
        this.possibleDecoPositions = new HashSet<BlockPos>();
    }

    public void setRoomOrigin(BlockPos offset) {
        this.roomOrigin = offset;
    }

    public void generate(BlockPos castleOrigin, BlockStateGenArray genArray, DungeonRandomizedCastle dungeon) {
        this.generateRoom(castleOrigin, genArray, dungeon);
        if (this.defaultFloor) {
            this.generateDefaultFloor(genArray, dungeon);
        }
        if (this.defaultCeiling) {
            this.generateDefaultCeiling(genArray, dungeon);
        }
    }

    public void postProcess(BlockStateGenArray genArray, DungeonRandomizedCastle dungeon) {
    }

    protected abstract void generateRoom(BlockPos var1, BlockStateGenArray var2, DungeonRandomizedCastle var3);

    public void decorate(World world, BlockStateGenArray genArray, DungeonRandomizedCastle dungeon, GearedMobFactory mobFactory) {
    }

    public void placeBoss(World world, BlockStateGenArray genArray, DungeonRandomizedCastle dungeon, ResourceLocation bossResourceLocation, List<String> bossUuids) {
    }

    public boolean canBuildDoorOnSide(EnumFacing side) {
        return true;
    }

    public boolean canBuildInnerWallOnSide(EnumFacing side) {
        return true;
    }

    public boolean reachableFromSide(EnumFacing side) {
        return true;
    }

    public boolean isTower() {
        return this.roomType.isTowerRoom();
    }

    public boolean isStairsOrLanding() {
        return this.roomType.isStairRoom();
    }

    public boolean isPathable() {
        return this.roomType.isPathable();
    }

    protected void generateDefaultCeiling(BlockStateGenArray genArray, DungeonRandomizedCastle dungeon) {
        for (int z = 0; z < this.getDecorationLengthZ(); ++z) {
            for (int x = 0; x < this.getDecorationLengthX(); ++x) {
                genArray.addBlockState(this.getInteriorBuildStart().func_177982_a(x, this.height - 1, z), dungeon.getMainBlockState(), BlockStateGenArray.GenerationPhase.MAIN, BlockStateGenArray.EnumPriority.MEDIUM);
            }
        }
    }

    protected void generateDefaultFloor(BlockStateGenArray genArray, DungeonRandomizedCastle dungeon) {
        BlockPos pos = this.getNonWallStartPos();
        for (int z = 0; z < this.getDecorationLengthZ(); ++z) {
            for (int x = 0; x < this.getDecorationLengthX(); ++x) {
                genArray.addBlockState(pos.func_177982_a(x, 0, z), this.getFloorBlock(dungeon), BlockStateGenArray.GenerationPhase.MAIN, BlockStateGenArray.EnumPriority.MEDIUM);
            }
        }
    }

    protected void fillEmptySpaceWithAir(BlockStateGenArray genArray) {
        HashSet<BlockPos> emptySpaces = new HashSet<BlockPos>(this.possibleDecoPositions);
        emptySpaces.removeAll(this.usedDecoPositions);
        for (BlockPos emptyPos : emptySpaces) {
            genArray.addBlockState(emptyPos, Blocks.field_150350_a.func_176223_P(), BlockStateGenArray.GenerationPhase.MAIN, BlockStateGenArray.EnumPriority.MEDIUM);
        }
    }

    protected IBlockState getFloorBlock(DungeonRandomizedCastle dungeon) {
        return dungeon.getFloorBlockState();
    }

    public EnumRoomType getRoomType() {
        return this.roomType;
    }

    protected BlockPos getRotatedPlacement(int x, int y, int z, EnumFacing rotation) {
        switch (rotation) {
            case EAST: {
                return this.roomOrigin.func_177982_a(z, y, this.sideLength - 2 - x);
            }
            case WEST: {
                return this.roomOrigin.func_177982_a(this.sideLength - 2 - z, y, x);
            }
            case NORTH: {
                return this.roomOrigin.func_177982_a(this.sideLength - 2 - x, y, this.sideLength - 2 - z);
            }
        }
        return this.roomOrigin.func_177982_a(x, y, z);
    }

    protected BlockPos getInteriorBuildStart() {
        return this.roomOrigin.func_177982_a(this.offsetX, 0, this.offsetZ);
    }

    protected BlockPos getExteriorBuildStart() {
        return this.buildStartPos.func_177982_a(this.offsetX, 0, this.offsetZ);
    }

    protected void setupDecoration(BlockStateGenArray genArray, DungeonRandomizedCastle dungeon) {
        this.possibleDecoPositions = new HashSet<BlockPos>(this.getDecorationArea());
        this.setDoorAndWindowAreasToAir(genArray, dungeon);
    }

    protected void setDoorAndWindowAreasToAir(BlockStateGenArray genArray, DungeonRandomizedCastle dungeon) {
        BlockPos northStart = this.getDecorationStartPos();
        BlockPos westStart = this.getDecorationStartPos();
        BlockPos eastStart = this.getDecorationStartPos().func_177982_a(this.getDecorationLengthX() - 1, 0, 0);
        BlockPos southStart = this.getDecorationStartPos().func_177982_a(0, 0, this.getDecorationLengthZ() - 1);
        for (EnumFacing side : EnumFacing.field_176754_o) {
            BlockPos decoPos;
            int offsetUpWall;
            int offsetAlongWall;
            int y;
            CastleMainStructWall wall = this.walls.get(side);
            if (wall == null) continue;
            if (side.func_176740_k() == EnumFacing.Axis.Z) {
                for (int x = 0; x < this.getDecorationLengthX(); ++x) {
                    for (y = 0; y < this.getDecorationLengthY(); ++y) {
                        offsetAlongWall = x + 1;
                        int n = offsetUpWall = this.hasFloor() ? y + 1 : y;
                        if (!wall.offsetIsDoorOrWindow(offsetAlongWall, offsetUpWall, dungeon)) continue;
                        decoPos = side == EnumFacing.NORTH ? northStart.func_177982_a(x, y, 0) : southStart.func_177982_a(x, y, 0);
                        this.usedDecoPositions.add(decoPos);
                        genArray.addBlockState(decoPos, Blocks.field_150350_a.func_176223_P(), BlockStateGenArray.GenerationPhase.MAIN, BlockStateGenArray.EnumPriority.MEDIUM);
                    }
                }
                continue;
            }
            for (int z = 0; z < this.getDecorationLengthZ(); ++z) {
                for (y = 0; y < this.getDecorationLengthY(); ++y) {
                    offsetAlongWall = z + 1;
                    int n = offsetUpWall = this.hasFloor() ? y + 1 : y;
                    if (!wall.offsetIsDoorOrWindow(offsetAlongWall, offsetUpWall, dungeon)) continue;
                    decoPos = side == EnumFacing.WEST ? westStart.func_177982_a(0, y, z) : eastStart.func_177982_a(0, y, z);
                    this.usedDecoPositions.add(decoPos);
                    genArray.addBlockState(decoPos, Blocks.field_150350_a.func_176223_P(), BlockStateGenArray.GenerationPhase.MAIN, BlockStateGenArray.EnumPriority.MEDIUM);
                }
            }
        }
    }

    protected List<BlockPos> getDecorationEdge(EnumFacing side) {
        List<BlockPos> result = this.getDecorationLayer(0);
        this.removeAllButEdge(result, side);
        result.removeIf(p -> this.usedDecoPositions.contains(p));
        return result;
    }

    protected List<BlockPos> getDecorationMiddle() {
        List<BlockPos> result = this.getDecorationLayer(0);
        for (EnumFacing side : EnumFacing.field_176754_o) {
            result.removeAll(this.getDecorationEdge(side));
        }
        return result;
    }

    protected List<BlockPos> getWallDecorationEdge(EnumFacing side) {
        List<BlockPos> result = this.getDecorationLayer(2);
        this.removeAllButEdge(result, side);
        result.removeIf(p -> this.usedDecoPositions.contains(p));
        return result;
    }

    private void removeAllButEdge(List<BlockPos> blockList, EnumFacing side) {
        BlockPos topLeft = this.getDecorationStartPos();
        int xStart = topLeft.func_177958_n();
        int zStart = topLeft.func_177952_p();
        int xEnd = xStart + (this.getDecorationLengthX() - 1);
        int zEnd = zStart + (this.getDecorationLengthZ() - 1);
        if (side == EnumFacing.NORTH) {
            blockList.removeIf(p -> p.func_177952_p() != zStart);
            blockList.sort(Comparator.comparingInt(Vec3i::func_177958_n));
        } else if (side == EnumFacing.SOUTH) {
            blockList.removeIf(p -> p.func_177952_p() != zEnd);
            blockList.sort(Comparator.comparingInt(Vec3i::func_177958_n).reversed());
        } else if (side == EnumFacing.WEST) {
            blockList.removeIf(p -> p.func_177958_n() != xStart);
            blockList.sort(Comparator.comparingInt(Vec3i::func_177952_p));
        } else if (side == EnumFacing.EAST) {
            blockList.removeIf(p -> p.func_177958_n() != xEnd);
            blockList.sort(Comparator.comparingInt(Vec3i::func_177952_p).reversed());
        }
    }

    protected List<BlockPos> getDecorationLayer(int layer) {
        List<BlockPos> result = this.getDecorationArea();
        if (!result.isEmpty()) {
            BlockPos lowerUpperLeft = result.get(0);
            int y = lowerUpperLeft.func_177956_o() + layer;
            result.removeIf(p -> p.func_177956_o() != y);
        }
        return result;
    }

    protected List<BlockPos> getDecorationArea() {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        BlockPos start = this.getDecorationStartPos();
        for (int x = 0; x < this.getDecorationLengthX(); ++x) {
            for (int y = 0; y < this.getDecorationLengthY(); ++y) {
                for (int z = 0; z < this.getDecorationLengthZ(); ++z) {
                    result.add(start.func_177982_a(x, y, z));
                }
            }
        }
        return result;
    }

    protected BlockPos getDecorationStartPos() {
        if (this.hasFloor()) {
            return this.getNonWallStartPos().func_177984_a();
        }
        return this.getNonWallStartPos();
    }

    protected boolean hasFloor() {
        return true;
    }

    protected BlockPos getNonWallStartPos() {
        return this.roomOrigin.func_177982_a(this.offsetX, 0, this.offsetZ);
    }

    protected int getDecorationLengthX() {
        int length = this.roomLengthX;
        if (this.walls.containsKey(EnumFacing.EAST) && !this.walls.get(EnumFacing.EAST).isEnabled()) {
            ++length;
        }
        return length;
    }

    protected int getDecorationLengthZ() {
        int length = this.roomLengthZ;
        if (this.walls.containsKey(EnumFacing.SOUTH) && !this.walls.get(EnumFacing.SOUTH).isEnabled()) {
            ++length;
        }
        return length;
    }

    public int getDecorationLengthY() {
        int result = this.height;
        if (this.defaultCeiling) {
            --result;
        }
        if (this.hasFloor()) {
            --result;
        }
        return result;
    }

    public ResourceLocation[] getChestIDs() {
        return new ResourceLocation[0];
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetZ() {
        return this.offsetZ;
    }

    public int getRoomLengthX() {
        return this.roomLengthX;
    }

    public int getRoomLengthZ() {
        return this.roomLengthZ;
    }

    public boolean isWalkableRoof() {
        return this.roomType == EnumRoomType.WALKABLE_ROOF || this.roomType == EnumRoomType.WALKABLE_TOWER_ROOF;
    }

    public boolean isReplacedRoof() {
        return this.roomType == EnumRoomType.REPLACED_ROOF;
    }

    public boolean isBossLanding() {
        return this.roomType == EnumRoomType.LANDING_BOSS;
    }

    public void setRoomsInBlock(List<CastleRoomBase> rooms) {
        this.roomsInBlock = rooms;
        this.makeRoomBlockAdjustments();
    }

    protected void makeRoomBlockAdjustments() {
    }

    public void setAsRootRoom() {
        this.isRootRoomInBlock = true;
    }

    public String toString() {
        return this.roomType.toString();
    }

    public void copyPropertiesOf(CastleRoomBase room) {
    }

    public void registerWalls(Map<EnumFacing, CastleMainStructWall> walls) {
        this.walls = walls;
    }
}

