/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generators.castleparts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import team.cqr.cqrepoured.util.BlockStateGenArray;
import team.cqr.cqrepoured.world.structure.generation.dungeons.DungeonRandomizedCastle;
import team.cqr.cqrepoured.world.structure.generation.generators.castleparts.RoomGridPosition;
import team.cqr.cqrepoured.world.structure.generation.generators.castleparts.rooms.CastleRoomBase;
import team.cqr.cqrepoured.world.structure.generation.generators.castleparts.rooms.segments.CastleMainStructWall;
import team.cqr.cqrepoured.world.structure.generation.generators.castleparts.rooms.segments.EnumCastleDoorType;

public class RoomGridCell {
    private final RoomGridPosition gridPosition;
    private final BlockPos originOffset;
    private CellState state = CellState.UNUSED;
    private boolean reachable = false;
    private boolean floorHasLanding = false;
    private boolean partOfMainStruct = false;
    private CastleRoomBase room = null;
    private Set<RoomGridCell> connectedCells;
    private Set<RoomGridCell> pathableCells;
    private boolean isBossArea = false;
    private Map<EnumFacing, RoomGridCell> adjacentCells = new EnumMap<EnumFacing, RoomGridCell>(EnumFacing.class);
    private Map<EnumFacing, CastleMainStructWall> walls = new EnumMap<EnumFacing, CastleMainStructWall>(EnumFacing.class);

    public RoomGridCell(int floor, int x, int z, int roomWidth, int floorHeight) {
        this.gridPosition = new RoomGridPosition(floor, x, z);
        this.originOffset = this.calculateOriginOffset(roomWidth, floorHeight);
        this.connectedCells = new HashSet<RoomGridCell>();
        this.pathableCells = new HashSet<RoomGridCell>();
    }

    private BlockPos calculateOriginOffset(int roomWidth, int floorHeight) {
        int xOffset = 1 + this.gridPosition.getX() * (roomWidth + 1);
        int zOffset = 1 + this.gridPosition.getZ() * (roomWidth + 1);
        int yOffset = this.gridPosition.getFloor() * floorHeight;
        return new BlockPos(xOffset, yOffset, zOffset);
    }

    public BlockPos getOriginOffset() {
        return this.originOffset;
    }

    public void generateRoom(BlockPos castleOrigin, BlockStateGenArray genArray, DungeonRandomizedCastle dungeon) {
        if (this.isPopulated() && this.room != null) {
            this.room.setRoomOrigin(this.getOriginOffset());
            this.room.registerWalls(this.walls);
            this.room.generate(castleOrigin, genArray, dungeon);
        }
    }

    public void registerAdjacentCell(RoomGridCell cell, EnumFacing directionOfCell) {
        this.adjacentCells.put(directionOfCell, cell);
    }

    public Optional<RoomGridCell> getAdjacentCell(EnumFacing direction) {
        if (this.adjacentCells.containsKey(direction)) {
            return Optional.of(this.adjacentCells.get(direction));
        }
        return Optional.empty();
    }

    public void registerAdjacentWall(CastleMainStructWall wall, EnumFacing directionOfWall) {
        this.walls.put(directionOfWall, wall);
    }

    public Optional<CastleMainStructWall> getAdjacentWall(EnumFacing direction) {
        if (this.walls.containsKey(direction)) {
            return Optional.of(this.walls.get(direction));
        }
        return Optional.empty();
    }

    public void setAllLinkedReachable(List<RoomGridCell> unreachableCells, List<RoomGridCell> reachableCells) {
        this.reachable = true;
        for (RoomGridCell linkedCell : this.getConnectedCellsCopy()) {
            linkedCell.setReachable();
            unreachableCells.remove(linkedCell);
            if (reachableCells.contains(linkedCell)) continue;
            reachableCells.add(linkedCell);
        }
    }

    public void setReachable() {
        this.reachable = true;
    }

    public boolean isReachable() {
        return this.reachable;
    }

    public boolean isMainStruct() {
        return this.partOfMainStruct;
    }

    public void setBuildable() {
        if (this.state.isLessThan(CellState.BUILDABLE)) {
            this.state = CellState.BUILDABLE;
        }
    }

    public boolean isBuildable() {
        return this.state.isAtLeast(CellState.BUILDABLE);
    }

    public boolean isNotSelected() {
        return this.state.isLessThan(CellState.SELECTED);
    }

    public void selectForBuilding() {
        if (this.state.isLessThan(CellState.SELECTED)) {
            this.state = CellState.SELECTED;
        }
    }

    public boolean isSelectedForBuilding() {
        return this.state.isAtLeast(CellState.SELECTED);
    }

    public boolean isPopulated() {
        return this.state.isAtLeast(CellState.POPULATED);
    }

    public boolean needsRoomType() {
        return this.state == CellState.SELECTED;
    }

    public boolean isValidPathStart() {
        return !this.isReachable() && this.isPopulated() && this.room.isPathable();
    }

    public boolean isValidPathDestination() {
        return this.isReachable() && this.isPopulated() && this.room.isPathable();
    }

    public boolean isValidHallwayRoom() {
        return this.needsRoomType() && !this.isBossArea;
    }

    public double distanceTo(RoomGridCell destCell) {
        int distX = Math.abs(this.getGridX() - destCell.getGridX());
        int distZ = Math.abs(this.getGridZ() - destCell.getGridZ());
        return Math.hypot(distX, distZ);
    }

    public CastleRoomBase getRoom() {
        return this.room;
    }

    public void setRoom(CastleRoomBase room) {
        this.room = room;
        this.state = CellState.POPULATED;
    }

    public boolean reachableFromSide(EnumFacing side) {
        if (this.room != null) {
            return this.room.reachableFromSide(side);
        }
        return true;
    }

    public RoomGridPosition getGridPosition() {
        return this.gridPosition;
    }

    public int getFloor() {
        return this.gridPosition.getFloor();
    }

    public int getGridX() {
        return this.gridPosition.getX();
    }

    public int getGridZ() {
        return this.gridPosition.getZ();
    }

    public void setBossRoomCell() {
        this.isBossArea = true;
    }

    public boolean isBossArea() {
        return this.isBossArea;
    }

    public void connectToCell(RoomGridCell cell) {
        this.connectedCells.add(cell);
    }

    public void connectToCells(Collection<RoomGridCell> cell) {
        this.connectedCells.addAll(cell);
    }

    public void setConnectedCells(Set<RoomGridCell> cells) {
        this.connectedCells = new HashSet<RoomGridCell>(cells);
    }

    public Set<RoomGridCell> getConnectedCellsCopy() {
        return new HashSet<RoomGridCell>(this.connectedCells);
    }

    public boolean isConnectedToCell(RoomGridCell cell) {
        return this.connectedCells.contains(cell);
    }

    public void addPathableCells(Set<RoomGridCell> cells) {
        this.pathableCells.addAll(cells);
    }

    public Set<RoomGridCell> getPathableCellsCopy() {
        return new HashSet<RoomGridCell>(this.pathableCells);
    }

    public boolean isOnFloorWithLanding() {
        return this.floorHasLanding;
    }

    private void setHasLanding() {
        this.floorHasLanding = true;
    }

    public void setLandingForAllPathableCells() {
        for (RoomGridCell cell : this.pathableCells) {
            cell.setHasLanding();
        }
    }

    public void addDoorOnSideCentered(EnumFacing side, EnumCastleDoorType type, Random random) {
        if (this.walls.containsKey(side)) {
            this.walls.get(side).addDoorCentered(type, random);
        }
    }

    public void addDoorOnSideRandomOffset(EnumFacing side, EnumCastleDoorType type, Random random) {
        if (this.walls.containsKey(side)) {
            this.walls.get(side).addDoorRandomOffset(type, random);
        }
    }

    public void addOuterWall(EnumFacing side) {
        if (this.walls.containsKey(side)) {
            this.walls.get(side).enable();
            this.walls.get(side).setAsOuterWall();
        }
    }

    public void addRoofEdgeWall(EnumFacing side) {
        if (this.walls.containsKey(side)) {
            this.walls.get(side).enable();
            this.walls.get(side).setAsOuterWall();
            this.walls.get(side).setAsRoofEdge();
        }
    }

    public void addInnerWall(EnumFacing side) {
        if (this.walls.containsKey(side)) {
            this.walls.get(side).enable();
            this.walls.get(side).setAsInnerWall();
        }
    }

    public void removeWall(EnumFacing side) {
        if (this.walls.containsKey(side)) {
            this.walls.get(side).disable();
        }
    }

    public void copyRoomPropertiesToConnectedCells() {
        List connectedRooms = this.connectedCells.stream().filter(RoomGridCell::isPopulated).map(RoomGridCell::getRoom).collect(Collectors.toList());
        for (CastleRoomBase connectedRoom : connectedRooms) {
            connectedRoom.copyPropertiesOf(this.room);
        }
    }

    public List<EnumFacing> getPotentialBridgeDirections() {
        ArrayList<EnumFacing> result = new ArrayList<EnumFacing>();
        if (this.isPopulated()) {
            for (EnumFacing side : EnumFacing.field_176754_o) {
                Optional<RoomGridCell> adjacent = this.getAdjacentCell(side);
                if (!adjacent.isPresent() || !adjacent.get().isValidForBridge()) continue;
                result.add(side);
            }
        }
        return result;
    }

    public boolean isValidForBridge() {
        if (this.isNotSelected()) {
            Optional<RoomGridCell> below = this.getAdjacentCell(EnumFacing.DOWN);
            return below.isPresent() && below.get().isNotSelected();
        }
        return false;
    }

    public String toString() {
        String roomStr = this.getRoom() == null ? "null" : this.getRoom().toString();
        return String.format("RoomGridCell{%s, state=%s, room=%s}", this.gridPosition.toString(), this.state.toString(), roomStr);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RoomGridCell)) {
            return false;
        }
        RoomGridCell cell = (RoomGridCell)obj;
        return this.gridPosition == cell.gridPosition && this.state == cell.state && this.room == cell.room;
    }

    public int hashCode() {
        return this.gridPosition.hashCode();
    }

    private static enum CellState {
        UNUSED(0, "Unused"),
        BUILDABLE(1, "Buildable"),
        SELECTED(2, "Selected"),
        POPULATED(3, "Populated");

        private final int value;
        private final String text;

        private CellState(int value, String text) {
            this.value = value;
            this.text = text;
        }

        public String toString() {
            return this.text;
        }

        private boolean isAtLeast(CellState state) {
            return this.value >= state.value;
        }

        private boolean isLessThan(CellState state) {
            return this.value < state.value;
        }
    }
}

