/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generators;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.util.BlockStateGenArray;
import team.cqr.cqrepoured.world.structure.generation.dungeons.DungeonRandomizedCastle;
import team.cqr.cqrepoured.world.structure.generation.generation.part.BlockDungeonPart;
import team.cqr.cqrepoured.world.structure.generation.generation.part.EntityDungeonPart;
import team.cqr.cqrepoured.world.structure.generation.generation.part.IDungeonPartBuilder;
import team.cqr.cqrepoured.world.structure.generation.generation.part.PlateauDungeonPart;
import team.cqr.cqrepoured.world.structure.generation.generators.AbstractDungeonGenerator;
import team.cqr.cqrepoured.world.structure.generation.generators.castleparts.CastleRoomSelector;
import team.cqr.cqrepoured.world.structure.generation.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.world.structure.generation.inhabitants.DungeonInhabitantManager;

public class GeneratorRandomizedCastle
extends AbstractDungeonGenerator<DungeonRandomizedCastle> {
    private CastleRoomSelector roomHelper;
    private BlockPos structurePos;

    public GeneratorRandomizedCastle(World world, BlockPos pos, DungeonRandomizedCastle dungeon, Random rand) {
        super(world, pos, dungeon, rand);
    }

    @Override
    public void preProcess() {
        this.roomHelper = new CastleRoomSelector((DungeonRandomizedCastle)this.dungeon, this.random);
        this.roomHelper.randomizeCastle();
        int minX = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (CastleRoomSelector.SupportArea area : this.roomHelper.getSupportAreas()) {
            minX = Math.min(area.getNwCorner().func_177958_n(), minX);
            minZ = Math.min(area.getNwCorner().func_177952_p(), minZ);
            maxX = Math.max(area.getNwCorner().func_177958_n() + area.getBlocksX(), maxX);
            maxZ = Math.max(area.getNwCorner().func_177952_p() + area.getBlocksZ(), maxZ);
        }
        this.structurePos = this.pos.func_177982_a((minX - maxX) / 2, 0, (minZ - maxZ) / 2);
        if (((DungeonRandomizedCastle)this.dungeon).doBuildSupportPlatform()) {
            for (CastleRoomSelector.SupportArea area : this.roomHelper.getSupportAreas()) {
                BlockPos p1 = this.structurePos.func_177971_a((Vec3i)area.getNwCorner());
                BlockPos p2 = p1.func_177982_a(area.getBlocksX(), 0, area.getBlocksZ());
                PlateauDungeonPart.Builder partBuilder = new PlateauDungeonPart.Builder(p1.func_177958_n(), p1.func_177952_p(), p2.func_177958_n(), p2.func_177956_o(), p2.func_177952_p(), CQRConfig.general.supportHillWallSize);
                partBuilder.setSupportHillBlock(((DungeonRandomizedCastle)this.dungeon).getSupportBlock());
                partBuilder.setSupportHillTopBlock(((DungeonRandomizedCastle)this.dungeon).getSupportTopBlock());
                this.dungeonBuilder.add(partBuilder);
            }
        }
    }

    @Override
    public void buildStructure() {
        BlockStateGenArray genArray = new BlockStateGenArray(this.random);
        ArrayList<String> bossUuids = new ArrayList<String>();
        DungeonInhabitant mobType = DungeonInhabitantManager.instance().getInhabitantByDistanceIfDefault(((DungeonRandomizedCastle)this.dungeon).getDungeonMob(), this.world, this.pos.func_177958_n(), this.pos.func_177952_p());
        this.roomHelper.generate(this.world, genArray, (DungeonRandomizedCastle)this.dungeon, this.pos, bossUuids, mobType);
        this.dungeonBuilder.add((IDungeonPartBuilder)new BlockDungeonPart.Builder().addAll(genArray.getMainMap().values()), this.structurePos);
        this.dungeonBuilder.add((IDungeonPartBuilder)new BlockDungeonPart.Builder().addAll(genArray.getPostMap().values()), this.structurePos);
        this.dungeonBuilder.add((IDungeonPartBuilder)new EntityDungeonPart.Builder().addAll(genArray.getEntityMap()), this.structurePos);
    }

    @Override
    public void postProcess() {
    }
}

