/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generators;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.util.VectorUtil;
import team.cqr.cqrepoured.world.structure.generation.dungeons.DungeonGuardedCastle;
import team.cqr.cqrepoured.world.structure.generation.generation.DungeonPlacement;
import team.cqr.cqrepoured.world.structure.generation.generation.part.CoverDungeonPart;
import team.cqr.cqrepoured.world.structure.generation.generation.part.PlateauDungeonPart;
import team.cqr.cqrepoured.world.structure.generation.generators.AbstractDungeonGenerator;
import team.cqr.cqrepoured.world.structure.generation.structurefile.CQStructure;
import team.cqr.cqrepoured.world.structure.generation.structurefile.Offset;

public class GeneratorGuardedStructure
extends AbstractDungeonGenerator<DungeonGuardedCastle> {
    private Map<BlockPos, CQStructure> toGenerate = new HashMap<BlockPos, CQStructure>();
    private Map<BlockPos, Mirror> mirrorMap = new HashMap<BlockPos, Mirror>();
    private Map<BlockPos, Rotation> rotationMap = new HashMap<BlockPos, Rotation>();

    public GeneratorGuardedStructure(World world, BlockPos pos, DungeonGuardedCastle dungeon, Random rand) {
        super(world, pos, dungeon, rand);
    }

    private void processStructure(CQStructure structure, BlockPos position) {
        Mirror mirror = Mirror.NONE;
        Rotation rotation = Rotation.NONE;
        if (((DungeonGuardedCastle)this.dungeon).rotateDungeon()) {
            mirror = Mirror.values()[this.random.nextInt(Mirror.values().length)];
            rotation = Rotation.values()[this.random.nextInt(Rotation.values().length)];
        }
        if (((DungeonGuardedCastle)this.dungeon).doBuildSupportPlatform()) {
            BlockPos structurePos = Offset.CENTER.apply(position, structure, mirror, rotation);
            BlockPos startPos = structurePos.func_177981_b(((DungeonGuardedCastle)this.dungeon).getUnderGroundOffset()).func_177977_b();
            BlockPos endPos = startPos.func_177971_a((Vec3i)DungeonPlacement.transform(structure.getSize().func_177958_n() - 1, 0, structure.getSize().func_177952_p() - 1, mirror, rotation));
            BlockPos pos1 = DungeonGenUtils.getValidMinPos(startPos, endPos);
            BlockPos pos2 = DungeonGenUtils.getValidMaxPos(startPos, endPos);
            PlateauDungeonPart.Builder partBuilder = new PlateauDungeonPart.Builder(pos1.func_177958_n(), pos1.func_177952_p(), pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p(), CQRConfig.general.supportHillWallSize);
            partBuilder.setSupportHillBlock(((DungeonGuardedCastle)this.dungeon).getSupportBlock());
            partBuilder.setSupportHillTopBlock(((DungeonGuardedCastle)this.dungeon).getSupportTopBlock());
            this.dungeonBuilder.add(partBuilder);
        }
        this.toGenerate.put(position, structure);
        this.mirrorMap.put(position, mirror);
        this.rotationMap.put(position, rotation);
    }

    @Override
    public void preProcess() {
        int buildings = DungeonGenUtils.randomBetween(((DungeonGuardedCastle)this.dungeon).getMinBuildings(), ((DungeonGuardedCastle)this.dungeon).getMaxBuilding(), this.random);
        Double degrees = 360.0 / (double)buildings;
        File structure = ((DungeonGuardedCastle)this.dungeon).getStructureFileFromDirectory(((DungeonGuardedCastle)this.dungeon).getCenterStructureFolder(), this.random);
        BlockPos position = this.pos;
        for (int i = 0; i < buildings; ++i) {
            this.processStructure(this.loadStructureFromFile(structure), position);
            structure = ((DungeonGuardedCastle)this.dungeon).getStructureFileFromDirectory(((DungeonGuardedCastle)this.dungeon).getStructureFolder(), this.random);
            Vec3i v = new Vec3i(DungeonGenUtils.randomBetween(((DungeonGuardedCastle)this.dungeon).getMinDistance(), ((DungeonGuardedCastle)this.dungeon).getMaxDistance(), this.random), 0, 0);
            v = VectorUtil.rotateVectorAroundY(v, degrees * (double)i);
            position = this.pos.func_177971_a(v);
            position = new BlockPos(position.func_177958_n(), ((DungeonGuardedCastle)this.dungeon).getYForPos(this.getWorld(), position.func_177958_n(), position.func_177952_p(), this.random), position.func_177952_p());
        }
        this.processStructure(this.loadStructureFromFile(structure), position);
    }

    @Override
    public void buildStructure() {
        for (Map.Entry<BlockPos, CQStructure> entry : this.toGenerate.entrySet()) {
            CQStructure structure = entry.getValue();
            BlockPos structurePos = entry.getKey();
            structure.addAll(this.dungeonBuilder, structurePos, Offset.CENTER, this.mirrorMap.get(structurePos), this.rotationMap.get(structurePos));
        }
    }

    @Override
    public void postProcess() {
        if (((DungeonGuardedCastle)this.dungeon).isCoverBlockEnabled()) {
            for (Map.Entry<BlockPos, CQStructure> entry : this.toGenerate.entrySet()) {
                CQStructure structure = entry.getValue();
                BlockPos structurePos = entry.getKey();
                Mirror mirror = this.mirrorMap.get(structurePos);
                Rotation rotation = this.rotationMap.get(structurePos);
                BlockPos startPos = structurePos;
                BlockPos endPos = startPos.func_177971_a((Vec3i)DungeonPlacement.transform(structure.getSize().func_177958_n() - 1, 0, structure.getSize().func_177952_p() - 1, mirror, rotation));
                BlockPos pos1 = DungeonGenUtils.getValidMinPos(startPos, endPos);
                BlockPos pos2 = DungeonGenUtils.getValidMaxPos(startPos, endPos);
                this.dungeonBuilder.add(new CoverDungeonPart.Builder(pos1.func_177958_n(), pos1.func_177952_p(), pos2.func_177958_n(), pos2.func_177952_p(), ((DungeonGuardedCastle)this.dungeon).getCoverBlock()));
            }
        }
    }
}

