/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChunkData;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.world.structure.generation.dungeons.DungeonBase;
import team.cqr.cqrepoured.world.structure.generation.generation.ChunkInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.DungeonPlacement;
import team.cqr.cqrepoured.world.structure.generation.generation.part.IDungeonPart;
import team.cqr.cqrepoured.world.structure.generation.generation.part.IDungeonPartBuilder;
import team.cqr.cqrepoured.world.structure.generation.generation.part.IProtectable;
import team.cqr.cqrepoured.world.structure.generation.generation.util.BlockAddedUtil;
import team.cqr.cqrepoured.world.structure.generation.generation.util.BlockLightUtil;
import team.cqr.cqrepoured.world.structure.generation.generation.util.SkyLightUtil;
import team.cqr.cqrepoured.world.structure.generation.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.world.structure.generation.inhabitants.DungeonInhabitantManager;
import team.cqr.cqrepoured.world.structure.protection.IProtectedRegionManager;
import team.cqr.cqrepoured.world.structure.protection.ProtectedRegion;
import team.cqr.cqrepoured.world.structure.protection.ProtectedRegionManager;

public class GeneratableDungeon {
    private static final BlockPos.MutableBlockPos MUTABLE = new BlockPos.MutableBlockPos();
    private final String dungeonName;
    private final BlockPos pos;
    private final List<IDungeonPart> parts;
    private final ProtectedRegion.Builder protectedRegionBuilder;
    private final ChunkInfo.ChunkInfoMap chunkInfoMap;
    private final ChunkInfo.ChunkInfoMap chunkInfoMapExtended;
    private final List<LightInfo> removedLights = new ArrayList<LightInfo>();
    private final long[] generationTimes = new long[8];

    protected GeneratableDungeon(String dungeonName, BlockPos pos, Collection<IDungeonPart> parts, ProtectedRegion.Builder protectedRegionBuilder) {
        this.dungeonName = dungeonName;
        this.pos = pos;
        this.parts = new ArrayList<IDungeonPart>(parts);
        this.protectedRegionBuilder = protectedRegionBuilder;
        this.chunkInfoMap = new ChunkInfo.ChunkInfoMap();
        this.chunkInfoMapExtended = new ChunkInfo.ChunkInfoMap();
    }

    public void mark(int chunkX, int chunkY, int chunkZ) {
        this.chunkInfoMap.mark(chunkX, chunkY, chunkZ);
    }

    public void markRemovedLight(int x, int y, int z, int light) {
        this.markRemovedLight(new BlockPos(x, y, z), light);
    }

    public void markRemovedLight(BlockPos pos, int light) {
        this.removedLights.add(new LightInfo(pos, light));
    }

    public void generate(World world) {
        CQRMain.logger.info("Generating dungeon {} at {}", (Object)this.dungeonName, (Object)this.pos);
        long t = System.nanoTime();
        IProtectedRegionManager protectedRegionManager = ProtectedRegionManager.getInstance(world);
        ProtectedRegion protectedRegion = this.protectedRegionBuilder.build(world);
        if (protectedRegion != null) {
            protectedRegion.markDirty();
            protectedRegionManager.addProtectedRegion(protectedRegion);
        }
        this.tryGeneratePart(world);
        this.tryCheckBlockLight(world);
        this.tryGenerateSkylightMap(world);
        this.tryCheckSkyLight(world);
        this.tryCheckRemovedBlockLight(world);
        this.tryMarkBlockForUpdate(world);
        this.tryNotifyNeighboursRespectDebug(world);
        this.generationTimes[0] = System.nanoTime() - t;
        CQRMain.logger.info("Generated dungeon {} at {}", (Object)this.dungeonName, (Object)this.pos);
        CQRMain.logger.debug("Total: {} secs {} millis", (Object)(this.generationTimes[0] / 1000000000L), (Object)(this.generationTimes[0] / 1000000L % 1000L));
        CQRMain.logger.debug("Parts: {} secs {} millis", (Object)(this.generationTimes[1] / 1000000000L), (Object)(this.generationTimes[1] / 1000000L % 1000L));
        CQRMain.logger.debug("Blocklight: {} secs {} millis", (Object)(this.generationTimes[2] / 1000000000L), (Object)(this.generationTimes[2] / 1000000L % 1000L));
        CQRMain.logger.debug("SkylightMap: {} secs {} millis", (Object)(this.generationTimes[3] / 1000000000L), (Object)(this.generationTimes[3] / 1000000L % 1000L));
        CQRMain.logger.debug("Skylight: {} secs {} millis", (Object)(this.generationTimes[4] / 1000000000L), (Object)(this.generationTimes[4] / 1000000L % 1000L));
        CQRMain.logger.debug("RemovedBlocklight: {} secs {} millis", (Object)(this.generationTimes[5] / 1000000000L), (Object)(this.generationTimes[5] / 1000000L % 1000L));
        CQRMain.logger.debug("Sync: {} secs {} millis", (Object)(this.generationTimes[6] / 1000000000L), (Object)(this.generationTimes[6] / 1000000L % 1000L));
        CQRMain.logger.debug("Updates: {} secs {} millis", (Object)(this.generationTimes[7] / 1000000000L), (Object)(this.generationTimes[7] / 1000000L % 1000L));
    }

    private void tryGeneratePart(World world) {
        long t = System.nanoTime();
        for (IDungeonPart part : this.parts) {
            part.generate(world, this);
        }
        for (ChunkInfo chunkInfo : this.chunkInfoMap.values()) {
            Chunk chunk = world.func_72964_e(chunkInfo.getChunkX(), chunkInfo.getChunkZ());
            if (world.field_73011_w.func_191066_m()) {
                for (int chunkY2 = chunkInfo.topMarked(); chunkY2 >= 0; --chunkY2) {
                    ExtendedBlockStorage blockStorage = chunk.func_76587_i()[chunkY2];
                    if (blockStorage == Chunk.field_186036_a) {
                        chunk.func_76587_i()[chunkY2] = blockStorage = new ExtendedBlockStorage(chunkY2 << 4, true);
                    }
                    Arrays.fill(blockStorage.func_76671_l().func_177481_a(), (byte)0);
                }
            }
            chunkInfo.forEach(chunkY -> {
                ExtendedBlockStorage blockStorage = chunk.func_76587_i()[chunkY];
                if (blockStorage != Chunk.field_186036_a) {
                    Arrays.fill(blockStorage.func_76661_k().func_177481_a(), (byte)0);
                }
                int r = 1;
                for (int x = -r; x <= r; ++x) {
                    for (int y = -r; y <= r; ++y) {
                        for (int z = -r; z <= r; ++z) {
                            this.chunkInfoMapExtended.mark(chunkInfo.getChunkX() + x, chunkY + y, chunkInfo.getChunkZ() + z);
                        }
                    }
                }
            });
        }
        this.generationTimes[1] = this.generationTimes[1] + (System.nanoTime() - t);
    }

    private void tryCheckBlockLight(World world) {
        long t = System.nanoTime();
        for (ChunkInfo chunkInfo : this.chunkInfoMapExtended.values()) {
            BlockLightUtil.checkBlockLight(world, chunkInfo);
        }
        this.generationTimes[2] = this.generationTimes[2] + (System.nanoTime() - t);
    }

    private void tryGenerateSkylightMap(World world) {
        long t = System.nanoTime();
        for (ChunkInfo chunkInfo : this.chunkInfoMap.values()) {
            Chunk chunk = world.func_72964_e(chunkInfo.getChunkX(), chunkInfo.getChunkZ());
            chunk.func_76603_b();
        }
        this.generationTimes[3] = this.generationTimes[3] + (System.nanoTime() - t);
    }

    private void tryCheckSkyLight(World world) {
        long t = System.nanoTime();
        for (ChunkInfo chunkInfo : this.chunkInfoMapExtended.values()) {
            SkyLightUtil.checkSkyLight(world, chunkInfo);
        }
        this.generationTimes[4] = this.generationTimes[4] + (System.nanoTime() - t);
    }

    private void tryCheckRemovedBlockLight(World world) {
        long t = System.nanoTime();
        HashSet<BlockPos> updated = new HashSet<BlockPos>();
        for (LightInfo removedLight : this.removedLights) {
            int r = removedLight.light - 1;
            for (int y = -r; y <= r; ++y) {
                if (world.func_189509_E((BlockPos)MUTABLE.func_181079_c(0, removedLight.pos.func_177956_o() + y, 0))) continue;
                for (int x = -r; x <= r; ++x) {
                    for (int z = -r; z <= r; ++z) {
                        BlockPos p = new BlockPos((Vec3i)removedLight.pos.func_177982_a(x, y, z));
                        if (!updated.add(p)) continue;
                        world.func_180500_c(EnumSkyBlock.BLOCK, p);
                    }
                }
            }
        }
        this.generationTimes[5] = this.generationTimes[5] + (System.nanoTime() - t);
    }

    private void tryMarkBlockForUpdate(World world) {
        long t = System.nanoTime();
        for (ChunkInfo chunkInfo : this.chunkInfoMapExtended.values()) {
            PlayerChunkMapEntry entry;
            Chunk chunk = world.func_72863_F().func_186026_b(chunkInfo.getChunkX(), chunkInfo.getChunkZ());
            if (chunk == null || (entry = ((WorldServer)world).func_184164_w().func_187301_b(chunkInfo.getChunkX(), chunkInfo.getChunkZ())) == null) continue;
            entry.func_187267_a((Packet)new SPacketChunkData(chunk, 65535 >> 15 - chunkInfo.topMarked()));
        }
        this.generationTimes[6] = this.generationTimes[6] + (System.nanoTime() - t);
    }

    private void tryNotifyNeighboursRespectDebug(World world) {
        long t = System.nanoTime();
        for (ChunkInfo chunkInfo : this.chunkInfoMap.values()) {
            BlockAddedUtil.onBlockAdded(world, chunkInfo);
        }
        this.generationTimes[7] = this.generationTimes[7] + (System.nanoTime() - t);
    }

    public String getDungeonName() {
        return this.dungeonName;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public static class Builder {
        private final String dungeonName;
        private final BlockPos pos;
        private final DungeonInhabitant defaultInhabitant;
        private final ProtectedRegion.Builder protectedRegionBuilder;
        private final List<Function<World, IDungeonPart>> partBuilders = new ArrayList<Function<World, IDungeonPart>>();

        public Builder(World world, BlockPos pos, DungeonBase dungeonConfig) {
            this.dungeonName = dungeonConfig.getDungeonName();
            this.pos = pos;
            this.defaultInhabitant = DungeonInhabitantManager.instance().getInhabitantByDistanceIfDefault(dungeonConfig.getDungeonMob(), world, pos.func_177958_n(), pos.func_177952_p());
            this.protectedRegionBuilder = new ProtectedRegion.Builder(dungeonConfig, pos);
        }

        public Builder(World world, BlockPos pos, String dungeonName, String defaultnhabitant) {
            this.dungeonName = dungeonName;
            this.pos = pos;
            this.defaultInhabitant = DungeonInhabitantManager.instance().getInhabitantByDistanceIfDefault(defaultnhabitant, world, pos.func_177958_n(), pos.func_177952_p());
            this.protectedRegionBuilder = new ProtectedRegion.Builder(dungeonName, pos);
        }

        public GeneratableDungeon build(World world) {
            List<IDungeonPart> parts = this.partBuilders.stream().map(builder -> (IDungeonPart)builder.apply(world)).filter(Objects::nonNull).collect(Collectors.toList());
            parts.stream().filter(IProtectable.class::isInstance).map(IProtectable.class::cast).forEach(part -> {
                this.protectedRegionBuilder.updateMin(part.minPos());
                this.protectedRegionBuilder.updateMax(part.maxPos());
            });
            return new GeneratableDungeon(this.dungeonName, this.pos, parts, this.protectedRegionBuilder);
        }

        public void add(IDungeonPartBuilder partBuilder) {
            this.add(partBuilder, this.getPlacement(this.pos, this.defaultInhabitant));
        }

        public void add(IDungeonPartBuilder partBuilder, BlockPos partPos) {
            this.add(partBuilder, this.getPlacement(partPos));
        }

        public void add(IDungeonPartBuilder partBuilder, BlockPos partPos, Mirror mirror, Rotation rotation) {
            this.add(partBuilder, this.getPlacement(partPos, mirror, rotation));
        }

        public void add(IDungeonPartBuilder partBuilder, BlockPos partPos, DungeonInhabitant inhabitant) {
            this.add(partBuilder, this.getPlacement(partPos, inhabitant));
        }

        public void add(IDungeonPartBuilder partBuilder, BlockPos partPos, Mirror mirror, Rotation rotation, DungeonInhabitant inhabitant) {
            this.add(partBuilder, this.getPlacement(partPos, mirror, rotation, inhabitant));
        }

        public void add(IDungeonPartBuilder partBuilder, DungeonPlacement placement) {
            this.partBuilders.add(world1 -> partBuilder.build((World)world1, placement));
        }

        public void addAll(Collection<IDungeonPartBuilder> partBuilders) {
            partBuilders.forEach(this::add);
        }

        public DungeonPlacement getPlacement(BlockPos partPos) {
            return this.getPlacement(partPos, Mirror.NONE, Rotation.NONE, this.defaultInhabitant);
        }

        public DungeonPlacement getPlacement(BlockPos partPos, Mirror mirror, Rotation rotation) {
            return this.getPlacement(partPos, mirror, rotation, this.defaultInhabitant);
        }

        public DungeonPlacement getPlacement(BlockPos partPos, DungeonInhabitant inhabitant) {
            return this.getPlacement(partPos, Mirror.NONE, Rotation.NONE, inhabitant);
        }

        public DungeonPlacement getPlacement(BlockPos partPos, Mirror mirror, Rotation rotation, DungeonInhabitant inhabitant) {
            return new DungeonPlacement(this.pos, partPos, mirror, rotation, inhabitant, this.protectedRegionBuilder);
        }
    }

    private static class LightInfo {
        public final BlockPos pos;
        public final int light;

        public LightInfo(BlockPos pos, int light) {
            this.pos = pos.func_185334_h();
            this.light = light;
        }
    }
}

