/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generation;

import net.minecraft.entity.Entity;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import team.cqr.cqrepoured.world.structure.generation.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.world.structure.protection.ProtectedRegion;

public class DungeonPlacement {
    private static final ThreadLocal<BlockPos.MutableBlockPos> LOCAL_MUTABLE_BLOCKPOS = ThreadLocal.withInitial(BlockPos.MutableBlockPos::new);
    private static final ThreadLocal<MutableVec3d> LOCAL_MUTABLE_VEC3D = ThreadLocal.withInitial(MutableVec3d::new);
    private final BlockPos pos;
    private final BlockPos partPos;
    private final Mirror mirror;
    private final Rotation rotation;
    private final DungeonInhabitant inhabitant;
    private final ProtectedRegion.Builder protectedRegionBuilder;

    public DungeonPlacement(BlockPos pos, BlockPos partPos, Mirror mirror, Rotation rotation, DungeonInhabitant inhabitant, ProtectedRegion.Builder protectedRegionBuilder) {
        this.pos = pos;
        this.partPos = partPos;
        this.mirror = mirror;
        this.rotation = rotation;
        this.inhabitant = inhabitant;
        this.protectedRegionBuilder = protectedRegionBuilder;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public BlockPos getPartPos() {
        return this.partPos;
    }

    public Mirror getMirror() {
        return this.mirror;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public DungeonInhabitant getInhabitant() {
        return this.inhabitant;
    }

    public ProtectedRegion.Builder getProtectedRegionBuilder() {
        return this.protectedRegionBuilder;
    }

    public BlockPos.MutableBlockPos transform(BlockPos pos) {
        return DungeonPlacement.transform(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), this.partPos, this.mirror, this.rotation);
    }

    public BlockPos.MutableBlockPos transform(int x, int y, int z) {
        return DungeonPlacement.transform(x, y, z, this.partPos, this.mirror, this.rotation);
    }

    public static BlockPos.MutableBlockPos transform(BlockPos pos, Mirror mirror, Rotation rotation) {
        return DungeonPlacement.transform(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), BlockPos.field_177992_a, mirror, rotation);
    }

    public static BlockPos.MutableBlockPos transform(int x, int y, int z, Mirror mirror, Rotation rotation) {
        return DungeonPlacement.transform(x, y, z, BlockPos.field_177992_a, mirror, rotation);
    }

    public static BlockPos.MutableBlockPos transform(BlockPos pos, BlockPos origin, Mirror mirror, Rotation rotation) {
        return DungeonPlacement.transform(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), origin, mirror, rotation);
    }

    public static BlockPos.MutableBlockPos transform(int x, int y, int z, BlockPos origin, Mirror mirror, Rotation rotation) {
        switch (mirror) {
            case LEFT_RIGHT: {
                z = -z;
                break;
            }
            case FRONT_BACK: {
                x = -x;
                break;
            }
        }
        switch (rotation) {
            case COUNTERCLOCKWISE_90: {
                return LOCAL_MUTABLE_BLOCKPOS.get().func_181079_c(origin.func_177958_n() + z, origin.func_177956_o() + y, origin.func_177952_p() - x);
            }
            case CLOCKWISE_90: {
                return LOCAL_MUTABLE_BLOCKPOS.get().func_181079_c(origin.func_177958_n() - z, origin.func_177956_o() + y, origin.func_177952_p() + x);
            }
            case CLOCKWISE_180: {
                return LOCAL_MUTABLE_BLOCKPOS.get().func_181079_c(origin.func_177958_n() - x, origin.func_177956_o() + y, origin.func_177952_p() - z);
            }
        }
        return LOCAL_MUTABLE_BLOCKPOS.get().func_181079_c(origin.func_177958_n() + x, origin.func_177956_o() + y, origin.func_177952_p() + z);
    }

    public MutableVec3d transform(Vec3d vec) {
        return DungeonPlacement.transform(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, this.partPos, this.mirror, this.rotation);
    }

    public MutableVec3d transform(double x, double y, double z) {
        return DungeonPlacement.transform(x, y, z, this.partPos, this.mirror, this.rotation);
    }

    public static MutableVec3d transform(Vec3d vec, Mirror mirror, Rotation rotation) {
        return DungeonPlacement.transform(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, BlockPos.field_177992_a, mirror, rotation);
    }

    public static MutableVec3d transform(double x, double y, double z, Mirror mirror, Rotation rotation) {
        return DungeonPlacement.transform(x, y, z, BlockPos.field_177992_a, mirror, rotation);
    }

    public static MutableVec3d transform(Vec3d vec, BlockPos origin, Mirror mirror, Rotation rotation) {
        return DungeonPlacement.transform(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, origin, mirror, rotation);
    }

    public static MutableVec3d transform(double x, double y, double z, BlockPos origin, Mirror mirror, Rotation rotation) {
        switch (mirror) {
            case LEFT_RIGHT: {
                z = 1.0 - z;
                break;
            }
            case FRONT_BACK: {
                x = 1.0 - x;
                break;
            }
        }
        switch (rotation) {
            case COUNTERCLOCKWISE_90: {
                return LOCAL_MUTABLE_VEC3D.get().set((double)origin.func_177958_n() + z, (double)origin.func_177956_o() + y, (double)origin.func_177952_p() + 1.0 - x);
            }
            case CLOCKWISE_90: {
                return LOCAL_MUTABLE_VEC3D.get().set((double)origin.func_177958_n() + 1.0 - z, (double)origin.func_177956_o() + y, (double)origin.func_177952_p() + x);
            }
            case CLOCKWISE_180: {
                return LOCAL_MUTABLE_VEC3D.get().set((double)origin.func_177958_n() + 1.0 - x, (double)origin.func_177956_o() + y, (double)origin.func_177952_p() + 1.0 - z);
            }
        }
        return LOCAL_MUTABLE_VEC3D.get().set((double)origin.func_177958_n() + x, (double)origin.func_177956_o() + y, (double)origin.func_177952_p() + z);
    }

    public float transform(Entity entity) {
        return DungeonPlacement.transform(entity, this.mirror, this.rotation);
    }

    public static float transform(Entity entity, Mirror mirror, Rotation rotation) {
        return entity.field_70177_z + entity.func_184217_a(mirror) - entity.func_184229_a(rotation);
    }

    public static class MutableVec3d {
        public double x;
        public double y;
        public double z;

        public MutableVec3d() {
        }

        public MutableVec3d(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public MutableVec3d set(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
            return this;
        }
    }
}

