/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world;

import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class ChunkCacheCQR
extends ChunkCache {
    private static double oldX = 0.0;
    private static double oldZ = 0.0;
    private static double oldLength = 0.0;

    public ChunkCacheCQR(World worldIn, BlockPos pos1, BlockPos pos2, BlockPos pos3, boolean loadChunks) {
        super(worldIn, pos3, pos3, 0);
        this.field_72818_a = Math.min(pos1.func_177958_n() >> 4, pos3.func_177958_n() >> 4);
        this.field_72816_b = Math.min(pos1.func_177952_p() >> 4, pos3.func_177952_p() >> 4);
        int chunkX2 = Math.max(pos2.func_177958_n() >> 4, pos3.func_177958_n() >> 4);
        int chunkZ2 = Math.max(pos2.func_177952_p() >> 4, pos3.func_177952_p() >> 4);
        int y1 = Math.min(pos1.func_177956_o(), pos3.func_177956_o());
        int y2 = Math.max(pos2.func_177956_o(), pos3.func_177956_o());
        this.field_72817_c = new Chunk[chunkX2 - this.field_72818_a + 1][chunkZ2 - this.field_72816_b + 1];
        for (int x = this.field_72818_a; x <= chunkX2; ++x) {
            for (int z = this.field_72816_b; z <= chunkZ2; ++z) {
                Chunk chunk;
                this.field_72817_c[x - this.field_72818_a][z - this.field_72816_b] = chunk = loadChunks ? worldIn.func_72964_e(x, z) : worldIn.func_72863_F().func_186026_b(x, z);
                if (!this.field_72814_d || chunk == null || chunk.func_76606_c(y1, y2)) continue;
                this.field_72814_d = false;
            }
        }
    }

    public ChunkCacheCQR(World worldIn, BlockPos pos1, BlockPos pos2, BlockPos pos3, int blockRange, boolean loadChunks) {
        super(worldIn, pos3, pos3, 0);
        this.field_72818_a = Math.min(pos1.func_177958_n(), pos2.func_177958_n()) - blockRange >> 4;
        this.field_72816_b = Math.min(pos1.func_177952_p(), pos2.func_177952_p()) - blockRange >> 4;
        int chunkX2 = Math.max(pos1.func_177958_n(), pos2.func_177958_n()) + blockRange >> 4;
        int chunkZ2 = Math.max(pos1.func_177952_p(), pos2.func_177952_p()) + blockRange >> 4;
        int y1 = Math.min(pos1.func_177956_o(), pos2.func_177956_o());
        int y2 = Math.max(pos1.func_177956_o(), pos2.func_177956_o());
        this.field_72817_c = new Chunk[chunkX2 - this.field_72818_a + 1][chunkZ2 - this.field_72816_b + 1];
        double lineStartX = (double)pos1.func_177958_n() + 0.5;
        double lineStartZ = (double)pos1.func_177952_p() + 0.5;
        double lineDirectionX = pos2.func_177958_n() - pos1.func_177958_n();
        double lineDirectionZ = pos2.func_177952_p() - pos1.func_177952_p();
        for (int x = this.field_72818_a; x <= chunkX2; ++x) {
            for (int z = this.field_72816_b; z <= chunkZ2; ++z) {
                Chunk chunk;
                if (!ChunkCacheCQR.isChunkCornerInRangeToLine(lineStartX, lineStartZ, lineDirectionX, lineDirectionZ, x << 4, z << 4, blockRange)) continue;
                this.field_72817_c[x - this.field_72818_a][z - this.field_72816_b] = chunk = loadChunks ? worldIn.func_72964_e(x, z) : worldIn.func_72863_F().func_186026_b(x, z);
                if (!this.field_72814_d || chunk == null || chunk.func_76606_c(y1, y2)) continue;
                this.field_72814_d = false;
            }
        }
    }

    private static boolean isChunkCornerInRangeToLine(double lineStartX, double lineStartZ, double lineDirectionX, double lineDirectionZ, int x, int z, double range) {
        if (ChunkCacheCQR.getDistanceFromPointToLine2D(lineStartX, lineStartZ, lineDirectionX, lineDirectionZ, x, z) <= range) {
            return true;
        }
        if (ChunkCacheCQR.getDistanceFromPointToLine2D(lineStartX, lineStartZ, lineDirectionX, lineDirectionZ, (double)x + 16.0, z) <= range) {
            return true;
        }
        if (ChunkCacheCQR.getDistanceFromPointToLine2D(lineStartX, lineStartZ, lineDirectionX, lineDirectionZ, x, (double)z + 16.0) <= range) {
            return true;
        }
        return ChunkCacheCQR.getDistanceFromPointToLine2D(lineStartX, lineStartZ, lineDirectionX, lineDirectionZ, (double)x + 16.0, (double)z + 16.0) <= range;
    }

    private static double getDistanceFromPointToLine2D(double lineStartX, double lineStartZ, double lineDirectionX, double lineDirectionZ, double x, double z) {
        if (lineDirectionX != oldX || lineDirectionZ != oldZ) {
            oldX = lineDirectionX;
            oldZ = lineDirectionZ;
            oldLength = Math.sqrt(lineDirectionX * lineDirectionX + lineDirectionZ * lineDirectionZ);
        }
        return ((lineStartX - x) * lineDirectionX - (lineStartZ - z) * lineDirectionZ) / oldLength;
    }
}

