/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.util;

import java.util.Random;
import net.minecraft.util.math.MathHelper;

public class Perlin3D {
    private final Random rand = new Random();
    private final long seed;
    private final float tanSeed;
    private final float frequency;

    public Perlin3D(long seed, int octave) {
        this.seed = seed;
        this.frequency = octave;
        this.tanSeed = (float)Math.tan(this.seed);
    }

    public float getNoiseAt(float x, float y, float z) {
        float fx1 = x / this.frequency;
        float xmin = MathHelper.func_76141_d((float)fx1);
        float xmax = xmin + 1.0f;
        float fx2 = fx1 - xmin;
        float fy1 = y / this.frequency;
        float ymin = MathHelper.func_76141_d((float)fy1);
        float ymax = ymin + 1.0f;
        float fy2 = fy1 - ymin;
        float fz1 = z / this.frequency;
        float zmin = MathHelper.func_76141_d((float)fz1);
        float zmax = zmin + 1.0f;
        float fz2 = fz1 - zmin;
        float f1 = this.getRandomAtPosition(xmin, ymin, zmin);
        float f2 = this.getRandomAtPosition(xmin, ymin, zmax);
        float f3 = this.getRandomAtPosition(xmin, ymax, zmin);
        float f4 = this.getRandomAtPosition(xmin, ymax, zmax);
        float f5 = this.getRandomAtPosition(xmax, ymin, zmin);
        float f6 = this.getRandomAtPosition(xmax, ymin, zmax);
        float f7 = this.getRandomAtPosition(xmax, ymax, zmin);
        float f8 = this.getRandomAtPosition(xmax, ymax, zmax);
        float f11 = this.cosineInterpolate(f1, f5, fx2);
        float f12 = this.cosineInterpolate(f2, f6, fx2);
        float f13 = this.cosineInterpolate(f3, f7, fx2);
        float f14 = this.cosineInterpolate(f4, f8, fx2);
        float f21 = this.cosineInterpolate(f11, f12, fz2);
        float f22 = this.cosineInterpolate(f13, f14, fz2);
        return this.cosineInterpolate(f21, f22, fy2);
    }

    private float cosineInterpolate(float a, float b, float x) {
        float d = (1.0f - MathHelper.func_76134_b((float)(x * (float)Math.PI))) * 0.5f;
        return a * (1.0f - d) + b * d;
    }

    private float linearInterpolate(float a, float b, float x) {
        return a * (1.0f - x) + b * x;
    }

    private float getRandomAtPosition(float x, float y, float z) {
        long newSeed = (long)((MathHelper.func_76126_a((float)x) + MathHelper.func_76134_b((float)z) + MathHelper.func_76134_b((float)y) + this.tanSeed) * 10000.0f);
        this.rand.setSeed(newSeed);
        return this.rand.nextFloat();
    }
}

