/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.util;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.util.BlockSnapshot;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.world.structure.generation.generation.GeneratableDungeon;

public class BlockPlacingHelper {
    private static final BlockPos.MutableBlockPos MUTABLE = new BlockPos.MutableBlockPos();

    public static boolean setBlockStates(World world, int chunkX, int chunkY, int chunkZ, GeneratableDungeon dungeon, IBlockInfo blockInfo) {
        if (world.func_189509_E((BlockPos)MUTABLE.func_181079_c(chunkX << 4, chunkY << 4, chunkZ << 4))) {
            return false;
        }
        if (!world.field_72995_K && world.func_72912_H().func_76067_t() == WorldType.field_180272_g) {
            return false;
        }
        Chunk chunk = world.func_72964_e(chunkX, chunkZ);
        ExtendedBlockStorage blockStorage = chunk.func_76587_i()[chunkY];
        if (blockStorage == Chunk.field_186036_a) {
            chunk.func_76587_i()[chunkY] = blockStorage = new ExtendedBlockStorage(chunkY << 4, world.field_73011_w.func_191066_m());
            if (!blockInfo.place(world, chunk, blockStorage, dungeon)) {
                chunk.func_76587_i()[chunkY] = null;
                return false;
            }
            return true;
        }
        return blockInfo.place(world, chunk, blockStorage, dungeon);
    }

    public static boolean setBlockState(World world, BlockPos pos, IBlockState state, @Nullable TileEntity tileEntity, int flags, boolean updateLight) {
        if (CQRMain.isPhosphorInstalled || CQRConfig.advanced.instantLightUpdates || updateLight) {
            if (!world.func_180501_a(pos, state, flags)) {
                return false;
            }
            if (tileEntity != null) {
                world.func_175690_a(pos, tileEntity);
                tileEntity.func_145836_u();
            }
            return true;
        }
        if (world.func_189509_E(pos)) {
            return false;
        }
        if (!world.field_72995_K && world.func_72912_H().func_76067_t() == WorldType.field_180272_g) {
            return false;
        }
        Chunk chunk = world.func_175726_f(pos);
        ExtendedBlockStorage blockStorage = chunk.func_76587_i()[pos.func_177956_o() >> 4];
        if (blockStorage == Chunk.field_186036_a) {
            if (state == Blocks.field_150350_a.func_176223_P()) {
                return false;
            }
            chunk.func_76587_i()[pos.func_177956_o() >> 4] = blockStorage = new ExtendedBlockStorage(pos.func_177956_o() >> 4 << 4, world.field_73011_w.func_191066_m());
        }
        return BlockPlacingHelper.setBlockState(world, chunk, blockStorage, pos, state, tileEntity, flags);
    }

    public static boolean setBlockState(World world, Chunk chunk, ExtendedBlockStorage blockStorage, BlockPos pos, IBlockState state, @Nullable TileEntity tileEntity, int flags) {
        IBlockState oldState = BlockPlacingHelper.setBlockState(world, chunk, blockStorage, pos, state, tileEntity);
        if (oldState == null) {
            return false;
        }
        if (!world.field_72995_K && world.captureBlockSnapshots) {
            world.capturedBlockSnapshots.add(new BlockSnapshot(world, pos.func_185334_h(), oldState, flags));
        } else {
            world.markAndNotifyBlock(pos, chunk, oldState, state, flags);
        }
        return true;
    }

    @Nullable
    private static IBlockState setBlockState(World world, Chunk chunk, ExtendedBlockStorage blockStorage, BlockPos pos, IBlockState state, @Nullable TileEntity tileEntity) {
        TileEntity te;
        int z;
        int y;
        int x = pos.func_177958_n() & 0xF;
        IBlockState oldState = BlockPlacingHelper.setBlockState(blockStorage, x, y = pos.func_177956_o() & 0xF, z = pos.func_177952_p() & 0xF, state);
        if (oldState == null) {
            return null;
        }
        int l = z << 4 | x;
        if (pos.func_177956_o() >= chunk.field_76638_b[l] - 1) {
            chunk.field_76638_b[l] = -999;
        }
        Block block = state.func_177230_c();
        Block oldBlock = oldState.func_177230_c();
        if (!world.field_72995_K && oldBlock != block) {
            oldBlock.func_180663_b(world, pos, oldState);
        }
        if (oldBlock.hasTileEntity(oldState) && (te = chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK)) != null && te.shouldRefresh(world, pos, oldState, state)) {
            world.func_175713_t(pos);
        }
        if (world.field_72995_K || block == oldBlock || !world.captureBlockSnapshots || block.hasTileEntity(state)) {
            // empty if block
        }
        if (block.hasTileEntity(state)) {
            if (tileEntity != null) {
                world.func_175690_a(pos, tileEntity);
                tileEntity.func_145836_u();
            } else {
                te = chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
                if (te == null) {
                    te = block.createTileEntity(world, state);
                    world.func_175690_a(pos, te);
                }
                if (te != null) {
                    te.func_145836_u();
                }
            }
        }
        chunk.func_76630_e();
        return oldState;
    }

    @Nullable
    private static IBlockState setBlockState(ExtendedBlockStorage blockStorage, int x, int y, int z, IBlockState state) {
        IBlockState oldState;
        if (state instanceof IExtendedBlockState) {
            state = ((IExtendedBlockState)state).getClean();
        }
        if (state == (oldState = blockStorage.func_186049_g().func_186016_a(x, y, z))) {
            return null;
        }
        Block block = state.func_177230_c();
        Block oldBlock = oldState.func_177230_c();
        if (oldBlock != Blocks.field_150350_a) {
            --blockStorage.field_76682_b;
            if (oldBlock.func_149653_t()) {
                --blockStorage.field_76683_c;
            }
        }
        if (block != Blocks.field_150350_a) {
            ++blockStorage.field_76682_b;
            if (block.func_149653_t()) {
                ++blockStorage.field_76683_c;
            }
        }
        blockStorage.func_186049_g().func_186013_a(x, y, z, state);
        return oldState;
    }

    @FunctionalInterface
    public static interface IBlockInfo {
        public boolean place(World var1, Chunk var2, ExtendedBlockStorage var3, GeneratableDungeon var4);
    }
}

