/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.tileentity;

import io.netty.buffer.ByteBuf;
import java.io.File;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.network.client.packet.CPacketSaveStructureRequest;
import team.cqr.cqrepoured.network.datasync.DataEntryBoolean;
import team.cqr.cqrepoured.network.datasync.DataEntryInt;
import team.cqr.cqrepoured.network.datasync.DataEntryObject;
import team.cqr.cqrepoured.network.datasync.DataEntryString;
import team.cqr.cqrepoured.network.datasync.TileEntityDataManager;
import team.cqr.cqrepoured.tileentity.ITileEntitySyncable;
import team.cqr.cqrepoured.util.ByteBufUtil;
import team.cqr.cqrepoured.world.structure.generation.structurefile.CQStructure;

public class TileEntityExporter
extends TileEntity
implements ITileEntitySyncable {
    private final TileEntityDataManager dataManager = new TileEntityDataManager(this);
    private final DataEntryString structureName = new DataEntryString("StructureName", "NoName", true);
    private final DataEntryInt startX = new DataEntryInt("StartX", 0, true){

        @Override
        protected void onValueChanged() {
            super.onValueChanged();
            TileEntityExporter.this.onPositionsChanged();
        }
    };
    private final DataEntryInt startY = new DataEntryInt("StartY", 0, true){

        @Override
        protected void onValueChanged() {
            super.onValueChanged();
            TileEntityExporter.this.onPositionsChanged();
        }
    };
    private final DataEntryInt startZ = new DataEntryInt("StartZ", 0, true){

        @Override
        protected void onValueChanged() {
            super.onValueChanged();
            TileEntityExporter.this.onPositionsChanged();
        }
    };
    private final DataEntryInt endX = new DataEntryInt("EndX", 0, true){

        @Override
        protected void onValueChanged() {
            super.onValueChanged();
            TileEntityExporter.this.onPositionsChanged();
        }
    };
    private final DataEntryInt endY = new DataEntryInt("EndY", 0, true){

        @Override
        protected void onValueChanged() {
            super.onValueChanged();
            TileEntityExporter.this.onPositionsChanged();
        }
    };
    private final DataEntryInt endZ = new DataEntryInt("EndZ", 0, true){

        @Override
        protected void onValueChanged() {
            super.onValueChanged();
            TileEntityExporter.this.onPositionsChanged();
        }
    };
    private final DataEntryBoolean relativeMode = new DataEntryBoolean("RelativeMode", true, true){

        @Override
        protected void onValueChanged() {
            super.onValueChanged();
            TileEntityExporter.this.onPositionsChanged();
        }
    };
    private final DataEntryBoolean ignoreEntities = new DataEntryBoolean("IgnoreEntities", true, true){

        @Override
        protected void onValueChanged() {
            super.onValueChanged();
            TileEntityExporter.this.onPositionsChanged();
        }
    };
    private final DataEntryObject<BlockPos[]> unprotectedBlocks = new DataEntryObject<BlockPos[]>("UnprotectedBlocks", new BlockPos[0], true){

        @Override
        public NBTBase write() {
            int[] data = new int[((BlockPos[])this.value).length * 3];
            for (int i = 0; i < ((BlockPos[])this.value).length; ++i) {
                data[i * 3] = ((BlockPos[])this.value)[i].func_177958_n();
                data[i * 3 + 1] = ((BlockPos[])this.value)[i].func_177956_o();
                data[i * 3 + 2] = ((BlockPos[])this.value)[i].func_177952_p();
            }
            return new NBTTagIntArray(data);
        }

        @Override
        protected void readInternal(NBTBase nbt) {
            if (nbt instanceof NBTTagIntArray) {
                int[] data = ((NBTTagIntArray)nbt).func_150302_c();
                this.value = new BlockPos[data.length / 3];
                for (int i = 0; i < ((BlockPos[])this.value).length; ++i) {
                    ((BlockPos[])this.value)[i] = new BlockPos(data[i * 3], data[i * 3 + 1], data[i * 3 + 2]);
                }
            }
        }

        @Override
        public void writeChanges(ByteBuf buf) {
            buf.writeInt(((BlockPos[])this.value).length);
            for (BlockPos pos : (BlockPos[])this.value) {
                ByteBufUtil.writeBlockPos(buf, pos);
            }
        }

        @Override
        protected void readChangesInternal(ByteBuf buf) {
            this.value = new BlockPos[buf.readInt()];
            for (int i = 0; i < ((BlockPos[])this.value).length; ++i) {
                ((BlockPos[])this.value)[i] = ByteBufUtil.readBlockPos(buf);
            }
        }
    };
    private final BlockPos.MutableBlockPos minPos = new BlockPos.MutableBlockPos();
    private final BlockPos.MutableBlockPos maxPos = new BlockPos.MutableBlockPos();
    private final BlockPos.MutableBlockPos minPosRelative = new BlockPos.MutableBlockPos();
    private final BlockPos.MutableBlockPos maxPosRelative = new BlockPos.MutableBlockPos();

    public TileEntityExporter() {
        this.dataManager.register(this.structureName);
        this.dataManager.register(this.startX);
        this.dataManager.register(this.startY);
        this.dataManager.register(this.startZ);
        this.dataManager.register(this.endX);
        this.dataManager.register(this.endY);
        this.dataManager.register(this.endZ);
        this.dataManager.register(this.relativeMode);
        this.dataManager.register(this.ignoreEntities);
        this.dataManager.register(this.unprotectedBlocks);
    }

    @Override
    public TileEntityDataManager getDataManager() {
        return this.dataManager;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.dataManager.write(compound);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.dataManager.read(compound);
        this.onPositionsChanged();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.dataManager.write(new NBTTagCompound()));
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.dataManager.read(pkt.func_148857_g());
        this.onPositionsChanged();
    }

    public void func_174878_a(BlockPos posIn) {
        boolean flag = !this.field_174879_c.equals((Object)posIn);
        super.func_174878_a(posIn);
        if (flag) {
            this.onPositionsChanged();
        }
    }

    private void onPositionsChanged() {
        int x1 = Math.min(this.startX.getInt(), this.endX.getInt());
        int y1 = Math.min(this.startY.getInt(), this.endY.getInt());
        int z1 = Math.min(this.startZ.getInt(), this.endZ.getInt());
        int x2 = Math.max(this.startX.getInt(), this.endX.getInt());
        int y2 = Math.max(this.startY.getInt(), this.endY.getInt());
        int z2 = Math.max(this.startZ.getInt(), this.endZ.getInt());
        if (this.relativeMode.getBoolean()) {
            this.minPosRelative.func_181079_c(x1, y1, z1);
            this.maxPosRelative.func_181079_c(x2, y2, z2);
            this.minPos.func_181079_c(x1 += this.field_174879_c.func_177958_n(), y1 += this.field_174879_c.func_177956_o(), z1 += this.field_174879_c.func_177952_p());
            this.maxPos.func_181079_c(x2 += this.field_174879_c.func_177958_n(), y2 += this.field_174879_c.func_177956_o(), z2 += this.field_174879_c.func_177952_p());
        } else {
            this.minPos.func_181079_c(x1, y1, z1);
            this.maxPos.func_181079_c(x2, y2, z2);
            this.minPosRelative.func_181079_c(x1 -= this.field_174879_c.func_177958_n(), y1 -= this.field_174879_c.func_177956_o(), z1 -= this.field_174879_c.func_177952_p());
            this.maxPosRelative.func_181079_c(x2 -= this.field_174879_c.func_177958_n(), y2 -= this.field_174879_c.func_177956_o(), z2 -= this.field_174879_c.func_177952_p());
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public double func_145833_n() {
        double d = (double)Minecraft.func_71410_x().field_71474_y.field_151451_c * 16.0;
        return d * d;
    }

    public void saveStructure(EntityPlayer author) {
        if (this.field_145850_b == null) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            CQRMain.logger.info("Server is saving structure...");
            CQStructure structure = CQStructure.createFromWorld(this.field_145850_b, (BlockPos)this.minPos, (BlockPos)this.maxPos, this.ignoreEntities.getBoolean(), Arrays.asList((Object[])this.unprotectedBlocks.get()), author.func_70005_c_());
            new Thread(() -> {
                if (structure.writeToFile(new File(CQRMain.CQ_EXPORT_FILES_FOLDER, (String)this.structureName.get() + ".nbt"))) {
                    author.func_145747_a((ITextComponent)new TextComponentString("Successfully exported structure: " + (String)this.structureName.get()));
                } else {
                    author.func_145747_a((ITextComponent)new TextComponentString("Failed to export structure: " + (String)this.structureName.get()));
                }
            }, "CQR Export Thread").start();
        } else {
            this.dataManager.checkIfDirtyAndSync();
            CQRMain.NETWORK.sendToServer((IMessage)new CPacketSaveStructureRequest(this.field_174879_c));
        }
    }

    public void setValues(String structName, BlockPos startPos, BlockPos endPos, boolean useRelativeMode, boolean ignoreEntities, BlockPos[] unprotectedBlocks) {
        this.setValues(structName, startPos.func_177958_n(), startPos.func_177956_o(), startPos.func_177952_p(), endPos.func_177958_n(), endPos.func_177956_o(), endPos.func_177952_p(), useRelativeMode, ignoreEntities, unprotectedBlocks);
    }

    public void setValues(String structName, int sX, int sY, int sZ, int eX, int eY, int eZ, boolean useRelativeMode, boolean ignoreEntities, BlockPos[] unprotectedBlocks) {
        this.structureName.set(structName);
        this.startX.set(sX);
        this.startY.set(sY);
        this.startZ.set(sZ);
        this.endX.set(eX);
        this.endY.set(eY);
        this.endZ.set(eZ);
        this.relativeMode.set(useRelativeMode);
        this.ignoreEntities.set(ignoreEntities);
        this.unprotectedBlocks.set(unprotectedBlocks);
    }

    public String getStructureName() {
        return (String)this.structureName.get();
    }

    public int getStartX() {
        return this.startX.getInt();
    }

    public int getStartY() {
        return this.startY.getInt();
    }

    public int getStartZ() {
        return this.startZ.getInt();
    }

    public int getEndX() {
        return this.endX.getInt();
    }

    public int getEndY() {
        return this.endY.getInt();
    }

    public int getEndZ() {
        return this.endZ.getInt();
    }

    public boolean isIgnoreEntities() {
        return this.ignoreEntities.getBoolean();
    }

    public boolean isRelativeMode() {
        return this.relativeMode.getBoolean();
    }

    public void setUnprotectedBlocks(BlockPos[] unprotectedBlocks) {
        this.unprotectedBlocks.set(unprotectedBlocks);
    }

    public BlockPos[] getUnprotectedBlocks() {
        return this.unprotectedBlocks.get();
    }

    public BlockPos.MutableBlockPos getMinPos() {
        return this.minPos;
    }

    public BlockPos.MutableBlockPos getMaxPos() {
        return this.maxPos;
    }

    public BlockPos getMinPosRelative() {
        return this.minPosRelative;
    }

    public BlockPos getMaxPosRelative() {
        return this.maxPosRelative;
    }
}

